// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Pierre MARECHAL <pierre.marechal@inria.fr>
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

// unit tests for dec2oct function
// =============================================================================

// Test 0
// =============================================================================
if dec2oct(0) <> "0" then pause,end

// Test 1
// =============================================================================
A = [ 1 2 3 ; 89 23 65 ];
B = [ "1"  "2" "3" ; "131" "27" "101" ];
if dec2oct(A) <> B then pause,end

// Test 2
// =============================================================================
A = [ 1 2 3 89 23 65 ];
B = [ "1"  "2" "3" "131" "27" "101" ];
if dec2oct(A) <> B then pause,end

// Test 3
// =============================================================================
A = [ 1 ; 2 ; 3 ; 89 ; 23 ; 65 ];
B = [ "1" ; "2" ; "3" ; "131" ; "27" ; "101" ];
if dec2oct(A) <> B then pause,end

// Test 4
// =============================================================================

A = [ ..
	 227753576  187720118  363924462  254129718 ; ..
	 144560203  241902046   24445188  221254898 ; ..
	 152783898   95653377  315588876  105907575 ; ..
	 221897842  274539781  344375037   96875213 ; ..
	  94894723  155357635  367247588  146326173 ; ..
	 303504480  164783285   81839000  150382476 ; ..
	 224926922   80931622  319209155    7119579 ; ..
	 250406023  174618860   79075437  105530095 ; ..
	 362338978   70370394  359659813  134269676 ; ..
	 312272440   11475496  355524574   92426834 ; ..
	 107128874  298483946  198334410  329026716 ; ..
	 200394222  170079943   53272425  295288946 ; ..
	 325437578   47890508   68985614  256312554 ; ..
	 212673794  150824615   34065526   64971211 ; ..
	 231756238  353274682   72090791  109532757 ; ..
	 155264037  151166228  215062852  144973510 ; ..
	 221536623  202093160  279243187  161179559 ; ..
	 213568657  262138257  253606393  320697531 ; ..
	 187992698   79311298  277094743   15757416 ; ..
	 249391242  330367169  311046362  202199316 ; ..
	   5628172    7402472   85882365  218301967 ; ..
	 158227087  119947892  283273178   17353821 ; ..
	 100593069  355363970  126886578  255857106 ; ..
	 133900693  341949430   28201112  355437316 ; ..
	 171413086  307444299  143987370   12352238 ; ..
	 196953051   24964259  333049769   12316245 ; ..
	 104275558  237515007   28073662  353666800 ; ..
	 195252671  339120024  183236611  200880844 ; ..
	 346522497  269118977   46553307  132120080 ; ..
	  16437365  329826486  149473901  117030434 ; ..
	 312560951  276360480     258036   73832139 ; ..
	 245680405   28459148   56639951   44463987 ; ..
	 335903448  200627322   56816225  160226995 ; ..
	 225591581   17236489  172543241  329867140 ; ..
	 254751497  200616903  310904435   77374663 ; ..
	 167107423  121511542  278255508  141000415 ; ..
	  18001015  324808816  273120495   34438380 ; ..
	 282005797   49964892  151468815  221937243 ; ..
	 326325372  151726852  295769383  199376273 ; ..
	 180186001  352409334  243840260  143459944 ; ..
	 180407152  300656485  303686940   33369229 ; ..
	 317892975  103600676  363236369  200014967 ; ..
	 304217579  301511300  277389631   98695497 ; ..
	  50393337  183015635  239695913   68394353 ; ..
	 135194946  140186904  102832734   44571238 ; ..
	 190151796  254301550  266508482  143847664 ; ..
	  33398897  189648360  343223937  213584899 ; ..
	 169428190  214434693  357044843  349835343 ; ..
	 142461674  288102279   10575067   87725144 ; ..
	  19073450    1181932  287740112  323291030 ; ..
	 302693232  192500239   49357023  353086570 ; ..
	   2886370  289052937   48851419  138081317 ; ..
	  56610336  151684153  182652556  246762133 ; ..
	  33356199   76531533   17980292   66755096 ; ..
	 266179894  361204230  280339995   62978580 ; ..
	 203009419  264755335   40184418  345471093 ; ..
	 180228109   50759486   60566733  199301560 ; ..
	  51941418  348306846  149963086  354634650 ; ..
	 168177581  199320109  335091716  171063951 ; ..
	 115743541   11313630  309145269  172353878 ; ..
	 162997784  119168320   46486506  196353983 ; ..
	 195699853   64466798  263109080   89250243 ; ..
	  53041524  170819571  152228823  256050943 ; ..
	  62945401  192413241  228892532  243173510 ; ..
	 243172728  289459266   69845566  295114146 ; ..
	 265136608  219808652  277119292   60684684 ; ..
	  46499257  239581503  231748636  162242799 ; ..
	 250895133  168264400  334596677   41263412 ; ..
	 287432720    8453678  237617396  110503069 ; ..
	  72920477  128096971  199753312  125962002 ; ..
	 298916542  351982136    9383441  361861944 ; ..
	 171765873  238275973  232405950   42309096 ; ..
	 155105735  302251516  337423242   47612838 ; ..
	 149430663  241913029  108297523  195929921 ; ..
	 108865027  340046159  358172720  359760161 ; ..
	 135681055  320139893   28394069   50484271 ; ..
	 328593571  266011465  160987341   28884544 ; ..
	  21478931  360740654  154846546  320395474 ; ..
	 340093285  164229988  309627913  139229653 ; ..
	  29876456  169404358  181538749  184982192 ; ..
	  99026370  146332486  232595031  248457034 ; ..
	  15616011  340892554   71757450  124481038 ; ..
	 308309209   57300666  111611695   71360760 ; ..
	   4811054  140005764  121845031  333404626 ; ..
	  33387724  282832372  362289171   54866656 ; ..
	 270943521  144506213    2632626  238407302 ; ..
	 308736201  312260539    5007450  338612658 ; ..
	 109035393  186546199  150965345  208061764 ; ..
	 332878686   10930872   83889293  348494697 ; ..
	 351823426  155646744  100346231  287503131 ; ..
	 212947411  211957926  358863891  217758465 ; ..
	 351963690  108079417  178533587   12721910 ; ..
	  18282285  168193253   67588567  289225807 ; ..
	 312699466   70221193  155003604  248806162 ; ..
	   9852228  160011054  214789316  118887622 ; ..
	 346557254  365754662  326949386  306806435 ; ..
	   4056029   38209175  282671628  355879455 ; ..
	 193855920   10388354  270753081   34173826 ; ..
	 222346281  256987468  251932292  201680467 ; ..
	 365066885   57836374  214402378   10719666];

B = [ ..
	"1544637150" "1314060666" "2554205756" "1711333066" ; ..
	"1047350113" "1632620736"  "135200404" "1514012362" ; ..
	"1106646032"  "554707001" "2263700414"  "624002567" ; ..
	"1516362162" "2027222405" "2441537375"  "561431315" ; ..
	 "551775203" "1120510703" "2570740344" "1056141235" ; ..
	"2205616140" "1164462265"  "470141630" "1075523614" ; ..
	"1532016312"  "464565446" "2301537303"   "33121333" ; ..
	"1673162207" "1232074354"  "455514155"  "622441357" ; ..
	"2546155242"  "414342132" "2533774445" "1000145354" ; ..
	"2247163070"   "53615050" "2514157736"  "540451122" ; ..
	 "630524052" "2162500352" "1364453712" "2347106234" ; ..
	"1374342756" "1210633307"  "313157551" "2146340162" ; ..
	"2331344212"  "266540114"  "407121416" "1721602352" ; ..
	"1453222402" "1077263247"  "201746166"  "367660713" ; ..
	"1564050716" "2503505472"  "423002247"  "641653125" ; ..
	"1120222045" "1100516424" "1464314504" "1051017306" ; ..
	"1515060557" "1402731150" "2051164663" "1146663647" ; ..
	"1456546221" "1747764621" "1707334771" "2307272273" ; ..
	"1315105172"  "456430702" "2041020527"   "74070150" ; ..
	"1667264212" "2354200301" "2242430332" "1403250424" ; ..
	  "25360414"   "34171750"  "507472775" "1500603017" ; ..
	"1133455217"  "711441164" "2070463732"  "102146135" ; ..
	 "577566655" "2513466202"  "744021262" "1720010722" ; ..
	 "776624625" "2430335766"  "153450230" "2513705404" ; ..
	"1215707136" "2224635113" "1045211252"   "57075356" ; ..
	"1357241733"  "137166243" "2366367651"   "56767125" ; ..
	 "615617146" "1612030377"  "153057276" "2505103360" ; ..
	"1350650677" "2415507630" "1272774003" "1376231314" ; ..
	"2451701601" "2002467001"  "261454333"  "767777020" ; ..
	  "76550165" "2352140266" "1072145155"  "676337042" ; ..
	"2250246467" "2036166440"     "767764"  "431513313" ; ..
	"1651144425"  "154440214"  "330040717"  "251473563" ; ..
	"2401275330" "1375252172"  "330571141" "1143157263" ; ..
	"1534440435"  "101601011" "1222146411" "2352257604" ; ..
	"1713631411" "1375225707" "2242003163"  "447122307" ; ..
	"1175355537"  "717417166" "2045353624" "1031677337" ; ..
	 "104526167" "2327030160" "2021676357"  "203276354" ; ..
	"2063610445"  "276463534" "1101635417" "1516477133" ; ..
	"2334652174" "1102625404" "2150212447" "1370436621" ; ..
	"1257265621" "2500253366" "1642132404" "1043203150" ; ..
	"1260145560" "2172723545" "2206362434"  "177226215" ; ..
	"2274524557"  "613151044" "2551506021" "1372776167" ; ..
	"2210376753" "2176131204" "2042120477"  "570374511" ; ..
	 "300170371" "1272114323" "1622274051"  "404716561" ; ..
	"1003564502" "1026612430"  "610215136"  "252015146" ; ..
	"1325276164" "1712052556" "1770514302" "1044570360" ; ..
	 "177320161" "1323346750" "2435227201" "1456606003" ; ..
	"1206242336" "1462001605" "2522011153" "2466410117" ; ..
	"1037345352" "2113013607"   "50256333"  "516512130" ; ..
	 "110604652"    "4404354" "2111510320" "2321203626" ; ..
	"2202535560" "1336251017"  "274220337" "2502726152" ; ..
	  "13005342" "2116514411"  "272264733" "1016572045" ; ..
	 "327747040" "1102502071" "1270607214" "1655245225" ; ..
	 "177174647"  "443743515"  "104455604"  "376515030" ; ..
	"1767312466" "2541705006" "2055323033"  "360175024" ; ..
	"1406326613" "1761754207"  "231225142" "2445674165" ; ..
	"1257410015"  "301503476"  "347026315" "1370214670" ; ..
	 "306110052" "2460536636" "1074040516" "2510645632" ; ..
	"1201427655" "1370261055" "2376214004" "1214435217" ; ..
	 "671415465"   "53120736" "2233227265" "1221364526" ; ..
	"1155623030"  "706456500"  "261251752" "1355017677" ; ..
	"1352422215"  "365727556" "1753534730"  "524354703" ; ..
	 "312254564" "1213477763" "1104551727" "1720603377" ; ..
	 "360074171" "1335777071" "1551117564" "1637504206" ; ..
	"1637502570" "2120146102"  "412341076" "2145612642" ; ..
	"1763324740" "1506401614" "2041100474"  "347374614" ; ..
	 "261302671" "1621734477" "1564032034" "1152720357" ; ..
	"1675055435" "1201701320" "2374305105"  "235320464" ; ..
	"2110360020"   "40177056" "1612340364"  "645422235" ; ..
	 "426126635"  "750515313" "1371777140"  "740403422" ; ..
	"2164215276" "2476551070"   "43627021" "2544311470" ; ..
	"1217170161" "1614746605" "1566435676"  "241312750" ; ..
	"1117534707" "2200776774" "2407125612"  "265501646" ; ..
	"1072020607" "1632646305"  "635076463" "1353323501" ; ..
	 "637223003" "2421130517" "2526244060" "2534300441" ; ..
	"1005452037" "2305171165"  "154241125"  "300452057" ; ..
	"2345370243" "1766601511" "1146074315"  "156137100" ; ..
	 "121737023" "2540073456" "1116542522" "2306154322" ; ..
	"2421264545" "1162371544" "2235106011" "1023074725" ; ..
	 "161760350" "1206163706" "1264407675" "1301515260" ; ..
	 "571602702" "1056155506" "1567217127" "1663623512" ; ..
	  "73444013" "2424315612"  "421567212"  "732667016" ; ..
	"2230066331"  "332453272"  "651607457"  "420160370" ; ..
	  "22264456" "1026050604"  "720632447" "2367654722" ; ..
	 "177272314" "2066726764" "2546014023"  "321231340" ; ..
	"2011442441" "1047176545"   "12025662" "1615347206" ; ..
	"2231570311" "2247133673"   "23064132" "2413550662" ; ..
	 "637737601" "1307474027" "1077706141" "1431542504" ; ..
	"2365651536"   "51545270"  "500006215" "2461315551" ; ..
	"2476063102" "1121575430"  "576624567" "2110571433" ; ..
	"1454250723" "1450434246" "2530752023" "1476535401" ; ..
	"2476505052"  "634224471" "1251032323"   "60417366" ; ..
	 "105573455" "1201466345"  "401650727" "2117236117" ; ..
	"2250665112"  "413676611" "1117225324" "1665075422" ; ..
	  "45452504" "1142311456" "1463266304"  "705412306" ; ..
	"2452005506" "2563174446" "2337155012" "2222277243" ; ..
	  "17361735"  "221603227" "2066235014" "2515445037" ; ..
	"1343400660"   "47501602" "2010656471"  "202271602" ; ..
	"1520136051" "1724250514" "1701027204" "1401263123" ; ..
	"2560475205"  "334501526" "1461702512"   "50710662"];

if or(dec2oct(A)<>B) then pause,end
