from __future__ import print_function
from _mock import _Mock




base_aliases = _Mock()

base_flags = _Mock()

boolean_flag = _Mock()

catch_config_error = _Mock()

check_call = _Mock()

daemonize = _Mock()

engine_aliases = _Mock()

engine_flags = _Mock()

errno = _Mock()

find_launcher_class = _Mock()

import_item = _Mock()

ioloop = _Mock()

launch_new_instance = _Mock()

logging = _Mock()

num_cpus = _Mock()

os = _Mock()

re = _Mock()

signal = _Mock()

start_aliases = _Mock()

stop_aliases = _Mock()

zmq = _Mock()

ALREADY_STARTED = 10

ALREADY_STOPPED = 11

NO_CLUSTER = 12

PIPE = -1

_description = "Start an IPython cluster for parallel computing.\n\nAn IPython cluster consists of 1 controller and 1 or more engines.\nThis command automates the startup of these processes using a wide range of\nstartup methods (SSH, local processes, PBS, mpiexec, SGE, LSF, HTCondor,\nWindows HPC Server 2008). To start a cluster with 4 engines on your\nlocal host simply do 'ipcluster start --n=4'. For more complex usage\nyou will typically do 'ipython profile create mycluster --parallel', then edit\nconfiguration files, followed by 'ipcluster start --profile=mycluster --n=4'.\n"

_engines_examples = '\nipcluster engines --profile=mycluster --n=4  # start 4 engines only\n'

_main_examples = '\nipcluster start --n=4 # start a 4 node cluster on localhost\nipcluster start -h    # show the help string for the start subcmd\n\nipcluster stop -h     # show the help string for the stop subcmd\nipcluster engines -h  # show the help string for the engines subcmd\n'

_start_examples = '\nipython profile create mycluster --parallel # create mycluster profile\nipcluster start --profile=mycluster --n=4   # start mycluster with 4 nodes\n'

_stop_examples = '\nipcluster stop --profile=mycluster  # stop a running cluster by profile name\n'

base = 'IPython.parallel.apps.ipclusterapp.IPCluster'

engines_help = "Start engines connected to an existing IPython cluster\n\nStart one or more engines to connect to an existing Cluster\nby profile name or cluster directory.\nCluster directories contain configuration, log and\nsecurity related files and are named using the convention\n'profile_<name>' and should be creating using the 'start'\nsubcommand of 'ipcluster'. If your cluster directory is in\nthe cwd or the ipython directory, you can simply refer to it\nusing its profile name, 'ipcluster engines --n=4 --profile=<profile>`,\notherwise use the 'profile-dir' option.\n"

start_help = "Start an IPython cluster for parallel computing\n\nStart an ipython cluster by its profile name or cluster\ndirectory. Cluster directories contain configuration, log and\nsecurity related files and are named using the convention\n'profile_<name>' and should be creating using the 'start'\nsubcommand of 'ipcluster'. If your cluster directory is in\nthe cwd or the ipython directory, you can simply refer to it\nusing its profile name, 'ipcluster start --n=4 --profile=<profile>`,\notherwise use the 'profile-dir' option.\n"

stop_help = "Stop a running IPython cluster\n\nStop a running ipython cluster by its profile name or cluster\ndirectory. Cluster directories are named using the convention\n'profile_<name>'. If your cluster directory is in\nthe cwd or the ipython directory, you can simply refer to it\nusing its profile name, 'ipcluster stop --profile=<profile>`, otherwise\nuse the '--profile-dir' option.\n"

class Any(_Mock):
  pass
  info_text = 'any value'

class Application(_Mock):
  pass


class BaseIPythonApplication(_Mock):
  pass
  _in_init_profile_dir = False

class BaseParallelApplication(_Mock):
  pass
  _in_init_profile_dir = False

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class CFloat(_Mock):
  pass
  default_value = 0.0
  info_text = 'a float'

class CalledProcessError(_Mock):
  pass


class Config(_Mock):
  pass


class Dict(_Mock):
  pass
  info_text = 'any value'

class DottedObjectName(_Mock):
  pass
  info_text = 'a valid object identifier in Python'

class IPClusterApp(_Mock):
  pass
  _in_init_profile_dir = False
  description = "Start an IPython cluster for parallel computing.\n\nAn IPython cluster consists of 1 controller and 1 or more engines.\nThis command automates the startup of these processes using a wide range of\nstartup methods (SSH, local processes, PBS, mpiexec, SGE, LSF, HTCondor,\nWindows HPC Server 2008). To start a cluster with 4 engines on your\nlocal host simply do 'ipcluster start --n=4'. For more complex usage\nyou will typically do 'ipython profile create mycluster --parallel', then edit\nconfiguration files, followed by 'ipcluster start --profile=mycluster --n=4'.\n"
  examples = '\nipcluster start --n=4 # start a 4 node cluster on localhost\nipcluster start -h    # show the help string for the start subcmd\n\nipcluster stop -h     # show the help string for the stop subcmd\nipcluster engines -h  # show the help string for the engines subcmd\n'
  name = u'ipcluster'

class IPClusterEngines(_Mock):
  pass
  _in_init_profile_dir = False
  _stopping = False
  default_log_level = 20
  description = "Start engines connected to an existing IPython cluster\n\nStart one or more engines to connect to an existing Cluster\nby profile name or cluster directory.\nCluster directories contain configuration, log and\nsecurity related files and are named using the convention\n'profile_<name>' and should be creating using the 'start'\nsubcommand of 'ipcluster'. If your cluster directory is in\nthe cwd or the ipython directory, you can simply refer to it\nusing its profile name, 'ipcluster engines --n=4 --profile=<profile>`,\notherwise use the 'profile-dir' option.\n"
  examples = '\nipcluster engines --profile=mycluster --n=4  # start 4 engines only\n'
  name = u'ipcluster'

class IPClusterStart(_Mock):
  pass
  _in_init_profile_dir = False
  _stopping = False
  default_log_level = 20
  description = "Start an IPython cluster for parallel computing\n\nStart an ipython cluster by its profile name or cluster\ndirectory. Cluster directories contain configuration, log and\nsecurity related files and are named using the convention\n'profile_<name>' and should be creating using the 'start'\nsubcommand of 'ipcluster'. If your cluster directory is in\nthe cwd or the ipython directory, you can simply refer to it\nusing its profile name, 'ipcluster start --n=4 --profile=<profile>`,\notherwise use the 'profile-dir' option.\n"
  examples = '\nipython profile create mycluster --parallel # create mycluster profile\nipcluster start --profile=mycluster --n=4   # start mycluster with 4 nodes\n'
  name = u'ipcluster'

class IPClusterStop(_Mock):
  pass
  _in_init_profile_dir = False
  description = "Stop a running IPython cluster\n\nStop a running ipython cluster by its profile name or cluster\ndirectory. Cluster directories are named using the convention\n'profile_<name>'. If your cluster directory is in\nthe cwd or the ipython directory, you can simply refer to it\nusing its profile name, 'ipcluster stop --profile=<profile>`, otherwise\nuse the '--profile-dir' option.\n"
  examples = '\nipcluster stop --profile=mycluster  # stop a running cluster by profile name\n'
  name = u'ipcluster'

class Integer(_Mock):
  pass
  default_value = 0
  info_text = 'an integer'

class List(_Mock):
  pass
  info_text = 'any value'

class PIDFileError(_Mock):
  pass


class ProfileDir(_Mock):
  pass


class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

