use super::{Entity, Codepoints};


/// The static constant array of entity definitions.
///
/// Data generated from <https://www.w3.org/TR/html5/entities.json>
pub static ENTITIES: [Entity; 2231] = [
    Entity { entity: "&Aacute;", codepoints: Codepoints::Single(193), characters: "Á" },
    Entity { entity: "&Aacute", codepoints: Codepoints::Single(193), characters: "Á" },
    Entity { entity: "&aacute;", codepoints: Codepoints::Single(225), characters: "á" },
    Entity { entity: "&aacute", codepoints: Codepoints::Single(225), characters: "á" },
    Entity { entity: "&Abreve;", codepoints: Codepoints::Single(258), characters: "Ă" },
    Entity { entity: "&abreve;", codepoints: Codepoints::Single(259), characters: "ă" },
    Entity { entity: "&ac;", codepoints: Codepoints::Single(8766), characters: "∾" },
    Entity { entity: "&acd;", codepoints: Codepoints::Single(8767), characters: "∿" },
    Entity { entity: "&acE;", codepoints: Codepoints::Double(8766, 819), characters: "∾̳" },
    Entity { entity: "&Acirc;", codepoints: Codepoints::Single(194), characters: "Â" },
    Entity { entity: "&Acirc", codepoints: Codepoints::Single(194), characters: "Â" },
    Entity { entity: "&acirc;", codepoints: Codepoints::Single(226), characters: "â" },
    Entity { entity: "&acirc", codepoints: Codepoints::Single(226), characters: "â" },
    Entity { entity: "&acute;", codepoints: Codepoints::Single(180), characters: "´" },
    Entity { entity: "&acute", codepoints: Codepoints::Single(180), characters: "´" },
    Entity { entity: "&Acy;", codepoints: Codepoints::Single(1040), characters: "А" },
    Entity { entity: "&acy;", codepoints: Codepoints::Single(1072), characters: "а" },
    Entity { entity: "&AElig;", codepoints: Codepoints::Single(198), characters: "Æ" },
    Entity { entity: "&AElig", codepoints: Codepoints::Single(198), characters: "Æ" },
    Entity { entity: "&aelig;", codepoints: Codepoints::Single(230), characters: "æ" },
    Entity { entity: "&aelig", codepoints: Codepoints::Single(230), characters: "æ" },
    Entity { entity: "&af;", codepoints: Codepoints::Single(8289), characters: "⁡" },
    Entity { entity: "&Afr;", codepoints: Codepoints::Single(120068), characters: "𝔄" },
    Entity { entity: "&afr;", codepoints: Codepoints::Single(120094), characters: "𝔞" },
    Entity { entity: "&Agrave;", codepoints: Codepoints::Single(192), characters: "À" },
    Entity { entity: "&Agrave", codepoints: Codepoints::Single(192), characters: "À" },
    Entity { entity: "&agrave;", codepoints: Codepoints::Single(224), characters: "à" },
    Entity { entity: "&agrave", codepoints: Codepoints::Single(224), characters: "à" },
    Entity { entity: "&alefsym;", codepoints: Codepoints::Single(8501), characters: "ℵ" },
    Entity { entity: "&aleph;", codepoints: Codepoints::Single(8501), characters: "ℵ" },
    Entity { entity: "&Alpha;", codepoints: Codepoints::Single(913), characters: "Α" },
    Entity { entity: "&alpha;", codepoints: Codepoints::Single(945), characters: "α" },
    Entity { entity: "&Amacr;", codepoints: Codepoints::Single(256), characters: "Ā" },
    Entity { entity: "&amacr;", codepoints: Codepoints::Single(257), characters: "ā" },
    Entity { entity: "&amalg;", codepoints: Codepoints::Single(10815), characters: "⨿" },
    Entity { entity: "&AMP;", codepoints: Codepoints::Single(38), characters: "&" },
    Entity { entity: "&AMP", codepoints: Codepoints::Single(38), characters: "&" },
    Entity { entity: "&amp;", codepoints: Codepoints::Single(38), characters: "&" },
    Entity { entity: "&amp", codepoints: Codepoints::Single(38), characters: "&" },
    Entity { entity: "&And;", codepoints: Codepoints::Single(10835), characters: "⩓" },
    Entity { entity: "&and;", codepoints: Codepoints::Single(8743), characters: "∧" },
    Entity { entity: "&andand;", codepoints: Codepoints::Single(10837), characters: "⩕" },
    Entity { entity: "&andd;", codepoints: Codepoints::Single(10844), characters: "⩜" },
    Entity { entity: "&andslope;", codepoints: Codepoints::Single(10840), characters: "⩘" },
    Entity { entity: "&andv;", codepoints: Codepoints::Single(10842), characters: "⩚" },
    Entity { entity: "&ang;", codepoints: Codepoints::Single(8736), characters: "∠" },
    Entity { entity: "&ange;", codepoints: Codepoints::Single(10660), characters: "⦤" },
    Entity { entity: "&angle;", codepoints: Codepoints::Single(8736), characters: "∠" },
    Entity { entity: "&angmsd;", codepoints: Codepoints::Single(8737), characters: "∡" },
    Entity { entity: "&angmsdaa;", codepoints: Codepoints::Single(10664), characters: "⦨" },
    Entity { entity: "&angmsdab;", codepoints: Codepoints::Single(10665), characters: "⦩" },
    Entity { entity: "&angmsdac;", codepoints: Codepoints::Single(10666), characters: "⦪" },
    Entity { entity: "&angmsdad;", codepoints: Codepoints::Single(10667), characters: "⦫" },
    Entity { entity: "&angmsdae;", codepoints: Codepoints::Single(10668), characters: "⦬" },
    Entity { entity: "&angmsdaf;", codepoints: Codepoints::Single(10669), characters: "⦭" },
    Entity { entity: "&angmsdag;", codepoints: Codepoints::Single(10670), characters: "⦮" },
    Entity { entity: "&angmsdah;", codepoints: Codepoints::Single(10671), characters: "⦯" },
    Entity { entity: "&angrt;", codepoints: Codepoints::Single(8735), characters: "∟" },
    Entity { entity: "&angrtvb;", codepoints: Codepoints::Single(8894), characters: "⊾" },
    Entity { entity: "&angrtvbd;", codepoints: Codepoints::Single(10653), characters: "⦝" },
    Entity { entity: "&angsph;", codepoints: Codepoints::Single(8738), characters: "∢" },
    Entity { entity: "&angst;", codepoints: Codepoints::Single(197), characters: "Å" },
    Entity { entity: "&angzarr;", codepoints: Codepoints::Single(9084), characters: "⍼" },
    Entity { entity: "&Aogon;", codepoints: Codepoints::Single(260), characters: "Ą" },
    Entity { entity: "&aogon;", codepoints: Codepoints::Single(261), characters: "ą" },
    Entity { entity: "&Aopf;", codepoints: Codepoints::Single(120120), characters: "𝔸" },
    Entity { entity: "&aopf;", codepoints: Codepoints::Single(120146), characters: "𝕒" },
    Entity { entity: "&ap;", codepoints: Codepoints::Single(8776), characters: "≈" },
    Entity { entity: "&apacir;", codepoints: Codepoints::Single(10863), characters: "⩯" },
    Entity { entity: "&apE;", codepoints: Codepoints::Single(10864), characters: "⩰" },
    Entity { entity: "&ape;", codepoints: Codepoints::Single(8778), characters: "≊" },
    Entity { entity: "&apid;", codepoints: Codepoints::Single(8779), characters: "≋" },
    Entity { entity: "&apos;", codepoints: Codepoints::Single(39), characters: "'" },
    Entity { entity: "&ApplyFunction;", codepoints: Codepoints::Single(8289), characters: "⁡" },
    Entity { entity: "&approx;", codepoints: Codepoints::Single(8776), characters: "≈" },
    Entity { entity: "&approxeq;", codepoints: Codepoints::Single(8778), characters: "≊" },
    Entity { entity: "&Aring;", codepoints: Codepoints::Single(197), characters: "Å" },
    Entity { entity: "&Aring", codepoints: Codepoints::Single(197), characters: "Å" },
    Entity { entity: "&aring;", codepoints: Codepoints::Single(229), characters: "å" },
    Entity { entity: "&aring", codepoints: Codepoints::Single(229), characters: "å" },
    Entity { entity: "&Ascr;", codepoints: Codepoints::Single(119964), characters: "𝒜" },
    Entity { entity: "&ascr;", codepoints: Codepoints::Single(119990), characters: "𝒶" },
    Entity { entity: "&Assign;", codepoints: Codepoints::Single(8788), characters: "≔" },
    Entity { entity: "&ast;", codepoints: Codepoints::Single(42), characters: "*" },
    Entity { entity: "&asymp;", codepoints: Codepoints::Single(8776), characters: "≈" },
    Entity { entity: "&asympeq;", codepoints: Codepoints::Single(8781), characters: "≍" },
    Entity { entity: "&Atilde;", codepoints: Codepoints::Single(195), characters: "Ã" },
    Entity { entity: "&Atilde", codepoints: Codepoints::Single(195), characters: "Ã" },
    Entity { entity: "&atilde;", codepoints: Codepoints::Single(227), characters: "ã" },
    Entity { entity: "&atilde", codepoints: Codepoints::Single(227), characters: "ã" },
    Entity { entity: "&Auml;", codepoints: Codepoints::Single(196), characters: "Ä" },
    Entity { entity: "&Auml", codepoints: Codepoints::Single(196), characters: "Ä" },
    Entity { entity: "&auml;", codepoints: Codepoints::Single(228), characters: "ä" },
    Entity { entity: "&auml", codepoints: Codepoints::Single(228), characters: "ä" },
    Entity { entity: "&awconint;", codepoints: Codepoints::Single(8755), characters: "∳" },
    Entity { entity: "&awint;", codepoints: Codepoints::Single(10769), characters: "⨑" },
    Entity { entity: "&backcong;", codepoints: Codepoints::Single(8780), characters: "≌" },
    Entity { entity: "&backepsilon;", codepoints: Codepoints::Single(1014), characters: "϶" },
    Entity { entity: "&backprime;", codepoints: Codepoints::Single(8245), characters: "‵" },
    Entity { entity: "&backsim;", codepoints: Codepoints::Single(8765), characters: "∽" },
    Entity { entity: "&backsimeq;", codepoints: Codepoints::Single(8909), characters: "⋍" },
    Entity { entity: "&Backslash;", codepoints: Codepoints::Single(8726), characters: "∖" },
    Entity { entity: "&Barv;", codepoints: Codepoints::Single(10983), characters: "⫧" },
    Entity { entity: "&barvee;", codepoints: Codepoints::Single(8893), characters: "⊽" },
    Entity { entity: "&Barwed;", codepoints: Codepoints::Single(8966), characters: "⌆" },
    Entity { entity: "&barwed;", codepoints: Codepoints::Single(8965), characters: "⌅" },
    Entity { entity: "&barwedge;", codepoints: Codepoints::Single(8965), characters: "⌅" },
    Entity { entity: "&bbrk;", codepoints: Codepoints::Single(9141), characters: "⎵" },
    Entity { entity: "&bbrktbrk;", codepoints: Codepoints::Single(9142), characters: "⎶" },
    Entity { entity: "&bcong;", codepoints: Codepoints::Single(8780), characters: "≌" },
    Entity { entity: "&Bcy;", codepoints: Codepoints::Single(1041), characters: "Б" },
    Entity { entity: "&bcy;", codepoints: Codepoints::Single(1073), characters: "б" },
    Entity { entity: "&bdquo;", codepoints: Codepoints::Single(8222), characters: "„" },
    Entity { entity: "&becaus;", codepoints: Codepoints::Single(8757), characters: "∵" },
    Entity { entity: "&Because;", codepoints: Codepoints::Single(8757), characters: "∵" },
    Entity { entity: "&because;", codepoints: Codepoints::Single(8757), characters: "∵" },
    Entity { entity: "&bemptyv;", codepoints: Codepoints::Single(10672), characters: "⦰" },
    Entity { entity: "&bepsi;", codepoints: Codepoints::Single(1014), characters: "϶" },
    Entity { entity: "&bernou;", codepoints: Codepoints::Single(8492), characters: "ℬ" },
    Entity { entity: "&Bernoullis;", codepoints: Codepoints::Single(8492), characters: "ℬ" },
    Entity { entity: "&Beta;", codepoints: Codepoints::Single(914), characters: "Β" },
    Entity { entity: "&beta;", codepoints: Codepoints::Single(946), characters: "β" },
    Entity { entity: "&beth;", codepoints: Codepoints::Single(8502), characters: "ℶ" },
    Entity { entity: "&between;", codepoints: Codepoints::Single(8812), characters: "≬" },
    Entity { entity: "&Bfr;", codepoints: Codepoints::Single(120069), characters: "𝔅" },
    Entity { entity: "&bfr;", codepoints: Codepoints::Single(120095), characters: "𝔟" },
    Entity { entity: "&bigcap;", codepoints: Codepoints::Single(8898), characters: "⋂" },
    Entity { entity: "&bigcirc;", codepoints: Codepoints::Single(9711), characters: "◯" },
    Entity { entity: "&bigcup;", codepoints: Codepoints::Single(8899), characters: "⋃" },
    Entity { entity: "&bigodot;", codepoints: Codepoints::Single(10752), characters: "⨀" },
    Entity { entity: "&bigoplus;", codepoints: Codepoints::Single(10753), characters: "⨁" },
    Entity { entity: "&bigotimes;", codepoints: Codepoints::Single(10754), characters: "⨂" },
    Entity { entity: "&bigsqcup;", codepoints: Codepoints::Single(10758), characters: "⨆" },
    Entity { entity: "&bigstar;", codepoints: Codepoints::Single(9733), characters: "★" },
    Entity { entity: "&bigtriangledown;", codepoints: Codepoints::Single(9661), characters: "▽" },
    Entity { entity: "&bigtriangleup;", codepoints: Codepoints::Single(9651), characters: "△" },
    Entity { entity: "&biguplus;", codepoints: Codepoints::Single(10756), characters: "⨄" },
    Entity { entity: "&bigvee;", codepoints: Codepoints::Single(8897), characters: "⋁" },
    Entity { entity: "&bigwedge;", codepoints: Codepoints::Single(8896), characters: "⋀" },
    Entity { entity: "&bkarow;", codepoints: Codepoints::Single(10509), characters: "⤍" },
    Entity { entity: "&blacklozenge;", codepoints: Codepoints::Single(10731), characters: "⧫" },
    Entity { entity: "&blacksquare;", codepoints: Codepoints::Single(9642), characters: "▪" },
    Entity { entity: "&blacktriangle;", codepoints: Codepoints::Single(9652), characters: "▴" },
    Entity { entity: "&blacktriangledown;", codepoints: Codepoints::Single(9662), characters: "▾" },
    Entity { entity: "&blacktriangleleft;", codepoints: Codepoints::Single(9666), characters: "◂" },
    Entity { entity: "&blacktriangleright;", codepoints: Codepoints::Single(9656), characters: "▸" },
    Entity { entity: "&blank;", codepoints: Codepoints::Single(9251), characters: "␣" },
    Entity { entity: "&blk12;", codepoints: Codepoints::Single(9618), characters: "▒" },
    Entity { entity: "&blk14;", codepoints: Codepoints::Single(9617), characters: "░" },
    Entity { entity: "&blk34;", codepoints: Codepoints::Single(9619), characters: "▓" },
    Entity { entity: "&block;", codepoints: Codepoints::Single(9608), characters: "█" },
    Entity { entity: "&bne;", codepoints: Codepoints::Double(61, 8421), characters: "=⃥" },
    Entity { entity: "&bnequiv;", codepoints: Codepoints::Double(8801, 8421), characters: "≡⃥" },
    Entity { entity: "&bNot;", codepoints: Codepoints::Single(10989), characters: "⫭" },
    Entity { entity: "&bnot;", codepoints: Codepoints::Single(8976), characters: "⌐" },
    Entity { entity: "&Bopf;", codepoints: Codepoints::Single(120121), characters: "𝔹" },
    Entity { entity: "&bopf;", codepoints: Codepoints::Single(120147), characters: "𝕓" },
    Entity { entity: "&bot;", codepoints: Codepoints::Single(8869), characters: "⊥" },
    Entity { entity: "&bottom;", codepoints: Codepoints::Single(8869), characters: "⊥" },
    Entity { entity: "&bowtie;", codepoints: Codepoints::Single(8904), characters: "⋈" },
    Entity { entity: "&boxbox;", codepoints: Codepoints::Single(10697), characters: "⧉" },
    Entity { entity: "&boxDL;", codepoints: Codepoints::Single(9559), characters: "╗" },
    Entity { entity: "&boxDl;", codepoints: Codepoints::Single(9558), characters: "╖" },
    Entity { entity: "&boxdL;", codepoints: Codepoints::Single(9557), characters: "╕" },
    Entity { entity: "&boxdl;", codepoints: Codepoints::Single(9488), characters: "┐" },
    Entity { entity: "&boxDR;", codepoints: Codepoints::Single(9556), characters: "╔" },
    Entity { entity: "&boxDr;", codepoints: Codepoints::Single(9555), characters: "╓" },
    Entity { entity: "&boxdR;", codepoints: Codepoints::Single(9554), characters: "╒" },
    Entity { entity: "&boxdr;", codepoints: Codepoints::Single(9484), characters: "┌" },
    Entity { entity: "&boxH;", codepoints: Codepoints::Single(9552), characters: "═" },
    Entity { entity: "&boxh;", codepoints: Codepoints::Single(9472), characters: "─" },
    Entity { entity: "&boxHD;", codepoints: Codepoints::Single(9574), characters: "╦" },
    Entity { entity: "&boxHd;", codepoints: Codepoints::Single(9572), characters: "╤" },
    Entity { entity: "&boxhD;", codepoints: Codepoints::Single(9573), characters: "╥" },
    Entity { entity: "&boxhd;", codepoints: Codepoints::Single(9516), characters: "┬" },
    Entity { entity: "&boxHU;", codepoints: Codepoints::Single(9577), characters: "╩" },
    Entity { entity: "&boxHu;", codepoints: Codepoints::Single(9575), characters: "╧" },
    Entity { entity: "&boxhU;", codepoints: Codepoints::Single(9576), characters: "╨" },
    Entity { entity: "&boxhu;", codepoints: Codepoints::Single(9524), characters: "┴" },
    Entity { entity: "&boxminus;", codepoints: Codepoints::Single(8863), characters: "⊟" },
    Entity { entity: "&boxplus;", codepoints: Codepoints::Single(8862), characters: "⊞" },
    Entity { entity: "&boxtimes;", codepoints: Codepoints::Single(8864), characters: "⊠" },
    Entity { entity: "&boxUL;", codepoints: Codepoints::Single(9565), characters: "╝" },
    Entity { entity: "&boxUl;", codepoints: Codepoints::Single(9564), characters: "╜" },
    Entity { entity: "&boxuL;", codepoints: Codepoints::Single(9563), characters: "╛" },
    Entity { entity: "&boxul;", codepoints: Codepoints::Single(9496), characters: "┘" },
    Entity { entity: "&boxUR;", codepoints: Codepoints::Single(9562), characters: "╚" },
    Entity { entity: "&boxUr;", codepoints: Codepoints::Single(9561), characters: "╙" },
    Entity { entity: "&boxuR;", codepoints: Codepoints::Single(9560), characters: "╘" },
    Entity { entity: "&boxur;", codepoints: Codepoints::Single(9492), characters: "└" },
    Entity { entity: "&boxV;", codepoints: Codepoints::Single(9553), characters: "║" },
    Entity { entity: "&boxv;", codepoints: Codepoints::Single(9474), characters: "│" },
    Entity { entity: "&boxVH;", codepoints: Codepoints::Single(9580), characters: "╬" },
    Entity { entity: "&boxVh;", codepoints: Codepoints::Single(9579), characters: "╫" },
    Entity { entity: "&boxvH;", codepoints: Codepoints::Single(9578), characters: "╪" },
    Entity { entity: "&boxvh;", codepoints: Codepoints::Single(9532), characters: "┼" },
    Entity { entity: "&boxVL;", codepoints: Codepoints::Single(9571), characters: "╣" },
    Entity { entity: "&boxVl;", codepoints: Codepoints::Single(9570), characters: "╢" },
    Entity { entity: "&boxvL;", codepoints: Codepoints::Single(9569), characters: "╡" },
    Entity { entity: "&boxvl;", codepoints: Codepoints::Single(9508), characters: "┤" },
    Entity { entity: "&boxVR;", codepoints: Codepoints::Single(9568), characters: "╠" },
    Entity { entity: "&boxVr;", codepoints: Codepoints::Single(9567), characters: "╟" },
    Entity { entity: "&boxvR;", codepoints: Codepoints::Single(9566), characters: "╞" },
    Entity { entity: "&boxvr;", codepoints: Codepoints::Single(9500), characters: "├" },
    Entity { entity: "&bprime;", codepoints: Codepoints::Single(8245), characters: "‵" },
    Entity { entity: "&Breve;", codepoints: Codepoints::Single(728), characters: "˘" },
    Entity { entity: "&breve;", codepoints: Codepoints::Single(728), characters: "˘" },
    Entity { entity: "&brvbar;", codepoints: Codepoints::Single(166), characters: "¦" },
    Entity { entity: "&brvbar", codepoints: Codepoints::Single(166), characters: "¦" },
    Entity { entity: "&Bscr;", codepoints: Codepoints::Single(8492), characters: "ℬ" },
    Entity { entity: "&bscr;", codepoints: Codepoints::Single(119991), characters: "𝒷" },
    Entity { entity: "&bsemi;", codepoints: Codepoints::Single(8271), characters: "⁏" },
    Entity { entity: "&bsim;", codepoints: Codepoints::Single(8765), characters: "∽" },
    Entity { entity: "&bsime;", codepoints: Codepoints::Single(8909), characters: "⋍" },
    Entity { entity: "&bsol;", codepoints: Codepoints::Single(92), characters: "\\" },
    Entity { entity: "&bsolb;", codepoints: Codepoints::Single(10693), characters: "⧅" },
    Entity { entity: "&bsolhsub;", codepoints: Codepoints::Single(10184), characters: "⟈" },
    Entity { entity: "&bull;", codepoints: Codepoints::Single(8226), characters: "•" },
    Entity { entity: "&bullet;", codepoints: Codepoints::Single(8226), characters: "•" },
    Entity { entity: "&bump;", codepoints: Codepoints::Single(8782), characters: "≎" },
    Entity { entity: "&bumpE;", codepoints: Codepoints::Single(10926), characters: "⪮" },
    Entity { entity: "&bumpe;", codepoints: Codepoints::Single(8783), characters: "≏" },
    Entity { entity: "&Bumpeq;", codepoints: Codepoints::Single(8782), characters: "≎" },
    Entity { entity: "&bumpeq;", codepoints: Codepoints::Single(8783), characters: "≏" },
    Entity { entity: "&Cacute;", codepoints: Codepoints::Single(262), characters: "Ć" },
    Entity { entity: "&cacute;", codepoints: Codepoints::Single(263), characters: "ć" },
    Entity { entity: "&Cap;", codepoints: Codepoints::Single(8914), characters: "⋒" },
    Entity { entity: "&cap;", codepoints: Codepoints::Single(8745), characters: "∩" },
    Entity { entity: "&capand;", codepoints: Codepoints::Single(10820), characters: "⩄" },
    Entity { entity: "&capbrcup;", codepoints: Codepoints::Single(10825), characters: "⩉" },
    Entity { entity: "&capcap;", codepoints: Codepoints::Single(10827), characters: "⩋" },
    Entity { entity: "&capcup;", codepoints: Codepoints::Single(10823), characters: "⩇" },
    Entity { entity: "&capdot;", codepoints: Codepoints::Single(10816), characters: "⩀" },
    Entity { entity: "&CapitalDifferentialD;", codepoints: Codepoints::Single(8517), characters: "ⅅ" },
    Entity { entity: "&caps;", codepoints: Codepoints::Double(8745, 65024), characters: "∩︀" },
    Entity { entity: "&caret;", codepoints: Codepoints::Single(8257), characters: "⁁" },
    Entity { entity: "&caron;", codepoints: Codepoints::Single(711), characters: "ˇ" },
    Entity { entity: "&Cayleys;", codepoints: Codepoints::Single(8493), characters: "ℭ" },
    Entity { entity: "&ccaps;", codepoints: Codepoints::Single(10829), characters: "⩍" },
    Entity { entity: "&Ccaron;", codepoints: Codepoints::Single(268), characters: "Č" },
    Entity { entity: "&ccaron;", codepoints: Codepoints::Single(269), characters: "č" },
    Entity { entity: "&Ccedil;", codepoints: Codepoints::Single(199), characters: "Ç" },
    Entity { entity: "&Ccedil", codepoints: Codepoints::Single(199), characters: "Ç" },
    Entity { entity: "&ccedil;", codepoints: Codepoints::Single(231), characters: "ç" },
    Entity { entity: "&ccedil", codepoints: Codepoints::Single(231), characters: "ç" },
    Entity { entity: "&Ccirc;", codepoints: Codepoints::Single(264), characters: "Ĉ" },
    Entity { entity: "&ccirc;", codepoints: Codepoints::Single(265), characters: "ĉ" },
    Entity { entity: "&Cconint;", codepoints: Codepoints::Single(8752), characters: "∰" },
    Entity { entity: "&ccups;", codepoints: Codepoints::Single(10828), characters: "⩌" },
    Entity { entity: "&ccupssm;", codepoints: Codepoints::Single(10832), characters: "⩐" },
    Entity { entity: "&Cdot;", codepoints: Codepoints::Single(266), characters: "Ċ" },
    Entity { entity: "&cdot;", codepoints: Codepoints::Single(267), characters: "ċ" },
    Entity { entity: "&cedil;", codepoints: Codepoints::Single(184), characters: "¸" },
    Entity { entity: "&cedil", codepoints: Codepoints::Single(184), characters: "¸" },
    Entity { entity: "&Cedilla;", codepoints: Codepoints::Single(184), characters: "¸" },
    Entity { entity: "&cemptyv;", codepoints: Codepoints::Single(10674), characters: "⦲" },
    Entity { entity: "&cent;", codepoints: Codepoints::Single(162), characters: "¢" },
    Entity { entity: "&cent", codepoints: Codepoints::Single(162), characters: "¢" },
    Entity { entity: "&CenterDot;", codepoints: Codepoints::Single(183), characters: "·" },
    Entity { entity: "&centerdot;", codepoints: Codepoints::Single(183), characters: "·" },
    Entity { entity: "&Cfr;", codepoints: Codepoints::Single(8493), characters: "ℭ" },
    Entity { entity: "&cfr;", codepoints: Codepoints::Single(120096), characters: "𝔠" },
    Entity { entity: "&CHcy;", codepoints: Codepoints::Single(1063), characters: "Ч" },
    Entity { entity: "&chcy;", codepoints: Codepoints::Single(1095), characters: "ч" },
    Entity { entity: "&check;", codepoints: Codepoints::Single(10003), characters: "✓" },
    Entity { entity: "&checkmark;", codepoints: Codepoints::Single(10003), characters: "✓" },
    Entity { entity: "&Chi;", codepoints: Codepoints::Single(935), characters: "Χ" },
    Entity { entity: "&chi;", codepoints: Codepoints::Single(967), characters: "χ" },
    Entity { entity: "&cir;", codepoints: Codepoints::Single(9675), characters: "○" },
    Entity { entity: "&circ;", codepoints: Codepoints::Single(710), characters: "ˆ" },
    Entity { entity: "&circeq;", codepoints: Codepoints::Single(8791), characters: "≗" },
    Entity { entity: "&circlearrowleft;", codepoints: Codepoints::Single(8634), characters: "↺" },
    Entity { entity: "&circlearrowright;", codepoints: Codepoints::Single(8635), characters: "↻" },
    Entity { entity: "&circledast;", codepoints: Codepoints::Single(8859), characters: "⊛" },
    Entity { entity: "&circledcirc;", codepoints: Codepoints::Single(8858), characters: "⊚" },
    Entity { entity: "&circleddash;", codepoints: Codepoints::Single(8861), characters: "⊝" },
    Entity { entity: "&CircleDot;", codepoints: Codepoints::Single(8857), characters: "⊙" },
    Entity { entity: "&circledR;", codepoints: Codepoints::Single(174), characters: "®" },
    Entity { entity: "&circledS;", codepoints: Codepoints::Single(9416), characters: "Ⓢ" },
    Entity { entity: "&CircleMinus;", codepoints: Codepoints::Single(8854), characters: "⊖" },
    Entity { entity: "&CirclePlus;", codepoints: Codepoints::Single(8853), characters: "⊕" },
    Entity { entity: "&CircleTimes;", codepoints: Codepoints::Single(8855), characters: "⊗" },
    Entity { entity: "&cirE;", codepoints: Codepoints::Single(10691), characters: "⧃" },
    Entity { entity: "&cire;", codepoints: Codepoints::Single(8791), characters: "≗" },
    Entity { entity: "&cirfnint;", codepoints: Codepoints::Single(10768), characters: "⨐" },
    Entity { entity: "&cirmid;", codepoints: Codepoints::Single(10991), characters: "⫯" },
    Entity { entity: "&cirscir;", codepoints: Codepoints::Single(10690), characters: "⧂" },
    Entity { entity: "&ClockwiseContourIntegral;", codepoints: Codepoints::Single(8754), characters: "∲" },
    Entity { entity: "&CloseCurlyDoubleQuote;", codepoints: Codepoints::Single(8221), characters: "”" },
    Entity { entity: "&CloseCurlyQuote;", codepoints: Codepoints::Single(8217), characters: "’" },
    Entity { entity: "&clubs;", codepoints: Codepoints::Single(9827), characters: "♣" },
    Entity { entity: "&clubsuit;", codepoints: Codepoints::Single(9827), characters: "♣" },
    Entity { entity: "&Colon;", codepoints: Codepoints::Single(8759), characters: "∷" },
    Entity { entity: "&colon;", codepoints: Codepoints::Single(58), characters: ":" },
    Entity { entity: "&Colone;", codepoints: Codepoints::Single(10868), characters: "⩴" },
    Entity { entity: "&colone;", codepoints: Codepoints::Single(8788), characters: "≔" },
    Entity { entity: "&coloneq;", codepoints: Codepoints::Single(8788), characters: "≔" },
    Entity { entity: "&comma;", codepoints: Codepoints::Single(44), characters: "," },
    Entity { entity: "&commat;", codepoints: Codepoints::Single(64), characters: "@" },
    Entity { entity: "&comp;", codepoints: Codepoints::Single(8705), characters: "∁" },
    Entity { entity: "&compfn;", codepoints: Codepoints::Single(8728), characters: "∘" },
    Entity { entity: "&complement;", codepoints: Codepoints::Single(8705), characters: "∁" },
    Entity { entity: "&complexes;", codepoints: Codepoints::Single(8450), characters: "ℂ" },
    Entity { entity: "&cong;", codepoints: Codepoints::Single(8773), characters: "≅" },
    Entity { entity: "&congdot;", codepoints: Codepoints::Single(10861), characters: "⩭" },
    Entity { entity: "&Congruent;", codepoints: Codepoints::Single(8801), characters: "≡" },
    Entity { entity: "&Conint;", codepoints: Codepoints::Single(8751), characters: "∯" },
    Entity { entity: "&conint;", codepoints: Codepoints::Single(8750), characters: "∮" },
    Entity { entity: "&ContourIntegral;", codepoints: Codepoints::Single(8750), characters: "∮" },
    Entity { entity: "&Copf;", codepoints: Codepoints::Single(8450), characters: "ℂ" },
    Entity { entity: "&copf;", codepoints: Codepoints::Single(120148), characters: "𝕔" },
    Entity { entity: "&coprod;", codepoints: Codepoints::Single(8720), characters: "∐" },
    Entity { entity: "&Coproduct;", codepoints: Codepoints::Single(8720), characters: "∐" },
    Entity { entity: "&COPY;", codepoints: Codepoints::Single(169), characters: "©" },
    Entity { entity: "&COPY", codepoints: Codepoints::Single(169), characters: "©" },
    Entity { entity: "&copy;", codepoints: Codepoints::Single(169), characters: "©" },
    Entity { entity: "&copy", codepoints: Codepoints::Single(169), characters: "©" },
    Entity { entity: "&copysr;", codepoints: Codepoints::Single(8471), characters: "℗" },
    Entity { entity: "&CounterClockwiseContourIntegral;", codepoints: Codepoints::Single(8755), characters: "∳" },
    Entity { entity: "&crarr;", codepoints: Codepoints::Single(8629), characters: "↵" },
    Entity { entity: "&Cross;", codepoints: Codepoints::Single(10799), characters: "⨯" },
    Entity { entity: "&cross;", codepoints: Codepoints::Single(10007), characters: "✗" },
    Entity { entity: "&Cscr;", codepoints: Codepoints::Single(119966), characters: "𝒞" },
    Entity { entity: "&cscr;", codepoints: Codepoints::Single(119992), characters: "𝒸" },
    Entity { entity: "&csub;", codepoints: Codepoints::Single(10959), characters: "⫏" },
    Entity { entity: "&csube;", codepoints: Codepoints::Single(10961), characters: "⫑" },
    Entity { entity: "&csup;", codepoints: Codepoints::Single(10960), characters: "⫐" },
    Entity { entity: "&csupe;", codepoints: Codepoints::Single(10962), characters: "⫒" },
    Entity { entity: "&ctdot;", codepoints: Codepoints::Single(8943), characters: "⋯" },
    Entity { entity: "&cudarrl;", codepoints: Codepoints::Single(10552), characters: "⤸" },
    Entity { entity: "&cudarrr;", codepoints: Codepoints::Single(10549), characters: "⤵" },
    Entity { entity: "&cuepr;", codepoints: Codepoints::Single(8926), characters: "⋞" },
    Entity { entity: "&cuesc;", codepoints: Codepoints::Single(8927), characters: "⋟" },
    Entity { entity: "&cularr;", codepoints: Codepoints::Single(8630), characters: "↶" },
    Entity { entity: "&cularrp;", codepoints: Codepoints::Single(10557), characters: "⤽" },
    Entity { entity: "&Cup;", codepoints: Codepoints::Single(8915), characters: "⋓" },
    Entity { entity: "&cup;", codepoints: Codepoints::Single(8746), characters: "∪" },
    Entity { entity: "&cupbrcap;", codepoints: Codepoints::Single(10824), characters: "⩈" },
    Entity { entity: "&CupCap;", codepoints: Codepoints::Single(8781), characters: "≍" },
    Entity { entity: "&cupcap;", codepoints: Codepoints::Single(10822), characters: "⩆" },
    Entity { entity: "&cupcup;", codepoints: Codepoints::Single(10826), characters: "⩊" },
    Entity { entity: "&cupdot;", codepoints: Codepoints::Single(8845), characters: "⊍" },
    Entity { entity: "&cupor;", codepoints: Codepoints::Single(10821), characters: "⩅" },
    Entity { entity: "&cups;", codepoints: Codepoints::Double(8746, 65024), characters: "∪︀" },
    Entity { entity: "&curarr;", codepoints: Codepoints::Single(8631), characters: "↷" },
    Entity { entity: "&curarrm;", codepoints: Codepoints::Single(10556), characters: "⤼" },
    Entity { entity: "&curlyeqprec;", codepoints: Codepoints::Single(8926), characters: "⋞" },
    Entity { entity: "&curlyeqsucc;", codepoints: Codepoints::Single(8927), characters: "⋟" },
    Entity { entity: "&curlyvee;", codepoints: Codepoints::Single(8910), characters: "⋎" },
    Entity { entity: "&curlywedge;", codepoints: Codepoints::Single(8911), characters: "⋏" },
    Entity { entity: "&curren;", codepoints: Codepoints::Single(164), characters: "¤" },
    Entity { entity: "&curren", codepoints: Codepoints::Single(164), characters: "¤" },
    Entity { entity: "&curvearrowleft;", codepoints: Codepoints::Single(8630), characters: "↶" },
    Entity { entity: "&curvearrowright;", codepoints: Codepoints::Single(8631), characters: "↷" },
    Entity { entity: "&cuvee;", codepoints: Codepoints::Single(8910), characters: "⋎" },
    Entity { entity: "&cuwed;", codepoints: Codepoints::Single(8911), characters: "⋏" },
    Entity { entity: "&cwconint;", codepoints: Codepoints::Single(8754), characters: "∲" },
    Entity { entity: "&cwint;", codepoints: Codepoints::Single(8753), characters: "∱" },
    Entity { entity: "&cylcty;", codepoints: Codepoints::Single(9005), characters: "⌭" },
    Entity { entity: "&Dagger;", codepoints: Codepoints::Single(8225), characters: "‡" },
    Entity { entity: "&dagger;", codepoints: Codepoints::Single(8224), characters: "†" },
    Entity { entity: "&daleth;", codepoints: Codepoints::Single(8504), characters: "ℸ" },
    Entity { entity: "&Darr;", codepoints: Codepoints::Single(8609), characters: "↡" },
    Entity { entity: "&dArr;", codepoints: Codepoints::Single(8659), characters: "⇓" },
    Entity { entity: "&darr;", codepoints: Codepoints::Single(8595), characters: "↓" },
    Entity { entity: "&dash;", codepoints: Codepoints::Single(8208), characters: "‐" },
    Entity { entity: "&Dashv;", codepoints: Codepoints::Single(10980), characters: "⫤" },
    Entity { entity: "&dashv;", codepoints: Codepoints::Single(8867), characters: "⊣" },
    Entity { entity: "&dbkarow;", codepoints: Codepoints::Single(10511), characters: "⤏" },
    Entity { entity: "&dblac;", codepoints: Codepoints::Single(733), characters: "˝" },
    Entity { entity: "&Dcaron;", codepoints: Codepoints::Single(270), characters: "Ď" },
    Entity { entity: "&dcaron;", codepoints: Codepoints::Single(271), characters: "ď" },
    Entity { entity: "&Dcy;", codepoints: Codepoints::Single(1044), characters: "Д" },
    Entity { entity: "&dcy;", codepoints: Codepoints::Single(1076), characters: "д" },
    Entity { entity: "&DD;", codepoints: Codepoints::Single(8517), characters: "ⅅ" },
    Entity { entity: "&dd;", codepoints: Codepoints::Single(8518), characters: "ⅆ" },
    Entity { entity: "&ddagger;", codepoints: Codepoints::Single(8225), characters: "‡" },
    Entity { entity: "&ddarr;", codepoints: Codepoints::Single(8650), characters: "⇊" },
    Entity { entity: "&DDotrahd;", codepoints: Codepoints::Single(10513), characters: "⤑" },
    Entity { entity: "&ddotseq;", codepoints: Codepoints::Single(10871), characters: "⩷" },
    Entity { entity: "&deg;", codepoints: Codepoints::Single(176), characters: "°" },
    Entity { entity: "&deg", codepoints: Codepoints::Single(176), characters: "°" },
    Entity { entity: "&Del;", codepoints: Codepoints::Single(8711), characters: "∇" },
    Entity { entity: "&Delta;", codepoints: Codepoints::Single(916), characters: "Δ" },
    Entity { entity: "&delta;", codepoints: Codepoints::Single(948), characters: "δ" },
    Entity { entity: "&demptyv;", codepoints: Codepoints::Single(10673), characters: "⦱" },
    Entity { entity: "&dfisht;", codepoints: Codepoints::Single(10623), characters: "⥿" },
    Entity { entity: "&Dfr;", codepoints: Codepoints::Single(120071), characters: "𝔇" },
    Entity { entity: "&dfr;", codepoints: Codepoints::Single(120097), characters: "𝔡" },
    Entity { entity: "&dHar;", codepoints: Codepoints::Single(10597), characters: "⥥" },
    Entity { entity: "&dharl;", codepoints: Codepoints::Single(8643), characters: "⇃" },
    Entity { entity: "&dharr;", codepoints: Codepoints::Single(8642), characters: "⇂" },
    Entity { entity: "&DiacriticalAcute;", codepoints: Codepoints::Single(180), characters: "´" },
    Entity { entity: "&DiacriticalDot;", codepoints: Codepoints::Single(729), characters: "˙" },
    Entity { entity: "&DiacriticalDoubleAcute;", codepoints: Codepoints::Single(733), characters: "˝" },
    Entity { entity: "&DiacriticalGrave;", codepoints: Codepoints::Single(96), characters: "`" },
    Entity { entity: "&DiacriticalTilde;", codepoints: Codepoints::Single(732), characters: "˜" },
    Entity { entity: "&diam;", codepoints: Codepoints::Single(8900), characters: "⋄" },
    Entity { entity: "&Diamond;", codepoints: Codepoints::Single(8900), characters: "⋄" },
    Entity { entity: "&diamond;", codepoints: Codepoints::Single(8900), characters: "⋄" },
    Entity { entity: "&diamondsuit;", codepoints: Codepoints::Single(9830), characters: "♦" },
    Entity { entity: "&diams;", codepoints: Codepoints::Single(9830), characters: "♦" },
    Entity { entity: "&die;", codepoints: Codepoints::Single(168), characters: "¨" },
    Entity { entity: "&DifferentialD;", codepoints: Codepoints::Single(8518), characters: "ⅆ" },
    Entity { entity: "&digamma;", codepoints: Codepoints::Single(989), characters: "ϝ" },
    Entity { entity: "&disin;", codepoints: Codepoints::Single(8946), characters: "⋲" },
    Entity { entity: "&div;", codepoints: Codepoints::Single(247), characters: "÷" },
    Entity { entity: "&divide;", codepoints: Codepoints::Single(247), characters: "÷" },
    Entity { entity: "&divide", codepoints: Codepoints::Single(247), characters: "÷" },
    Entity { entity: "&divideontimes;", codepoints: Codepoints::Single(8903), characters: "⋇" },
    Entity { entity: "&divonx;", codepoints: Codepoints::Single(8903), characters: "⋇" },
    Entity { entity: "&DJcy;", codepoints: Codepoints::Single(1026), characters: "Ђ" },
    Entity { entity: "&djcy;", codepoints: Codepoints::Single(1106), characters: "ђ" },
    Entity { entity: "&dlcorn;", codepoints: Codepoints::Single(8990), characters: "⌞" },
    Entity { entity: "&dlcrop;", codepoints: Codepoints::Single(8973), characters: "⌍" },
    Entity { entity: "&dollar;", codepoints: Codepoints::Single(36), characters: "$" },
    Entity { entity: "&Dopf;", codepoints: Codepoints::Single(120123), characters: "𝔻" },
    Entity { entity: "&dopf;", codepoints: Codepoints::Single(120149), characters: "𝕕" },
    Entity { entity: "&Dot;", codepoints: Codepoints::Single(168), characters: "¨" },
    Entity { entity: "&dot;", codepoints: Codepoints::Single(729), characters: "˙" },
    Entity { entity: "&DotDot;", codepoints: Codepoints::Single(8412), characters: "⃜" },
    Entity { entity: "&doteq;", codepoints: Codepoints::Single(8784), characters: "≐" },
    Entity { entity: "&doteqdot;", codepoints: Codepoints::Single(8785), characters: "≑" },
    Entity { entity: "&DotEqual;", codepoints: Codepoints::Single(8784), characters: "≐" },
    Entity { entity: "&dotminus;", codepoints: Codepoints::Single(8760), characters: "∸" },
    Entity { entity: "&dotplus;", codepoints: Codepoints::Single(8724), characters: "∔" },
    Entity { entity: "&dotsquare;", codepoints: Codepoints::Single(8865), characters: "⊡" },
    Entity { entity: "&doublebarwedge;", codepoints: Codepoints::Single(8966), characters: "⌆" },
    Entity { entity: "&DoubleContourIntegral;", codepoints: Codepoints::Single(8751), characters: "∯" },
    Entity { entity: "&DoubleDot;", codepoints: Codepoints::Single(168), characters: "¨" },
    Entity { entity: "&DoubleDownArrow;", codepoints: Codepoints::Single(8659), characters: "⇓" },
    Entity { entity: "&DoubleLeftArrow;", codepoints: Codepoints::Single(8656), characters: "⇐" },
    Entity { entity: "&DoubleLeftRightArrow;", codepoints: Codepoints::Single(8660), characters: "⇔" },
    Entity { entity: "&DoubleLeftTee;", codepoints: Codepoints::Single(10980), characters: "⫤" },
    Entity { entity: "&DoubleLongLeftArrow;", codepoints: Codepoints::Single(10232), characters: "⟸" },
    Entity { entity: "&DoubleLongLeftRightArrow;", codepoints: Codepoints::Single(10234), characters: "⟺" },
    Entity { entity: "&DoubleLongRightArrow;", codepoints: Codepoints::Single(10233), characters: "⟹" },
    Entity { entity: "&DoubleRightArrow;", codepoints: Codepoints::Single(8658), characters: "⇒" },
    Entity { entity: "&DoubleRightTee;", codepoints: Codepoints::Single(8872), characters: "⊨" },
    Entity { entity: "&DoubleUpArrow;", codepoints: Codepoints::Single(8657), characters: "⇑" },
    Entity { entity: "&DoubleUpDownArrow;", codepoints: Codepoints::Single(8661), characters: "⇕" },
    Entity { entity: "&DoubleVerticalBar;", codepoints: Codepoints::Single(8741), characters: "∥" },
    Entity { entity: "&DownArrow;", codepoints: Codepoints::Single(8595), characters: "↓" },
    Entity { entity: "&Downarrow;", codepoints: Codepoints::Single(8659), characters: "⇓" },
    Entity { entity: "&downarrow;", codepoints: Codepoints::Single(8595), characters: "↓" },
    Entity { entity: "&DownArrowBar;", codepoints: Codepoints::Single(10515), characters: "⤓" },
    Entity { entity: "&DownArrowUpArrow;", codepoints: Codepoints::Single(8693), characters: "⇵" },
    Entity { entity: "&DownBreve;", codepoints: Codepoints::Single(785), characters: "̑" },
    Entity { entity: "&downdownarrows;", codepoints: Codepoints::Single(8650), characters: "⇊" },
    Entity { entity: "&downharpoonleft;", codepoints: Codepoints::Single(8643), characters: "⇃" },
    Entity { entity: "&downharpoonright;", codepoints: Codepoints::Single(8642), characters: "⇂" },
    Entity { entity: "&DownLeftRightVector;", codepoints: Codepoints::Single(10576), characters: "⥐" },
    Entity { entity: "&DownLeftTeeVector;", codepoints: Codepoints::Single(10590), characters: "⥞" },
    Entity { entity: "&DownLeftVector;", codepoints: Codepoints::Single(8637), characters: "↽" },
    Entity { entity: "&DownLeftVectorBar;", codepoints: Codepoints::Single(10582), characters: "⥖" },
    Entity { entity: "&DownRightTeeVector;", codepoints: Codepoints::Single(10591), characters: "⥟" },
    Entity { entity: "&DownRightVector;", codepoints: Codepoints::Single(8641), characters: "⇁" },
    Entity { entity: "&DownRightVectorBar;", codepoints: Codepoints::Single(10583), characters: "⥗" },
    Entity { entity: "&DownTee;", codepoints: Codepoints::Single(8868), characters: "⊤" },
    Entity { entity: "&DownTeeArrow;", codepoints: Codepoints::Single(8615), characters: "↧" },
    Entity { entity: "&drbkarow;", codepoints: Codepoints::Single(10512), characters: "⤐" },
    Entity { entity: "&drcorn;", codepoints: Codepoints::Single(8991), characters: "⌟" },
    Entity { entity: "&drcrop;", codepoints: Codepoints::Single(8972), characters: "⌌" },
    Entity { entity: "&Dscr;", codepoints: Codepoints::Single(119967), characters: "𝒟" },
    Entity { entity: "&dscr;", codepoints: Codepoints::Single(119993), characters: "𝒹" },
    Entity { entity: "&DScy;", codepoints: Codepoints::Single(1029), characters: "Ѕ" },
    Entity { entity: "&dscy;", codepoints: Codepoints::Single(1109), characters: "ѕ" },
    Entity { entity: "&dsol;", codepoints: Codepoints::Single(10742), characters: "⧶" },
    Entity { entity: "&Dstrok;", codepoints: Codepoints::Single(272), characters: "Đ" },
    Entity { entity: "&dstrok;", codepoints: Codepoints::Single(273), characters: "đ" },
    Entity { entity: "&dtdot;", codepoints: Codepoints::Single(8945), characters: "⋱" },
    Entity { entity: "&dtri;", codepoints: Codepoints::Single(9663), characters: "▿" },
    Entity { entity: "&dtrif;", codepoints: Codepoints::Single(9662), characters: "▾" },
    Entity { entity: "&duarr;", codepoints: Codepoints::Single(8693), characters: "⇵" },
    Entity { entity: "&duhar;", codepoints: Codepoints::Single(10607), characters: "⥯" },
    Entity { entity: "&dwangle;", codepoints: Codepoints::Single(10662), characters: "⦦" },
    Entity { entity: "&DZcy;", codepoints: Codepoints::Single(1039), characters: "Џ" },
    Entity { entity: "&dzcy;", codepoints: Codepoints::Single(1119), characters: "џ" },
    Entity { entity: "&dzigrarr;", codepoints: Codepoints::Single(10239), characters: "⟿" },
    Entity { entity: "&Eacute;", codepoints: Codepoints::Single(201), characters: "É" },
    Entity { entity: "&Eacute", codepoints: Codepoints::Single(201), characters: "É" },
    Entity { entity: "&eacute;", codepoints: Codepoints::Single(233), characters: "é" },
    Entity { entity: "&eacute", codepoints: Codepoints::Single(233), characters: "é" },
    Entity { entity: "&easter;", codepoints: Codepoints::Single(10862), characters: "⩮" },
    Entity { entity: "&Ecaron;", codepoints: Codepoints::Single(282), characters: "Ě" },
    Entity { entity: "&ecaron;", codepoints: Codepoints::Single(283), characters: "ě" },
    Entity { entity: "&ecir;", codepoints: Codepoints::Single(8790), characters: "≖" },
    Entity { entity: "&Ecirc;", codepoints: Codepoints::Single(202), characters: "Ê" },
    Entity { entity: "&Ecirc", codepoints: Codepoints::Single(202), characters: "Ê" },
    Entity { entity: "&ecirc;", codepoints: Codepoints::Single(234), characters: "ê" },
    Entity { entity: "&ecirc", codepoints: Codepoints::Single(234), characters: "ê" },
    Entity { entity: "&ecolon;", codepoints: Codepoints::Single(8789), characters: "≕" },
    Entity { entity: "&Ecy;", codepoints: Codepoints::Single(1069), characters: "Э" },
    Entity { entity: "&ecy;", codepoints: Codepoints::Single(1101), characters: "э" },
    Entity { entity: "&eDDot;", codepoints: Codepoints::Single(10871), characters: "⩷" },
    Entity { entity: "&Edot;", codepoints: Codepoints::Single(278), characters: "Ė" },
    Entity { entity: "&eDot;", codepoints: Codepoints::Single(8785), characters: "≑" },
    Entity { entity: "&edot;", codepoints: Codepoints::Single(279), characters: "ė" },
    Entity { entity: "&ee;", codepoints: Codepoints::Single(8519), characters: "ⅇ" },
    Entity { entity: "&efDot;", codepoints: Codepoints::Single(8786), characters: "≒" },
    Entity { entity: "&Efr;", codepoints: Codepoints::Single(120072), characters: "𝔈" },
    Entity { entity: "&efr;", codepoints: Codepoints::Single(120098), characters: "𝔢" },
    Entity { entity: "&eg;", codepoints: Codepoints::Single(10906), characters: "⪚" },
    Entity { entity: "&Egrave;", codepoints: Codepoints::Single(200), characters: "È" },
    Entity { entity: "&Egrave", codepoints: Codepoints::Single(200), characters: "È" },
    Entity { entity: "&egrave;", codepoints: Codepoints::Single(232), characters: "è" },
    Entity { entity: "&egrave", codepoints: Codepoints::Single(232), characters: "è" },
    Entity { entity: "&egs;", codepoints: Codepoints::Single(10902), characters: "⪖" },
    Entity { entity: "&egsdot;", codepoints: Codepoints::Single(10904), characters: "⪘" },
    Entity { entity: "&el;", codepoints: Codepoints::Single(10905), characters: "⪙" },
    Entity { entity: "&Element;", codepoints: Codepoints::Single(8712), characters: "∈" },
    Entity { entity: "&elinters;", codepoints: Codepoints::Single(9191), characters: "⏧" },
    Entity { entity: "&ell;", codepoints: Codepoints::Single(8467), characters: "ℓ" },
    Entity { entity: "&els;", codepoints: Codepoints::Single(10901), characters: "⪕" },
    Entity { entity: "&elsdot;", codepoints: Codepoints::Single(10903), characters: "⪗" },
    Entity { entity: "&Emacr;", codepoints: Codepoints::Single(274), characters: "Ē" },
    Entity { entity: "&emacr;", codepoints: Codepoints::Single(275), characters: "ē" },
    Entity { entity: "&empty;", codepoints: Codepoints::Single(8709), characters: "∅" },
    Entity { entity: "&emptyset;", codepoints: Codepoints::Single(8709), characters: "∅" },
    Entity { entity: "&EmptySmallSquare;", codepoints: Codepoints::Single(9723), characters: "◻" },
    Entity { entity: "&emptyv;", codepoints: Codepoints::Single(8709), characters: "∅" },
    Entity { entity: "&EmptyVerySmallSquare;", codepoints: Codepoints::Single(9643), characters: "▫" },
    Entity { entity: "&emsp;", codepoints: Codepoints::Single(8195), characters: " " },
    Entity { entity: "&emsp13;", codepoints: Codepoints::Single(8196), characters: " " },
    Entity { entity: "&emsp14;", codepoints: Codepoints::Single(8197), characters: " " },
    Entity { entity: "&ENG;", codepoints: Codepoints::Single(330), characters: "Ŋ" },
    Entity { entity: "&eng;", codepoints: Codepoints::Single(331), characters: "ŋ" },
    Entity { entity: "&ensp;", codepoints: Codepoints::Single(8194), characters: " " },
    Entity { entity: "&Eogon;", codepoints: Codepoints::Single(280), characters: "Ę" },
    Entity { entity: "&eogon;", codepoints: Codepoints::Single(281), characters: "ę" },
    Entity { entity: "&Eopf;", codepoints: Codepoints::Single(120124), characters: "𝔼" },
    Entity { entity: "&eopf;", codepoints: Codepoints::Single(120150), characters: "𝕖" },
    Entity { entity: "&epar;", codepoints: Codepoints::Single(8917), characters: "⋕" },
    Entity { entity: "&eparsl;", codepoints: Codepoints::Single(10723), characters: "⧣" },
    Entity { entity: "&eplus;", codepoints: Codepoints::Single(10865), characters: "⩱" },
    Entity { entity: "&epsi;", codepoints: Codepoints::Single(949), characters: "ε" },
    Entity { entity: "&Epsilon;", codepoints: Codepoints::Single(917), characters: "Ε" },
    Entity { entity: "&epsilon;", codepoints: Codepoints::Single(949), characters: "ε" },
    Entity { entity: "&epsiv;", codepoints: Codepoints::Single(1013), characters: "ϵ" },
    Entity { entity: "&eqcirc;", codepoints: Codepoints::Single(8790), characters: "≖" },
    Entity { entity: "&eqcolon;", codepoints: Codepoints::Single(8789), characters: "≕" },
    Entity { entity: "&eqsim;", codepoints: Codepoints::Single(8770), characters: "≂" },
    Entity { entity: "&eqslantgtr;", codepoints: Codepoints::Single(10902), characters: "⪖" },
    Entity { entity: "&eqslantless;", codepoints: Codepoints::Single(10901), characters: "⪕" },
    Entity { entity: "&Equal;", codepoints: Codepoints::Single(10869), characters: "⩵" },
    Entity { entity: "&equals;", codepoints: Codepoints::Single(61), characters: "=" },
    Entity { entity: "&EqualTilde;", codepoints: Codepoints::Single(8770), characters: "≂" },
    Entity { entity: "&equest;", codepoints: Codepoints::Single(8799), characters: "≟" },
    Entity { entity: "&Equilibrium;", codepoints: Codepoints::Single(8652), characters: "⇌" },
    Entity { entity: "&equiv;", codepoints: Codepoints::Single(8801), characters: "≡" },
    Entity { entity: "&equivDD;", codepoints: Codepoints::Single(10872), characters: "⩸" },
    Entity { entity: "&eqvparsl;", codepoints: Codepoints::Single(10725), characters: "⧥" },
    Entity { entity: "&erarr;", codepoints: Codepoints::Single(10609), characters: "⥱" },
    Entity { entity: "&erDot;", codepoints: Codepoints::Single(8787), characters: "≓" },
    Entity { entity: "&Escr;", codepoints: Codepoints::Single(8496), characters: "ℰ" },
    Entity { entity: "&escr;", codepoints: Codepoints::Single(8495), characters: "ℯ" },
    Entity { entity: "&esdot;", codepoints: Codepoints::Single(8784), characters: "≐" },
    Entity { entity: "&Esim;", codepoints: Codepoints::Single(10867), characters: "⩳" },
    Entity { entity: "&esim;", codepoints: Codepoints::Single(8770), characters: "≂" },
    Entity { entity: "&Eta;", codepoints: Codepoints::Single(919), characters: "Η" },
    Entity { entity: "&eta;", codepoints: Codepoints::Single(951), characters: "η" },
    Entity { entity: "&ETH;", codepoints: Codepoints::Single(208), characters: "Ð" },
    Entity { entity: "&ETH", codepoints: Codepoints::Single(208), characters: "Ð" },
    Entity { entity: "&eth;", codepoints: Codepoints::Single(240), characters: "ð" },
    Entity { entity: "&eth", codepoints: Codepoints::Single(240), characters: "ð" },
    Entity { entity: "&Euml;", codepoints: Codepoints::Single(203), characters: "Ë" },
    Entity { entity: "&Euml", codepoints: Codepoints::Single(203), characters: "Ë" },
    Entity { entity: "&euml;", codepoints: Codepoints::Single(235), characters: "ë" },
    Entity { entity: "&euml", codepoints: Codepoints::Single(235), characters: "ë" },
    Entity { entity: "&euro;", codepoints: Codepoints::Single(8364), characters: "€" },
    Entity { entity: "&excl;", codepoints: Codepoints::Single(33), characters: "!" },
    Entity { entity: "&exist;", codepoints: Codepoints::Single(8707), characters: "∃" },
    Entity { entity: "&Exists;", codepoints: Codepoints::Single(8707), characters: "∃" },
    Entity { entity: "&expectation;", codepoints: Codepoints::Single(8496), characters: "ℰ" },
    Entity { entity: "&ExponentialE;", codepoints: Codepoints::Single(8519), characters: "ⅇ" },
    Entity { entity: "&exponentiale;", codepoints: Codepoints::Single(8519), characters: "ⅇ" },
    Entity { entity: "&fallingdotseq;", codepoints: Codepoints::Single(8786), characters: "≒" },
    Entity { entity: "&Fcy;", codepoints: Codepoints::Single(1060), characters: "Ф" },
    Entity { entity: "&fcy;", codepoints: Codepoints::Single(1092), characters: "ф" },
    Entity { entity: "&female;", codepoints: Codepoints::Single(9792), characters: "♀" },
    Entity { entity: "&ffilig;", codepoints: Codepoints::Single(64259), characters: "ﬃ" },
    Entity { entity: "&fflig;", codepoints: Codepoints::Single(64256), characters: "ﬀ" },
    Entity { entity: "&ffllig;", codepoints: Codepoints::Single(64260), characters: "ﬄ" },
    Entity { entity: "&Ffr;", codepoints: Codepoints::Single(120073), characters: "𝔉" },
    Entity { entity: "&ffr;", codepoints: Codepoints::Single(120099), characters: "𝔣" },
    Entity { entity: "&filig;", codepoints: Codepoints::Single(64257), characters: "ﬁ" },
    Entity { entity: "&FilledSmallSquare;", codepoints: Codepoints::Single(9724), characters: "◼" },
    Entity { entity: "&FilledVerySmallSquare;", codepoints: Codepoints::Single(9642), characters: "▪" },
    Entity { entity: "&fjlig;", codepoints: Codepoints::Double(102, 106), characters: "fj" },
    Entity { entity: "&flat;", codepoints: Codepoints::Single(9837), characters: "♭" },
    Entity { entity: "&fllig;", codepoints: Codepoints::Single(64258), characters: "ﬂ" },
    Entity { entity: "&fltns;", codepoints: Codepoints::Single(9649), characters: "▱" },
    Entity { entity: "&fnof;", codepoints: Codepoints::Single(402), characters: "ƒ" },
    Entity { entity: "&Fopf;", codepoints: Codepoints::Single(120125), characters: "𝔽" },
    Entity { entity: "&fopf;", codepoints: Codepoints::Single(120151), characters: "𝕗" },
    Entity { entity: "&ForAll;", codepoints: Codepoints::Single(8704), characters: "∀" },
    Entity { entity: "&forall;", codepoints: Codepoints::Single(8704), characters: "∀" },
    Entity { entity: "&fork;", codepoints: Codepoints::Single(8916), characters: "⋔" },
    Entity { entity: "&forkv;", codepoints: Codepoints::Single(10969), characters: "⫙" },
    Entity { entity: "&Fouriertrf;", codepoints: Codepoints::Single(8497), characters: "ℱ" },
    Entity { entity: "&fpartint;", codepoints: Codepoints::Single(10765), characters: "⨍" },
    Entity { entity: "&frac12;", codepoints: Codepoints::Single(189), characters: "½" },
    Entity { entity: "&frac12", codepoints: Codepoints::Single(189), characters: "½" },
    Entity { entity: "&frac13;", codepoints: Codepoints::Single(8531), characters: "⅓" },
    Entity { entity: "&frac14;", codepoints: Codepoints::Single(188), characters: "¼" },
    Entity { entity: "&frac14", codepoints: Codepoints::Single(188), characters: "¼" },
    Entity { entity: "&frac15;", codepoints: Codepoints::Single(8533), characters: "⅕" },
    Entity { entity: "&frac16;", codepoints: Codepoints::Single(8537), characters: "⅙" },
    Entity { entity: "&frac18;", codepoints: Codepoints::Single(8539), characters: "⅛" },
    Entity { entity: "&frac23;", codepoints: Codepoints::Single(8532), characters: "⅔" },
    Entity { entity: "&frac25;", codepoints: Codepoints::Single(8534), characters: "⅖" },
    Entity { entity: "&frac34;", codepoints: Codepoints::Single(190), characters: "¾" },
    Entity { entity: "&frac34", codepoints: Codepoints::Single(190), characters: "¾" },
    Entity { entity: "&frac35;", codepoints: Codepoints::Single(8535), characters: "⅗" },
    Entity { entity: "&frac38;", codepoints: Codepoints::Single(8540), characters: "⅜" },
    Entity { entity: "&frac45;", codepoints: Codepoints::Single(8536), characters: "⅘" },
    Entity { entity: "&frac56;", codepoints: Codepoints::Single(8538), characters: "⅚" },
    Entity { entity: "&frac58;", codepoints: Codepoints::Single(8541), characters: "⅝" },
    Entity { entity: "&frac78;", codepoints: Codepoints::Single(8542), characters: "⅞" },
    Entity { entity: "&frasl;", codepoints: Codepoints::Single(8260), characters: "⁄" },
    Entity { entity: "&frown;", codepoints: Codepoints::Single(8994), characters: "⌢" },
    Entity { entity: "&Fscr;", codepoints: Codepoints::Single(8497), characters: "ℱ" },
    Entity { entity: "&fscr;", codepoints: Codepoints::Single(119995), characters: "𝒻" },
    Entity { entity: "&gacute;", codepoints: Codepoints::Single(501), characters: "ǵ" },
    Entity { entity: "&Gamma;", codepoints: Codepoints::Single(915), characters: "Γ" },
    Entity { entity: "&gamma;", codepoints: Codepoints::Single(947), characters: "γ" },
    Entity { entity: "&Gammad;", codepoints: Codepoints::Single(988), characters: "Ϝ" },
    Entity { entity: "&gammad;", codepoints: Codepoints::Single(989), characters: "ϝ" },
    Entity { entity: "&gap;", codepoints: Codepoints::Single(10886), characters: "⪆" },
    Entity { entity: "&Gbreve;", codepoints: Codepoints::Single(286), characters: "Ğ" },
    Entity { entity: "&gbreve;", codepoints: Codepoints::Single(287), characters: "ğ" },
    Entity { entity: "&Gcedil;", codepoints: Codepoints::Single(290), characters: "Ģ" },
    Entity { entity: "&Gcirc;", codepoints: Codepoints::Single(284), characters: "Ĝ" },
    Entity { entity: "&gcirc;", codepoints: Codepoints::Single(285), characters: "ĝ" },
    Entity { entity: "&Gcy;", codepoints: Codepoints::Single(1043), characters: "Г" },
    Entity { entity: "&gcy;", codepoints: Codepoints::Single(1075), characters: "г" },
    Entity { entity: "&Gdot;", codepoints: Codepoints::Single(288), characters: "Ġ" },
    Entity { entity: "&gdot;", codepoints: Codepoints::Single(289), characters: "ġ" },
    Entity { entity: "&gE;", codepoints: Codepoints::Single(8807), characters: "≧" },
    Entity { entity: "&ge;", codepoints: Codepoints::Single(8805), characters: "≥" },
    Entity { entity: "&gEl;", codepoints: Codepoints::Single(10892), characters: "⪌" },
    Entity { entity: "&gel;", codepoints: Codepoints::Single(8923), characters: "⋛" },
    Entity { entity: "&geq;", codepoints: Codepoints::Single(8805), characters: "≥" },
    Entity { entity: "&geqq;", codepoints: Codepoints::Single(8807), characters: "≧" },
    Entity { entity: "&geqslant;", codepoints: Codepoints::Single(10878), characters: "⩾" },
    Entity { entity: "&ges;", codepoints: Codepoints::Single(10878), characters: "⩾" },
    Entity { entity: "&gescc;", codepoints: Codepoints::Single(10921), characters: "⪩" },
    Entity { entity: "&gesdot;", codepoints: Codepoints::Single(10880), characters: "⪀" },
    Entity { entity: "&gesdoto;", codepoints: Codepoints::Single(10882), characters: "⪂" },
    Entity { entity: "&gesdotol;", codepoints: Codepoints::Single(10884), characters: "⪄" },
    Entity { entity: "&gesl;", codepoints: Codepoints::Double(8923, 65024), characters: "⋛︀" },
    Entity { entity: "&gesles;", codepoints: Codepoints::Single(10900), characters: "⪔" },
    Entity { entity: "&Gfr;", codepoints: Codepoints::Single(120074), characters: "𝔊" },
    Entity { entity: "&gfr;", codepoints: Codepoints::Single(120100), characters: "𝔤" },
    Entity { entity: "&Gg;", codepoints: Codepoints::Single(8921), characters: "⋙" },
    Entity { entity: "&gg;", codepoints: Codepoints::Single(8811), characters: "≫" },
    Entity { entity: "&ggg;", codepoints: Codepoints::Single(8921), characters: "⋙" },
    Entity { entity: "&gimel;", codepoints: Codepoints::Single(8503), characters: "ℷ" },
    Entity { entity: "&GJcy;", codepoints: Codepoints::Single(1027), characters: "Ѓ" },
    Entity { entity: "&gjcy;", codepoints: Codepoints::Single(1107), characters: "ѓ" },
    Entity { entity: "&gl;", codepoints: Codepoints::Single(8823), characters: "≷" },
    Entity { entity: "&gla;", codepoints: Codepoints::Single(10917), characters: "⪥" },
    Entity { entity: "&glE;", codepoints: Codepoints::Single(10898), characters: "⪒" },
    Entity { entity: "&glj;", codepoints: Codepoints::Single(10916), characters: "⪤" },
    Entity { entity: "&gnap;", codepoints: Codepoints::Single(10890), characters: "⪊" },
    Entity { entity: "&gnapprox;", codepoints: Codepoints::Single(10890), characters: "⪊" },
    Entity { entity: "&gnE;", codepoints: Codepoints::Single(8809), characters: "≩" },
    Entity { entity: "&gne;", codepoints: Codepoints::Single(10888), characters: "⪈" },
    Entity { entity: "&gneq;", codepoints: Codepoints::Single(10888), characters: "⪈" },
    Entity { entity: "&gneqq;", codepoints: Codepoints::Single(8809), characters: "≩" },
    Entity { entity: "&gnsim;", codepoints: Codepoints::Single(8935), characters: "⋧" },
    Entity { entity: "&Gopf;", codepoints: Codepoints::Single(120126), characters: "𝔾" },
    Entity { entity: "&gopf;", codepoints: Codepoints::Single(120152), characters: "𝕘" },
    Entity { entity: "&grave;", codepoints: Codepoints::Single(96), characters: "`" },
    Entity { entity: "&GreaterEqual;", codepoints: Codepoints::Single(8805), characters: "≥" },
    Entity { entity: "&GreaterEqualLess;", codepoints: Codepoints::Single(8923), characters: "⋛" },
    Entity { entity: "&GreaterFullEqual;", codepoints: Codepoints::Single(8807), characters: "≧" },
    Entity { entity: "&GreaterGreater;", codepoints: Codepoints::Single(10914), characters: "⪢" },
    Entity { entity: "&GreaterLess;", codepoints: Codepoints::Single(8823), characters: "≷" },
    Entity { entity: "&GreaterSlantEqual;", codepoints: Codepoints::Single(10878), characters: "⩾" },
    Entity { entity: "&GreaterTilde;", codepoints: Codepoints::Single(8819), characters: "≳" },
    Entity { entity: "&Gscr;", codepoints: Codepoints::Single(119970), characters: "𝒢" },
    Entity { entity: "&gscr;", codepoints: Codepoints::Single(8458), characters: "ℊ" },
    Entity { entity: "&gsim;", codepoints: Codepoints::Single(8819), characters: "≳" },
    Entity { entity: "&gsime;", codepoints: Codepoints::Single(10894), characters: "⪎" },
    Entity { entity: "&gsiml;", codepoints: Codepoints::Single(10896), characters: "⪐" },
    Entity { entity: "&GT;", codepoints: Codepoints::Single(62), characters: ">" },
    Entity { entity: "&GT", codepoints: Codepoints::Single(62), characters: ">" },
    Entity { entity: "&Gt;", codepoints: Codepoints::Single(8811), characters: "≫" },
    Entity { entity: "&gt;", codepoints: Codepoints::Single(62), characters: ">" },
    Entity { entity: "&gt", codepoints: Codepoints::Single(62), characters: ">" },
    Entity { entity: "&gtcc;", codepoints: Codepoints::Single(10919), characters: "⪧" },
    Entity { entity: "&gtcir;", codepoints: Codepoints::Single(10874), characters: "⩺" },
    Entity { entity: "&gtdot;", codepoints: Codepoints::Single(8919), characters: "⋗" },
    Entity { entity: "&gtlPar;", codepoints: Codepoints::Single(10645), characters: "⦕" },
    Entity { entity: "&gtquest;", codepoints: Codepoints::Single(10876), characters: "⩼" },
    Entity { entity: "&gtrapprox;", codepoints: Codepoints::Single(10886), characters: "⪆" },
    Entity { entity: "&gtrarr;", codepoints: Codepoints::Single(10616), characters: "⥸" },
    Entity { entity: "&gtrdot;", codepoints: Codepoints::Single(8919), characters: "⋗" },
    Entity { entity: "&gtreqless;", codepoints: Codepoints::Single(8923), characters: "⋛" },
    Entity { entity: "&gtreqqless;", codepoints: Codepoints::Single(10892), characters: "⪌" },
    Entity { entity: "&gtrless;", codepoints: Codepoints::Single(8823), characters: "≷" },
    Entity { entity: "&gtrsim;", codepoints: Codepoints::Single(8819), characters: "≳" },
    Entity { entity: "&gvertneqq;", codepoints: Codepoints::Double(8809, 65024), characters: "≩︀" },
    Entity { entity: "&gvnE;", codepoints: Codepoints::Double(8809, 65024), characters: "≩︀" },
    Entity { entity: "&Hacek;", codepoints: Codepoints::Single(711), characters: "ˇ" },
    Entity { entity: "&hairsp;", codepoints: Codepoints::Single(8202), characters: " " },
    Entity { entity: "&half;", codepoints: Codepoints::Single(189), characters: "½" },
    Entity { entity: "&hamilt;", codepoints: Codepoints::Single(8459), characters: "ℋ" },
    Entity { entity: "&HARDcy;", codepoints: Codepoints::Single(1066), characters: "Ъ" },
    Entity { entity: "&hardcy;", codepoints: Codepoints::Single(1098), characters: "ъ" },
    Entity { entity: "&hArr;", codepoints: Codepoints::Single(8660), characters: "⇔" },
    Entity { entity: "&harr;", codepoints: Codepoints::Single(8596), characters: "↔" },
    Entity { entity: "&harrcir;", codepoints: Codepoints::Single(10568), characters: "⥈" },
    Entity { entity: "&harrw;", codepoints: Codepoints::Single(8621), characters: "↭" },
    Entity { entity: "&Hat;", codepoints: Codepoints::Single(94), characters: "^" },
    Entity { entity: "&hbar;", codepoints: Codepoints::Single(8463), characters: "ℏ" },
    Entity { entity: "&Hcirc;", codepoints: Codepoints::Single(292), characters: "Ĥ" },
    Entity { entity: "&hcirc;", codepoints: Codepoints::Single(293), characters: "ĥ" },
    Entity { entity: "&hearts;", codepoints: Codepoints::Single(9829), characters: "♥" },
    Entity { entity: "&heartsuit;", codepoints: Codepoints::Single(9829), characters: "♥" },
    Entity { entity: "&hellip;", codepoints: Codepoints::Single(8230), characters: "…" },
    Entity { entity: "&hercon;", codepoints: Codepoints::Single(8889), characters: "⊹" },
    Entity { entity: "&Hfr;", codepoints: Codepoints::Single(8460), characters: "ℌ" },
    Entity { entity: "&hfr;", codepoints: Codepoints::Single(120101), characters: "𝔥" },
    Entity { entity: "&HilbertSpace;", codepoints: Codepoints::Single(8459), characters: "ℋ" },
    Entity { entity: "&hksearow;", codepoints: Codepoints::Single(10533), characters: "⤥" },
    Entity { entity: "&hkswarow;", codepoints: Codepoints::Single(10534), characters: "⤦" },
    Entity { entity: "&hoarr;", codepoints: Codepoints::Single(8703), characters: "⇿" },
    Entity { entity: "&homtht;", codepoints: Codepoints::Single(8763), characters: "∻" },
    Entity { entity: "&hookleftarrow;", codepoints: Codepoints::Single(8617), characters: "↩" },
    Entity { entity: "&hookrightarrow;", codepoints: Codepoints::Single(8618), characters: "↪" },
    Entity { entity: "&Hopf;", codepoints: Codepoints::Single(8461), characters: "ℍ" },
    Entity { entity: "&hopf;", codepoints: Codepoints::Single(120153), characters: "𝕙" },
    Entity { entity: "&horbar;", codepoints: Codepoints::Single(8213), characters: "―" },
    Entity { entity: "&HorizontalLine;", codepoints: Codepoints::Single(9472), characters: "─" },
    Entity { entity: "&Hscr;", codepoints: Codepoints::Single(8459), characters: "ℋ" },
    Entity { entity: "&hscr;", codepoints: Codepoints::Single(119997), characters: "𝒽" },
    Entity { entity: "&hslash;", codepoints: Codepoints::Single(8463), characters: "ℏ" },
    Entity { entity: "&Hstrok;", codepoints: Codepoints::Single(294), characters: "Ħ" },
    Entity { entity: "&hstrok;", codepoints: Codepoints::Single(295), characters: "ħ" },
    Entity { entity: "&HumpDownHump;", codepoints: Codepoints::Single(8782), characters: "≎" },
    Entity { entity: "&HumpEqual;", codepoints: Codepoints::Single(8783), characters: "≏" },
    Entity { entity: "&hybull;", codepoints: Codepoints::Single(8259), characters: "⁃" },
    Entity { entity: "&hyphen;", codepoints: Codepoints::Single(8208), characters: "‐" },
    Entity { entity: "&Iacute;", codepoints: Codepoints::Single(205), characters: "Í" },
    Entity { entity: "&Iacute", codepoints: Codepoints::Single(205), characters: "Í" },
    Entity { entity: "&iacute;", codepoints: Codepoints::Single(237), characters: "í" },
    Entity { entity: "&iacute", codepoints: Codepoints::Single(237), characters: "í" },
    Entity { entity: "&ic;", codepoints: Codepoints::Single(8291), characters: "⁣" },
    Entity { entity: "&Icirc;", codepoints: Codepoints::Single(206), characters: "Î" },
    Entity { entity: "&Icirc", codepoints: Codepoints::Single(206), characters: "Î" },
    Entity { entity: "&icirc;", codepoints: Codepoints::Single(238), characters: "î" },
    Entity { entity: "&icirc", codepoints: Codepoints::Single(238), characters: "î" },
    Entity { entity: "&Icy;", codepoints: Codepoints::Single(1048), characters: "И" },
    Entity { entity: "&icy;", codepoints: Codepoints::Single(1080), characters: "и" },
    Entity { entity: "&Idot;", codepoints: Codepoints::Single(304), characters: "İ" },
    Entity { entity: "&IEcy;", codepoints: Codepoints::Single(1045), characters: "Е" },
    Entity { entity: "&iecy;", codepoints: Codepoints::Single(1077), characters: "е" },
    Entity { entity: "&iexcl;", codepoints: Codepoints::Single(161), characters: "¡" },
    Entity { entity: "&iexcl", codepoints: Codepoints::Single(161), characters: "¡" },
    Entity { entity: "&iff;", codepoints: Codepoints::Single(8660), characters: "⇔" },
    Entity { entity: "&Ifr;", codepoints: Codepoints::Single(8465), characters: "ℑ" },
    Entity { entity: "&ifr;", codepoints: Codepoints::Single(120102), characters: "𝔦" },
    Entity { entity: "&Igrave;", codepoints: Codepoints::Single(204), characters: "Ì" },
    Entity { entity: "&Igrave", codepoints: Codepoints::Single(204), characters: "Ì" },
    Entity { entity: "&igrave;", codepoints: Codepoints::Single(236), characters: "ì" },
    Entity { entity: "&igrave", codepoints: Codepoints::Single(236), characters: "ì" },
    Entity { entity: "&ii;", codepoints: Codepoints::Single(8520), characters: "ⅈ" },
    Entity { entity: "&iiiint;", codepoints: Codepoints::Single(10764), characters: "⨌" },
    Entity { entity: "&iiint;", codepoints: Codepoints::Single(8749), characters: "∭" },
    Entity { entity: "&iinfin;", codepoints: Codepoints::Single(10716), characters: "⧜" },
    Entity { entity: "&iiota;", codepoints: Codepoints::Single(8489), characters: "℩" },
    Entity { entity: "&IJlig;", codepoints: Codepoints::Single(306), characters: "Ĳ" },
    Entity { entity: "&ijlig;", codepoints: Codepoints::Single(307), characters: "ĳ" },
    Entity { entity: "&Im;", codepoints: Codepoints::Single(8465), characters: "ℑ" },
    Entity { entity: "&Imacr;", codepoints: Codepoints::Single(298), characters: "Ī" },
    Entity { entity: "&imacr;", codepoints: Codepoints::Single(299), characters: "ī" },
    Entity { entity: "&image;", codepoints: Codepoints::Single(8465), characters: "ℑ" },
    Entity { entity: "&ImaginaryI;", codepoints: Codepoints::Single(8520), characters: "ⅈ" },
    Entity { entity: "&imagline;", codepoints: Codepoints::Single(8464), characters: "ℐ" },
    Entity { entity: "&imagpart;", codepoints: Codepoints::Single(8465), characters: "ℑ" },
    Entity { entity: "&imath;", codepoints: Codepoints::Single(305), characters: "ı" },
    Entity { entity: "&imof;", codepoints: Codepoints::Single(8887), characters: "⊷" },
    Entity { entity: "&imped;", codepoints: Codepoints::Single(437), characters: "Ƶ" },
    Entity { entity: "&Implies;", codepoints: Codepoints::Single(8658), characters: "⇒" },
    Entity { entity: "&in;", codepoints: Codepoints::Single(8712), characters: "∈" },
    Entity { entity: "&incare;", codepoints: Codepoints::Single(8453), characters: "℅" },
    Entity { entity: "&infin;", codepoints: Codepoints::Single(8734), characters: "∞" },
    Entity { entity: "&infintie;", codepoints: Codepoints::Single(10717), characters: "⧝" },
    Entity { entity: "&inodot;", codepoints: Codepoints::Single(305), characters: "ı" },
    Entity { entity: "&Int;", codepoints: Codepoints::Single(8748), characters: "∬" },
    Entity { entity: "&int;", codepoints: Codepoints::Single(8747), characters: "∫" },
    Entity { entity: "&intcal;", codepoints: Codepoints::Single(8890), characters: "⊺" },
    Entity { entity: "&integers;", codepoints: Codepoints::Single(8484), characters: "ℤ" },
    Entity { entity: "&Integral;", codepoints: Codepoints::Single(8747), characters: "∫" },
    Entity { entity: "&intercal;", codepoints: Codepoints::Single(8890), characters: "⊺" },
    Entity { entity: "&Intersection;", codepoints: Codepoints::Single(8898), characters: "⋂" },
    Entity { entity: "&intlarhk;", codepoints: Codepoints::Single(10775), characters: "⨗" },
    Entity { entity: "&intprod;", codepoints: Codepoints::Single(10812), characters: "⨼" },
    Entity { entity: "&InvisibleComma;", codepoints: Codepoints::Single(8291), characters: "⁣" },
    Entity { entity: "&InvisibleTimes;", codepoints: Codepoints::Single(8290), characters: "⁢" },
    Entity { entity: "&IOcy;", codepoints: Codepoints::Single(1025), characters: "Ё" },
    Entity { entity: "&iocy;", codepoints: Codepoints::Single(1105), characters: "ё" },
    Entity { entity: "&Iogon;", codepoints: Codepoints::Single(302), characters: "Į" },
    Entity { entity: "&iogon;", codepoints: Codepoints::Single(303), characters: "į" },
    Entity { entity: "&Iopf;", codepoints: Codepoints::Single(120128), characters: "𝕀" },
    Entity { entity: "&iopf;", codepoints: Codepoints::Single(120154), characters: "𝕚" },
    Entity { entity: "&Iota;", codepoints: Codepoints::Single(921), characters: "Ι" },
    Entity { entity: "&iota;", codepoints: Codepoints::Single(953), characters: "ι" },
    Entity { entity: "&iprod;", codepoints: Codepoints::Single(10812), characters: "⨼" },
    Entity { entity: "&iquest;", codepoints: Codepoints::Single(191), characters: "¿" },
    Entity { entity: "&iquest", codepoints: Codepoints::Single(191), characters: "¿" },
    Entity { entity: "&Iscr;", codepoints: Codepoints::Single(8464), characters: "ℐ" },
    Entity { entity: "&iscr;", codepoints: Codepoints::Single(119998), characters: "𝒾" },
    Entity { entity: "&isin;", codepoints: Codepoints::Single(8712), characters: "∈" },
    Entity { entity: "&isindot;", codepoints: Codepoints::Single(8949), characters: "⋵" },
    Entity { entity: "&isinE;", codepoints: Codepoints::Single(8953), characters: "⋹" },
    Entity { entity: "&isins;", codepoints: Codepoints::Single(8948), characters: "⋴" },
    Entity { entity: "&isinsv;", codepoints: Codepoints::Single(8947), characters: "⋳" },
    Entity { entity: "&isinv;", codepoints: Codepoints::Single(8712), characters: "∈" },
    Entity { entity: "&it;", codepoints: Codepoints::Single(8290), characters: "⁢" },
    Entity { entity: "&Itilde;", codepoints: Codepoints::Single(296), characters: "Ĩ" },
    Entity { entity: "&itilde;", codepoints: Codepoints::Single(297), characters: "ĩ" },
    Entity { entity: "&Iukcy;", codepoints: Codepoints::Single(1030), characters: "І" },
    Entity { entity: "&iukcy;", codepoints: Codepoints::Single(1110), characters: "і" },
    Entity { entity: "&Iuml;", codepoints: Codepoints::Single(207), characters: "Ï" },
    Entity { entity: "&Iuml", codepoints: Codepoints::Single(207), characters: "Ï" },
    Entity { entity: "&iuml;", codepoints: Codepoints::Single(239), characters: "ï" },
    Entity { entity: "&iuml", codepoints: Codepoints::Single(239), characters: "ï" },
    Entity { entity: "&Jcirc;", codepoints: Codepoints::Single(308), characters: "Ĵ" },
    Entity { entity: "&jcirc;", codepoints: Codepoints::Single(309), characters: "ĵ" },
    Entity { entity: "&Jcy;", codepoints: Codepoints::Single(1049), characters: "Й" },
    Entity { entity: "&jcy;", codepoints: Codepoints::Single(1081), characters: "й" },
    Entity { entity: "&Jfr;", codepoints: Codepoints::Single(120077), characters: "𝔍" },
    Entity { entity: "&jfr;", codepoints: Codepoints::Single(120103), characters: "𝔧" },
    Entity { entity: "&jmath;", codepoints: Codepoints::Single(567), characters: "ȷ" },
    Entity { entity: "&Jopf;", codepoints: Codepoints::Single(120129), characters: "𝕁" },
    Entity { entity: "&jopf;", codepoints: Codepoints::Single(120155), characters: "𝕛" },
    Entity { entity: "&Jscr;", codepoints: Codepoints::Single(119973), characters: "𝒥" },
    Entity { entity: "&jscr;", codepoints: Codepoints::Single(119999), characters: "𝒿" },
    Entity { entity: "&Jsercy;", codepoints: Codepoints::Single(1032), characters: "Ј" },
    Entity { entity: "&jsercy;", codepoints: Codepoints::Single(1112), characters: "ј" },
    Entity { entity: "&Jukcy;", codepoints: Codepoints::Single(1028), characters: "Є" },
    Entity { entity: "&jukcy;", codepoints: Codepoints::Single(1108), characters: "є" },
    Entity { entity: "&Kappa;", codepoints: Codepoints::Single(922), characters: "Κ" },
    Entity { entity: "&kappa;", codepoints: Codepoints::Single(954), characters: "κ" },
    Entity { entity: "&kappav;", codepoints: Codepoints::Single(1008), characters: "ϰ" },
    Entity { entity: "&Kcedil;", codepoints: Codepoints::Single(310), characters: "Ķ" },
    Entity { entity: "&kcedil;", codepoints: Codepoints::Single(311), characters: "ķ" },
    Entity { entity: "&Kcy;", codepoints: Codepoints::Single(1050), characters: "К" },
    Entity { entity: "&kcy;", codepoints: Codepoints::Single(1082), characters: "к" },
    Entity { entity: "&Kfr;", codepoints: Codepoints::Single(120078), characters: "𝔎" },
    Entity { entity: "&kfr;", codepoints: Codepoints::Single(120104), characters: "𝔨" },
    Entity { entity: "&kgreen;", codepoints: Codepoints::Single(312), characters: "ĸ" },
    Entity { entity: "&KHcy;", codepoints: Codepoints::Single(1061), characters: "Х" },
    Entity { entity: "&khcy;", codepoints: Codepoints::Single(1093), characters: "х" },
    Entity { entity: "&KJcy;", codepoints: Codepoints::Single(1036), characters: "Ќ" },
    Entity { entity: "&kjcy;", codepoints: Codepoints::Single(1116), characters: "ќ" },
    Entity { entity: "&Kopf;", codepoints: Codepoints::Single(120130), characters: "𝕂" },
    Entity { entity: "&kopf;", codepoints: Codepoints::Single(120156), characters: "𝕜" },
    Entity { entity: "&Kscr;", codepoints: Codepoints::Single(119974), characters: "𝒦" },
    Entity { entity: "&kscr;", codepoints: Codepoints::Single(120000), characters: "𝓀" },
    Entity { entity: "&lAarr;", codepoints: Codepoints::Single(8666), characters: "⇚" },
    Entity { entity: "&Lacute;", codepoints: Codepoints::Single(313), characters: "Ĺ" },
    Entity { entity: "&lacute;", codepoints: Codepoints::Single(314), characters: "ĺ" },
    Entity { entity: "&laemptyv;", codepoints: Codepoints::Single(10676), characters: "⦴" },
    Entity { entity: "&lagran;", codepoints: Codepoints::Single(8466), characters: "ℒ" },
    Entity { entity: "&Lambda;", codepoints: Codepoints::Single(923), characters: "Λ" },
    Entity { entity: "&lambda;", codepoints: Codepoints::Single(955), characters: "λ" },
    Entity { entity: "&Lang;", codepoints: Codepoints::Single(10218), characters: "⟪" },
    Entity { entity: "&lang;", codepoints: Codepoints::Single(10216), characters: "⟨" },
    Entity { entity: "&langd;", codepoints: Codepoints::Single(10641), characters: "⦑" },
    Entity { entity: "&langle;", codepoints: Codepoints::Single(10216), characters: "⟨" },
    Entity { entity: "&lap;", codepoints: Codepoints::Single(10885), characters: "⪅" },
    Entity { entity: "&Laplacetrf;", codepoints: Codepoints::Single(8466), characters: "ℒ" },
    Entity { entity: "&laquo;", codepoints: Codepoints::Single(171), characters: "«" },
    Entity { entity: "&laquo", codepoints: Codepoints::Single(171), characters: "«" },
    Entity { entity: "&Larr;", codepoints: Codepoints::Single(8606), characters: "↞" },
    Entity { entity: "&lArr;", codepoints: Codepoints::Single(8656), characters: "⇐" },
    Entity { entity: "&larr;", codepoints: Codepoints::Single(8592), characters: "←" },
    Entity { entity: "&larrb;", codepoints: Codepoints::Single(8676), characters: "⇤" },
    Entity { entity: "&larrbfs;", codepoints: Codepoints::Single(10527), characters: "⤟" },
    Entity { entity: "&larrfs;", codepoints: Codepoints::Single(10525), characters: "⤝" },
    Entity { entity: "&larrhk;", codepoints: Codepoints::Single(8617), characters: "↩" },
    Entity { entity: "&larrlp;", codepoints: Codepoints::Single(8619), characters: "↫" },
    Entity { entity: "&larrpl;", codepoints: Codepoints::Single(10553), characters: "⤹" },
    Entity { entity: "&larrsim;", codepoints: Codepoints::Single(10611), characters: "⥳" },
    Entity { entity: "&larrtl;", codepoints: Codepoints::Single(8610), characters: "↢" },
    Entity { entity: "&lat;", codepoints: Codepoints::Single(10923), characters: "⪫" },
    Entity { entity: "&lAtail;", codepoints: Codepoints::Single(10523), characters: "⤛" },
    Entity { entity: "&latail;", codepoints: Codepoints::Single(10521), characters: "⤙" },
    Entity { entity: "&late;", codepoints: Codepoints::Single(10925), characters: "⪭" },
    Entity { entity: "&lates;", codepoints: Codepoints::Double(10925, 65024), characters: "⪭︀" },
    Entity { entity: "&lBarr;", codepoints: Codepoints::Single(10510), characters: "⤎" },
    Entity { entity: "&lbarr;", codepoints: Codepoints::Single(10508), characters: "⤌" },
    Entity { entity: "&lbbrk;", codepoints: Codepoints::Single(10098), characters: "❲" },
    Entity { entity: "&lbrace;", codepoints: Codepoints::Single(123), characters: "{" },
    Entity { entity: "&lbrack;", codepoints: Codepoints::Single(91), characters: "[" },
    Entity { entity: "&lbrke;", codepoints: Codepoints::Single(10635), characters: "⦋" },
    Entity { entity: "&lbrksld;", codepoints: Codepoints::Single(10639), characters: "⦏" },
    Entity { entity: "&lbrkslu;", codepoints: Codepoints::Single(10637), characters: "⦍" },
    Entity { entity: "&Lcaron;", codepoints: Codepoints::Single(317), characters: "Ľ" },
    Entity { entity: "&lcaron;", codepoints: Codepoints::Single(318), characters: "ľ" },
    Entity { entity: "&Lcedil;", codepoints: Codepoints::Single(315), characters: "Ļ" },
    Entity { entity: "&lcedil;", codepoints: Codepoints::Single(316), characters: "ļ" },
    Entity { entity: "&lceil;", codepoints: Codepoints::Single(8968), characters: "⌈" },
    Entity { entity: "&lcub;", codepoints: Codepoints::Single(123), characters: "{" },
    Entity { entity: "&Lcy;", codepoints: Codepoints::Single(1051), characters: "Л" },
    Entity { entity: "&lcy;", codepoints: Codepoints::Single(1083), characters: "л" },
    Entity { entity: "&ldca;", codepoints: Codepoints::Single(10550), characters: "⤶" },
    Entity { entity: "&ldquo;", codepoints: Codepoints::Single(8220), characters: "“" },
    Entity { entity: "&ldquor;", codepoints: Codepoints::Single(8222), characters: "„" },
    Entity { entity: "&ldrdhar;", codepoints: Codepoints::Single(10599), characters: "⥧" },
    Entity { entity: "&ldrushar;", codepoints: Codepoints::Single(10571), characters: "⥋" },
    Entity { entity: "&ldsh;", codepoints: Codepoints::Single(8626), characters: "↲" },
    Entity { entity: "&lE;", codepoints: Codepoints::Single(8806), characters: "≦" },
    Entity { entity: "&le;", codepoints: Codepoints::Single(8804), characters: "≤" },
    Entity { entity: "&LeftAngleBracket;", codepoints: Codepoints::Single(10216), characters: "⟨" },
    Entity { entity: "&LeftArrow;", codepoints: Codepoints::Single(8592), characters: "←" },
    Entity { entity: "&Leftarrow;", codepoints: Codepoints::Single(8656), characters: "⇐" },
    Entity { entity: "&leftarrow;", codepoints: Codepoints::Single(8592), characters: "←" },
    Entity { entity: "&LeftArrowBar;", codepoints: Codepoints::Single(8676), characters: "⇤" },
    Entity { entity: "&LeftArrowRightArrow;", codepoints: Codepoints::Single(8646), characters: "⇆" },
    Entity { entity: "&leftarrowtail;", codepoints: Codepoints::Single(8610), characters: "↢" },
    Entity { entity: "&LeftCeiling;", codepoints: Codepoints::Single(8968), characters: "⌈" },
    Entity { entity: "&LeftDoubleBracket;", codepoints: Codepoints::Single(10214), characters: "⟦" },
    Entity { entity: "&LeftDownTeeVector;", codepoints: Codepoints::Single(10593), characters: "⥡" },
    Entity { entity: "&LeftDownVector;", codepoints: Codepoints::Single(8643), characters: "⇃" },
    Entity { entity: "&LeftDownVectorBar;", codepoints: Codepoints::Single(10585), characters: "⥙" },
    Entity { entity: "&LeftFloor;", codepoints: Codepoints::Single(8970), characters: "⌊" },
    Entity { entity: "&leftharpoondown;", codepoints: Codepoints::Single(8637), characters: "↽" },
    Entity { entity: "&leftharpoonup;", codepoints: Codepoints::Single(8636), characters: "↼" },
    Entity { entity: "&leftleftarrows;", codepoints: Codepoints::Single(8647), characters: "⇇" },
    Entity { entity: "&LeftRightArrow;", codepoints: Codepoints::Single(8596), characters: "↔" },
    Entity { entity: "&Leftrightarrow;", codepoints: Codepoints::Single(8660), characters: "⇔" },
    Entity { entity: "&leftrightarrow;", codepoints: Codepoints::Single(8596), characters: "↔" },
    Entity { entity: "&leftrightarrows;", codepoints: Codepoints::Single(8646), characters: "⇆" },
    Entity { entity: "&leftrightharpoons;", codepoints: Codepoints::Single(8651), characters: "⇋" },
    Entity { entity: "&leftrightsquigarrow;", codepoints: Codepoints::Single(8621), characters: "↭" },
    Entity { entity: "&LeftRightVector;", codepoints: Codepoints::Single(10574), characters: "⥎" },
    Entity { entity: "&LeftTee;", codepoints: Codepoints::Single(8867), characters: "⊣" },
    Entity { entity: "&LeftTeeArrow;", codepoints: Codepoints::Single(8612), characters: "↤" },
    Entity { entity: "&LeftTeeVector;", codepoints: Codepoints::Single(10586), characters: "⥚" },
    Entity { entity: "&leftthreetimes;", codepoints: Codepoints::Single(8907), characters: "⋋" },
    Entity { entity: "&LeftTriangle;", codepoints: Codepoints::Single(8882), characters: "⊲" },
    Entity { entity: "&LeftTriangleBar;", codepoints: Codepoints::Single(10703), characters: "⧏" },
    Entity { entity: "&LeftTriangleEqual;", codepoints: Codepoints::Single(8884), characters: "⊴" },
    Entity { entity: "&LeftUpDownVector;", codepoints: Codepoints::Single(10577), characters: "⥑" },
    Entity { entity: "&LeftUpTeeVector;", codepoints: Codepoints::Single(10592), characters: "⥠" },
    Entity { entity: "&LeftUpVector;", codepoints: Codepoints::Single(8639), characters: "↿" },
    Entity { entity: "&LeftUpVectorBar;", codepoints: Codepoints::Single(10584), characters: "⥘" },
    Entity { entity: "&LeftVector;", codepoints: Codepoints::Single(8636), characters: "↼" },
    Entity { entity: "&LeftVectorBar;", codepoints: Codepoints::Single(10578), characters: "⥒" },
    Entity { entity: "&lEg;", codepoints: Codepoints::Single(10891), characters: "⪋" },
    Entity { entity: "&leg;", codepoints: Codepoints::Single(8922), characters: "⋚" },
    Entity { entity: "&leq;", codepoints: Codepoints::Single(8804), characters: "≤" },
    Entity { entity: "&leqq;", codepoints: Codepoints::Single(8806), characters: "≦" },
    Entity { entity: "&leqslant;", codepoints: Codepoints::Single(10877), characters: "⩽" },
    Entity { entity: "&les;", codepoints: Codepoints::Single(10877), characters: "⩽" },
    Entity { entity: "&lescc;", codepoints: Codepoints::Single(10920), characters: "⪨" },
    Entity { entity: "&lesdot;", codepoints: Codepoints::Single(10879), characters: "⩿" },
    Entity { entity: "&lesdoto;", codepoints: Codepoints::Single(10881), characters: "⪁" },
    Entity { entity: "&lesdotor;", codepoints: Codepoints::Single(10883), characters: "⪃" },
    Entity { entity: "&lesg;", codepoints: Codepoints::Double(8922, 65024), characters: "⋚︀" },
    Entity { entity: "&lesges;", codepoints: Codepoints::Single(10899), characters: "⪓" },
    Entity { entity: "&lessapprox;", codepoints: Codepoints::Single(10885), characters: "⪅" },
    Entity { entity: "&lessdot;", codepoints: Codepoints::Single(8918), characters: "⋖" },
    Entity { entity: "&lesseqgtr;", codepoints: Codepoints::Single(8922), characters: "⋚" },
    Entity { entity: "&lesseqqgtr;", codepoints: Codepoints::Single(10891), characters: "⪋" },
    Entity { entity: "&LessEqualGreater;", codepoints: Codepoints::Single(8922), characters: "⋚" },
    Entity { entity: "&LessFullEqual;", codepoints: Codepoints::Single(8806), characters: "≦" },
    Entity { entity: "&LessGreater;", codepoints: Codepoints::Single(8822), characters: "≶" },
    Entity { entity: "&lessgtr;", codepoints: Codepoints::Single(8822), characters: "≶" },
    Entity { entity: "&LessLess;", codepoints: Codepoints::Single(10913), characters: "⪡" },
    Entity { entity: "&lesssim;", codepoints: Codepoints::Single(8818), characters: "≲" },
    Entity { entity: "&LessSlantEqual;", codepoints: Codepoints::Single(10877), characters: "⩽" },
    Entity { entity: "&LessTilde;", codepoints: Codepoints::Single(8818), characters: "≲" },
    Entity { entity: "&lfisht;", codepoints: Codepoints::Single(10620), characters: "⥼" },
    Entity { entity: "&lfloor;", codepoints: Codepoints::Single(8970), characters: "⌊" },
    Entity { entity: "&Lfr;", codepoints: Codepoints::Single(120079), characters: "𝔏" },
    Entity { entity: "&lfr;", codepoints: Codepoints::Single(120105), characters: "𝔩" },
    Entity { entity: "&lg;", codepoints: Codepoints::Single(8822), characters: "≶" },
    Entity { entity: "&lgE;", codepoints: Codepoints::Single(10897), characters: "⪑" },
    Entity { entity: "&lHar;", codepoints: Codepoints::Single(10594), characters: "⥢" },
    Entity { entity: "&lhard;", codepoints: Codepoints::Single(8637), characters: "↽" },
    Entity { entity: "&lharu;", codepoints: Codepoints::Single(8636), characters: "↼" },
    Entity { entity: "&lharul;", codepoints: Codepoints::Single(10602), characters: "⥪" },
    Entity { entity: "&lhblk;", codepoints: Codepoints::Single(9604), characters: "▄" },
    Entity { entity: "&LJcy;", codepoints: Codepoints::Single(1033), characters: "Љ" },
    Entity { entity: "&ljcy;", codepoints: Codepoints::Single(1113), characters: "љ" },
    Entity { entity: "&Ll;", codepoints: Codepoints::Single(8920), characters: "⋘" },
    Entity { entity: "&ll;", codepoints: Codepoints::Single(8810), characters: "≪" },
    Entity { entity: "&llarr;", codepoints: Codepoints::Single(8647), characters: "⇇" },
    Entity { entity: "&llcorner;", codepoints: Codepoints::Single(8990), characters: "⌞" },
    Entity { entity: "&Lleftarrow;", codepoints: Codepoints::Single(8666), characters: "⇚" },
    Entity { entity: "&llhard;", codepoints: Codepoints::Single(10603), characters: "⥫" },
    Entity { entity: "&lltri;", codepoints: Codepoints::Single(9722), characters: "◺" },
    Entity { entity: "&Lmidot;", codepoints: Codepoints::Single(319), characters: "Ŀ" },
    Entity { entity: "&lmidot;", codepoints: Codepoints::Single(320), characters: "ŀ" },
    Entity { entity: "&lmoust;", codepoints: Codepoints::Single(9136), characters: "⎰" },
    Entity { entity: "&lmoustache;", codepoints: Codepoints::Single(9136), characters: "⎰" },
    Entity { entity: "&lnap;", codepoints: Codepoints::Single(10889), characters: "⪉" },
    Entity { entity: "&lnapprox;", codepoints: Codepoints::Single(10889), characters: "⪉" },
    Entity { entity: "&lnE;", codepoints: Codepoints::Single(8808), characters: "≨" },
    Entity { entity: "&lne;", codepoints: Codepoints::Single(10887), characters: "⪇" },
    Entity { entity: "&lneq;", codepoints: Codepoints::Single(10887), characters: "⪇" },
    Entity { entity: "&lneqq;", codepoints: Codepoints::Single(8808), characters: "≨" },
    Entity { entity: "&lnsim;", codepoints: Codepoints::Single(8934), characters: "⋦" },
    Entity { entity: "&loang;", codepoints: Codepoints::Single(10220), characters: "⟬" },
    Entity { entity: "&loarr;", codepoints: Codepoints::Single(8701), characters: "⇽" },
    Entity { entity: "&lobrk;", codepoints: Codepoints::Single(10214), characters: "⟦" },
    Entity { entity: "&LongLeftArrow;", codepoints: Codepoints::Single(10229), characters: "⟵" },
    Entity { entity: "&Longleftarrow;", codepoints: Codepoints::Single(10232), characters: "⟸" },
    Entity { entity: "&longleftarrow;", codepoints: Codepoints::Single(10229), characters: "⟵" },
    Entity { entity: "&LongLeftRightArrow;", codepoints: Codepoints::Single(10231), characters: "⟷" },
    Entity { entity: "&Longleftrightarrow;", codepoints: Codepoints::Single(10234), characters: "⟺" },
    Entity { entity: "&longleftrightarrow;", codepoints: Codepoints::Single(10231), characters: "⟷" },
    Entity { entity: "&longmapsto;", codepoints: Codepoints::Single(10236), characters: "⟼" },
    Entity { entity: "&LongRightArrow;", codepoints: Codepoints::Single(10230), characters: "⟶" },
    Entity { entity: "&Longrightarrow;", codepoints: Codepoints::Single(10233), characters: "⟹" },
    Entity { entity: "&longrightarrow;", codepoints: Codepoints::Single(10230), characters: "⟶" },
    Entity { entity: "&looparrowleft;", codepoints: Codepoints::Single(8619), characters: "↫" },
    Entity { entity: "&looparrowright;", codepoints: Codepoints::Single(8620), characters: "↬" },
    Entity { entity: "&lopar;", codepoints: Codepoints::Single(10629), characters: "⦅" },
    Entity { entity: "&Lopf;", codepoints: Codepoints::Single(120131), characters: "𝕃" },
    Entity { entity: "&lopf;", codepoints: Codepoints::Single(120157), characters: "𝕝" },
    Entity { entity: "&loplus;", codepoints: Codepoints::Single(10797), characters: "⨭" },
    Entity { entity: "&lotimes;", codepoints: Codepoints::Single(10804), characters: "⨴" },
    Entity { entity: "&lowast;", codepoints: Codepoints::Single(8727), characters: "∗" },
    Entity { entity: "&lowbar;", codepoints: Codepoints::Single(95), characters: "_" },
    Entity { entity: "&LowerLeftArrow;", codepoints: Codepoints::Single(8601), characters: "↙" },
    Entity { entity: "&LowerRightArrow;", codepoints: Codepoints::Single(8600), characters: "↘" },
    Entity { entity: "&loz;", codepoints: Codepoints::Single(9674), characters: "◊" },
    Entity { entity: "&lozenge;", codepoints: Codepoints::Single(9674), characters: "◊" },
    Entity { entity: "&lozf;", codepoints: Codepoints::Single(10731), characters: "⧫" },
    Entity { entity: "&lpar;", codepoints: Codepoints::Single(40), characters: "(" },
    Entity { entity: "&lparlt;", codepoints: Codepoints::Single(10643), characters: "⦓" },
    Entity { entity: "&lrarr;", codepoints: Codepoints::Single(8646), characters: "⇆" },
    Entity { entity: "&lrcorner;", codepoints: Codepoints::Single(8991), characters: "⌟" },
    Entity { entity: "&lrhar;", codepoints: Codepoints::Single(8651), characters: "⇋" },
    Entity { entity: "&lrhard;", codepoints: Codepoints::Single(10605), characters: "⥭" },
    Entity { entity: "&lrm;", codepoints: Codepoints::Single(8206), characters: "‎" },
    Entity { entity: "&lrtri;", codepoints: Codepoints::Single(8895), characters: "⊿" },
    Entity { entity: "&lsaquo;", codepoints: Codepoints::Single(8249), characters: "‹" },
    Entity { entity: "&Lscr;", codepoints: Codepoints::Single(8466), characters: "ℒ" },
    Entity { entity: "&lscr;", codepoints: Codepoints::Single(120001), characters: "𝓁" },
    Entity { entity: "&Lsh;", codepoints: Codepoints::Single(8624), characters: "↰" },
    Entity { entity: "&lsh;", codepoints: Codepoints::Single(8624), characters: "↰" },
    Entity { entity: "&lsim;", codepoints: Codepoints::Single(8818), characters: "≲" },
    Entity { entity: "&lsime;", codepoints: Codepoints::Single(10893), characters: "⪍" },
    Entity { entity: "&lsimg;", codepoints: Codepoints::Single(10895), characters: "⪏" },
    Entity { entity: "&lsqb;", codepoints: Codepoints::Single(91), characters: "[" },
    Entity { entity: "&lsquo;", codepoints: Codepoints::Single(8216), characters: "‘" },
    Entity { entity: "&lsquor;", codepoints: Codepoints::Single(8218), characters: "‚" },
    Entity { entity: "&Lstrok;", codepoints: Codepoints::Single(321), characters: "Ł" },
    Entity { entity: "&lstrok;", codepoints: Codepoints::Single(322), characters: "ł" },
    Entity { entity: "&LT;", codepoints: Codepoints::Single(60), characters: "<" },
    Entity { entity: "&LT", codepoints: Codepoints::Single(60), characters: "<" },
    Entity { entity: "&Lt;", codepoints: Codepoints::Single(8810), characters: "≪" },
    Entity { entity: "&lt;", codepoints: Codepoints::Single(60), characters: "<" },
    Entity { entity: "&lt", codepoints: Codepoints::Single(60), characters: "<" },
    Entity { entity: "&ltcc;", codepoints: Codepoints::Single(10918), characters: "⪦" },
    Entity { entity: "&ltcir;", codepoints: Codepoints::Single(10873), characters: "⩹" },
    Entity { entity: "&ltdot;", codepoints: Codepoints::Single(8918), characters: "⋖" },
    Entity { entity: "&lthree;", codepoints: Codepoints::Single(8907), characters: "⋋" },
    Entity { entity: "&ltimes;", codepoints: Codepoints::Single(8905), characters: "⋉" },
    Entity { entity: "&ltlarr;", codepoints: Codepoints::Single(10614), characters: "⥶" },
    Entity { entity: "&ltquest;", codepoints: Codepoints::Single(10875), characters: "⩻" },
    Entity { entity: "&ltri;", codepoints: Codepoints::Single(9667), characters: "◃" },
    Entity { entity: "&ltrie;", codepoints: Codepoints::Single(8884), characters: "⊴" },
    Entity { entity: "&ltrif;", codepoints: Codepoints::Single(9666), characters: "◂" },
    Entity { entity: "&ltrPar;", codepoints: Codepoints::Single(10646), characters: "⦖" },
    Entity { entity: "&lurdshar;", codepoints: Codepoints::Single(10570), characters: "⥊" },
    Entity { entity: "&luruhar;", codepoints: Codepoints::Single(10598), characters: "⥦" },
    Entity { entity: "&lvertneqq;", codepoints: Codepoints::Double(8808, 65024), characters: "≨︀" },
    Entity { entity: "&lvnE;", codepoints: Codepoints::Double(8808, 65024), characters: "≨︀" },
    Entity { entity: "&macr;", codepoints: Codepoints::Single(175), characters: "¯" },
    Entity { entity: "&macr", codepoints: Codepoints::Single(175), characters: "¯" },
    Entity { entity: "&male;", codepoints: Codepoints::Single(9794), characters: "♂" },
    Entity { entity: "&malt;", codepoints: Codepoints::Single(10016), characters: "✠" },
    Entity { entity: "&maltese;", codepoints: Codepoints::Single(10016), characters: "✠" },
    Entity { entity: "&Map;", codepoints: Codepoints::Single(10501), characters: "⤅" },
    Entity { entity: "&map;", codepoints: Codepoints::Single(8614), characters: "↦" },
    Entity { entity: "&mapsto;", codepoints: Codepoints::Single(8614), characters: "↦" },
    Entity { entity: "&mapstodown;", codepoints: Codepoints::Single(8615), characters: "↧" },
    Entity { entity: "&mapstoleft;", codepoints: Codepoints::Single(8612), characters: "↤" },
    Entity { entity: "&mapstoup;", codepoints: Codepoints::Single(8613), characters: "↥" },
    Entity { entity: "&marker;", codepoints: Codepoints::Single(9646), characters: "▮" },
    Entity { entity: "&mcomma;", codepoints: Codepoints::Single(10793), characters: "⨩" },
    Entity { entity: "&Mcy;", codepoints: Codepoints::Single(1052), characters: "М" },
    Entity { entity: "&mcy;", codepoints: Codepoints::Single(1084), characters: "м" },
    Entity { entity: "&mdash;", codepoints: Codepoints::Single(8212), characters: "—" },
    Entity { entity: "&mDDot;", codepoints: Codepoints::Single(8762), characters: "∺" },
    Entity { entity: "&measuredangle;", codepoints: Codepoints::Single(8737), characters: "∡" },
    Entity { entity: "&MediumSpace;", codepoints: Codepoints::Single(8287), characters: " " },
    Entity { entity: "&Mellintrf;", codepoints: Codepoints::Single(8499), characters: "ℳ" },
    Entity { entity: "&Mfr;", codepoints: Codepoints::Single(120080), characters: "𝔐" },
    Entity { entity: "&mfr;", codepoints: Codepoints::Single(120106), characters: "𝔪" },
    Entity { entity: "&mho;", codepoints: Codepoints::Single(8487), characters: "℧" },
    Entity { entity: "&micro;", codepoints: Codepoints::Single(181), characters: "µ" },
    Entity { entity: "&micro", codepoints: Codepoints::Single(181), characters: "µ" },
    Entity { entity: "&mid;", codepoints: Codepoints::Single(8739), characters: "∣" },
    Entity { entity: "&midast;", codepoints: Codepoints::Single(42), characters: "*" },
    Entity { entity: "&midcir;", codepoints: Codepoints::Single(10992), characters: "⫰" },
    Entity { entity: "&middot;", codepoints: Codepoints::Single(183), characters: "·" },
    Entity { entity: "&middot", codepoints: Codepoints::Single(183), characters: "·" },
    Entity { entity: "&minus;", codepoints: Codepoints::Single(8722), characters: "−" },
    Entity { entity: "&minusb;", codepoints: Codepoints::Single(8863), characters: "⊟" },
    Entity { entity: "&minusd;", codepoints: Codepoints::Single(8760), characters: "∸" },
    Entity { entity: "&minusdu;", codepoints: Codepoints::Single(10794), characters: "⨪" },
    Entity { entity: "&MinusPlus;", codepoints: Codepoints::Single(8723), characters: "∓" },
    Entity { entity: "&mlcp;", codepoints: Codepoints::Single(10971), characters: "⫛" },
    Entity { entity: "&mldr;", codepoints: Codepoints::Single(8230), characters: "…" },
    Entity { entity: "&mnplus;", codepoints: Codepoints::Single(8723), characters: "∓" },
    Entity { entity: "&models;", codepoints: Codepoints::Single(8871), characters: "⊧" },
    Entity { entity: "&Mopf;", codepoints: Codepoints::Single(120132), characters: "𝕄" },
    Entity { entity: "&mopf;", codepoints: Codepoints::Single(120158), characters: "𝕞" },
    Entity { entity: "&mp;", codepoints: Codepoints::Single(8723), characters: "∓" },
    Entity { entity: "&Mscr;", codepoints: Codepoints::Single(8499), characters: "ℳ" },
    Entity { entity: "&mscr;", codepoints: Codepoints::Single(120002), characters: "𝓂" },
    Entity { entity: "&mstpos;", codepoints: Codepoints::Single(8766), characters: "∾" },
    Entity { entity: "&Mu;", codepoints: Codepoints::Single(924), characters: "Μ" },
    Entity { entity: "&mu;", codepoints: Codepoints::Single(956), characters: "μ" },
    Entity { entity: "&multimap;", codepoints: Codepoints::Single(8888), characters: "⊸" },
    Entity { entity: "&mumap;", codepoints: Codepoints::Single(8888), characters: "⊸" },
    Entity { entity: "&nabla;", codepoints: Codepoints::Single(8711), characters: "∇" },
    Entity { entity: "&Nacute;", codepoints: Codepoints::Single(323), characters: "Ń" },
    Entity { entity: "&nacute;", codepoints: Codepoints::Single(324), characters: "ń" },
    Entity { entity: "&nang;", codepoints: Codepoints::Double(8736, 8402), characters: "∠⃒" },
    Entity { entity: "&nap;", codepoints: Codepoints::Single(8777), characters: "≉" },
    Entity { entity: "&napE;", codepoints: Codepoints::Double(10864, 824), characters: "⩰̸" },
    Entity { entity: "&napid;", codepoints: Codepoints::Double(8779, 824), characters: "≋̸" },
    Entity { entity: "&napos;", codepoints: Codepoints::Single(329), characters: "ŉ" },
    Entity { entity: "&napprox;", codepoints: Codepoints::Single(8777), characters: "≉" },
    Entity { entity: "&natur;", codepoints: Codepoints::Single(9838), characters: "♮" },
    Entity { entity: "&natural;", codepoints: Codepoints::Single(9838), characters: "♮" },
    Entity { entity: "&naturals;", codepoints: Codepoints::Single(8469), characters: "ℕ" },
    Entity { entity: "&nbsp;", codepoints: Codepoints::Single(160), characters: " " },
    Entity { entity: "&nbsp", codepoints: Codepoints::Single(160), characters: " " },
    Entity { entity: "&nbump;", codepoints: Codepoints::Double(8782, 824), characters: "≎̸" },
    Entity { entity: "&nbumpe;", codepoints: Codepoints::Double(8783, 824), characters: "≏̸" },
    Entity { entity: "&ncap;", codepoints: Codepoints::Single(10819), characters: "⩃" },
    Entity { entity: "&Ncaron;", codepoints: Codepoints::Single(327), characters: "Ň" },
    Entity { entity: "&ncaron;", codepoints: Codepoints::Single(328), characters: "ň" },
    Entity { entity: "&Ncedil;", codepoints: Codepoints::Single(325), characters: "Ņ" },
    Entity { entity: "&ncedil;", codepoints: Codepoints::Single(326), characters: "ņ" },
    Entity { entity: "&ncong;", codepoints: Codepoints::Single(8775), characters: "≇" },
    Entity { entity: "&ncongdot;", codepoints: Codepoints::Double(10861, 824), characters: "⩭̸" },
    Entity { entity: "&ncup;", codepoints: Codepoints::Single(10818), characters: "⩂" },
    Entity { entity: "&Ncy;", codepoints: Codepoints::Single(1053), characters: "Н" },
    Entity { entity: "&ncy;", codepoints: Codepoints::Single(1085), characters: "н" },
    Entity { entity: "&ndash;", codepoints: Codepoints::Single(8211), characters: "–" },
    Entity { entity: "&ne;", codepoints: Codepoints::Single(8800), characters: "≠" },
    Entity { entity: "&nearhk;", codepoints: Codepoints::Single(10532), characters: "⤤" },
    Entity { entity: "&neArr;", codepoints: Codepoints::Single(8663), characters: "⇗" },
    Entity { entity: "&nearr;", codepoints: Codepoints::Single(8599), characters: "↗" },
    Entity { entity: "&nearrow;", codepoints: Codepoints::Single(8599), characters: "↗" },
    Entity { entity: "&nedot;", codepoints: Codepoints::Double(8784, 824), characters: "≐̸" },
    Entity { entity: "&NegativeMediumSpace;", codepoints: Codepoints::Single(8203), characters: "​" },
    Entity { entity: "&NegativeThickSpace;", codepoints: Codepoints::Single(8203), characters: "​" },
    Entity { entity: "&NegativeThinSpace;", codepoints: Codepoints::Single(8203), characters: "​" },
    Entity { entity: "&NegativeVeryThinSpace;", codepoints: Codepoints::Single(8203), characters: "​" },
    Entity { entity: "&nequiv;", codepoints: Codepoints::Single(8802), characters: "≢" },
    Entity { entity: "&nesear;", codepoints: Codepoints::Single(10536), characters: "⤨" },
    Entity { entity: "&nesim;", codepoints: Codepoints::Double(8770, 824), characters: "≂̸" },
    Entity { entity: "&NestedGreaterGreater;", codepoints: Codepoints::Single(8811), characters: "≫" },
    Entity { entity: "&NestedLessLess;", codepoints: Codepoints::Single(8810), characters: "≪" },
    Entity { entity: "&NewLine;", codepoints: Codepoints::Single(10), characters: "
" },
    Entity { entity: "&nexist;", codepoints: Codepoints::Single(8708), characters: "∄" },
    Entity { entity: "&nexists;", codepoints: Codepoints::Single(8708), characters: "∄" },
    Entity { entity: "&Nfr;", codepoints: Codepoints::Single(120081), characters: "𝔑" },
    Entity { entity: "&nfr;", codepoints: Codepoints::Single(120107), characters: "𝔫" },
    Entity { entity: "&ngE;", codepoints: Codepoints::Double(8807, 824), characters: "≧̸" },
    Entity { entity: "&nge;", codepoints: Codepoints::Single(8817), characters: "≱" },
    Entity { entity: "&ngeq;", codepoints: Codepoints::Single(8817), characters: "≱" },
    Entity { entity: "&ngeqq;", codepoints: Codepoints::Double(8807, 824), characters: "≧̸" },
    Entity { entity: "&ngeqslant;", codepoints: Codepoints::Double(10878, 824), characters: "⩾̸" },
    Entity { entity: "&nges;", codepoints: Codepoints::Double(10878, 824), characters: "⩾̸" },
    Entity { entity: "&nGg;", codepoints: Codepoints::Double(8921, 824), characters: "⋙̸" },
    Entity { entity: "&ngsim;", codepoints: Codepoints::Single(8821), characters: "≵" },
    Entity { entity: "&nGt;", codepoints: Codepoints::Double(8811, 8402), characters: "≫⃒" },
    Entity { entity: "&ngt;", codepoints: Codepoints::Single(8815), characters: "≯" },
    Entity { entity: "&ngtr;", codepoints: Codepoints::Single(8815), characters: "≯" },
    Entity { entity: "&nGtv;", codepoints: Codepoints::Double(8811, 824), characters: "≫̸" },
    Entity { entity: "&nhArr;", codepoints: Codepoints::Single(8654), characters: "⇎" },
    Entity { entity: "&nharr;", codepoints: Codepoints::Single(8622), characters: "↮" },
    Entity { entity: "&nhpar;", codepoints: Codepoints::Single(10994), characters: "⫲" },
    Entity { entity: "&ni;", codepoints: Codepoints::Single(8715), characters: "∋" },
    Entity { entity: "&nis;", codepoints: Codepoints::Single(8956), characters: "⋼" },
    Entity { entity: "&nisd;", codepoints: Codepoints::Single(8954), characters: "⋺" },
    Entity { entity: "&niv;", codepoints: Codepoints::Single(8715), characters: "∋" },
    Entity { entity: "&NJcy;", codepoints: Codepoints::Single(1034), characters: "Њ" },
    Entity { entity: "&njcy;", codepoints: Codepoints::Single(1114), characters: "њ" },
    Entity { entity: "&nlArr;", codepoints: Codepoints::Single(8653), characters: "⇍" },
    Entity { entity: "&nlarr;", codepoints: Codepoints::Single(8602), characters: "↚" },
    Entity { entity: "&nldr;", codepoints: Codepoints::Single(8229), characters: "‥" },
    Entity { entity: "&nlE;", codepoints: Codepoints::Double(8806, 824), characters: "≦̸" },
    Entity { entity: "&nle;", codepoints: Codepoints::Single(8816), characters: "≰" },
    Entity { entity: "&nLeftarrow;", codepoints: Codepoints::Single(8653), characters: "⇍" },
    Entity { entity: "&nleftarrow;", codepoints: Codepoints::Single(8602), characters: "↚" },
    Entity { entity: "&nLeftrightarrow;", codepoints: Codepoints::Single(8654), characters: "⇎" },
    Entity { entity: "&nleftrightarrow;", codepoints: Codepoints::Single(8622), characters: "↮" },
    Entity { entity: "&nleq;", codepoints: Codepoints::Single(8816), characters: "≰" },
    Entity { entity: "&nleqq;", codepoints: Codepoints::Double(8806, 824), characters: "≦̸" },
    Entity { entity: "&nleqslant;", codepoints: Codepoints::Double(10877, 824), characters: "⩽̸" },
    Entity { entity: "&nles;", codepoints: Codepoints::Double(10877, 824), characters: "⩽̸" },
    Entity { entity: "&nless;", codepoints: Codepoints::Single(8814), characters: "≮" },
    Entity { entity: "&nLl;", codepoints: Codepoints::Double(8920, 824), characters: "⋘̸" },
    Entity { entity: "&nlsim;", codepoints: Codepoints::Single(8820), characters: "≴" },
    Entity { entity: "&nLt;", codepoints: Codepoints::Double(8810, 8402), characters: "≪⃒" },
    Entity { entity: "&nlt;", codepoints: Codepoints::Single(8814), characters: "≮" },
    Entity { entity: "&nltri;", codepoints: Codepoints::Single(8938), characters: "⋪" },
    Entity { entity: "&nltrie;", codepoints: Codepoints::Single(8940), characters: "⋬" },
    Entity { entity: "&nLtv;", codepoints: Codepoints::Double(8810, 824), characters: "≪̸" },
    Entity { entity: "&nmid;", codepoints: Codepoints::Single(8740), characters: "∤" },
    Entity { entity: "&NoBreak;", codepoints: Codepoints::Single(8288), characters: "⁠" },
    Entity { entity: "&NonBreakingSpace;", codepoints: Codepoints::Single(160), characters: " " },
    Entity { entity: "&Nopf;", codepoints: Codepoints::Single(8469), characters: "ℕ" },
    Entity { entity: "&nopf;", codepoints: Codepoints::Single(120159), characters: "𝕟" },
    Entity { entity: "&Not;", codepoints: Codepoints::Single(10988), characters: "⫬" },
    Entity { entity: "&not;", codepoints: Codepoints::Single(172), characters: "¬" },
    Entity { entity: "&not", codepoints: Codepoints::Single(172), characters: "¬" },
    Entity { entity: "&NotCongruent;", codepoints: Codepoints::Single(8802), characters: "≢" },
    Entity { entity: "&NotCupCap;", codepoints: Codepoints::Single(8813), characters: "≭" },
    Entity { entity: "&NotDoubleVerticalBar;", codepoints: Codepoints::Single(8742), characters: "∦" },
    Entity { entity: "&NotElement;", codepoints: Codepoints::Single(8713), characters: "∉" },
    Entity { entity: "&NotEqual;", codepoints: Codepoints::Single(8800), characters: "≠" },
    Entity { entity: "&NotEqualTilde;", codepoints: Codepoints::Double(8770, 824), characters: "≂̸" },
    Entity { entity: "&NotExists;", codepoints: Codepoints::Single(8708), characters: "∄" },
    Entity { entity: "&NotGreater;", codepoints: Codepoints::Single(8815), characters: "≯" },
    Entity { entity: "&NotGreaterEqual;", codepoints: Codepoints::Single(8817), characters: "≱" },
    Entity { entity: "&NotGreaterFullEqual;", codepoints: Codepoints::Double(8807, 824), characters: "≧̸" },
    Entity { entity: "&NotGreaterGreater;", codepoints: Codepoints::Double(8811, 824), characters: "≫̸" },
    Entity { entity: "&NotGreaterLess;", codepoints: Codepoints::Single(8825), characters: "≹" },
    Entity { entity: "&NotGreaterSlantEqual;", codepoints: Codepoints::Double(10878, 824), characters: "⩾̸" },
    Entity { entity: "&NotGreaterTilde;", codepoints: Codepoints::Single(8821), characters: "≵" },
    Entity { entity: "&NotHumpDownHump;", codepoints: Codepoints::Double(8782, 824), characters: "≎̸" },
    Entity { entity: "&NotHumpEqual;", codepoints: Codepoints::Double(8783, 824), characters: "≏̸" },
    Entity { entity: "&notin;", codepoints: Codepoints::Single(8713), characters: "∉" },
    Entity { entity: "&notindot;", codepoints: Codepoints::Double(8949, 824), characters: "⋵̸" },
    Entity { entity: "&notinE;", codepoints: Codepoints::Double(8953, 824), characters: "⋹̸" },
    Entity { entity: "&notinva;", codepoints: Codepoints::Single(8713), characters: "∉" },
    Entity { entity: "&notinvb;", codepoints: Codepoints::Single(8951), characters: "⋷" },
    Entity { entity: "&notinvc;", codepoints: Codepoints::Single(8950), characters: "⋶" },
    Entity { entity: "&NotLeftTriangle;", codepoints: Codepoints::Single(8938), characters: "⋪" },
    Entity { entity: "&NotLeftTriangleBar;", codepoints: Codepoints::Double(10703, 824), characters: "⧏̸" },
    Entity { entity: "&NotLeftTriangleEqual;", codepoints: Codepoints::Single(8940), characters: "⋬" },
    Entity { entity: "&NotLess;", codepoints: Codepoints::Single(8814), characters: "≮" },
    Entity { entity: "&NotLessEqual;", codepoints: Codepoints::Single(8816), characters: "≰" },
    Entity { entity: "&NotLessGreater;", codepoints: Codepoints::Single(8824), characters: "≸" },
    Entity { entity: "&NotLessLess;", codepoints: Codepoints::Double(8810, 824), characters: "≪̸" },
    Entity { entity: "&NotLessSlantEqual;", codepoints: Codepoints::Double(10877, 824), characters: "⩽̸" },
    Entity { entity: "&NotLessTilde;", codepoints: Codepoints::Single(8820), characters: "≴" },
    Entity { entity: "&NotNestedGreaterGreater;", codepoints: Codepoints::Double(10914, 824), characters: "⪢̸" },
    Entity { entity: "&NotNestedLessLess;", codepoints: Codepoints::Double(10913, 824), characters: "⪡̸" },
    Entity { entity: "&notni;", codepoints: Codepoints::Single(8716), characters: "∌" },
    Entity { entity: "&notniva;", codepoints: Codepoints::Single(8716), characters: "∌" },
    Entity { entity: "&notnivb;", codepoints: Codepoints::Single(8958), characters: "⋾" },
    Entity { entity: "&notnivc;", codepoints: Codepoints::Single(8957), characters: "⋽" },
    Entity { entity: "&NotPrecedes;", codepoints: Codepoints::Single(8832), characters: "⊀" },
    Entity { entity: "&NotPrecedesEqual;", codepoints: Codepoints::Double(10927, 824), characters: "⪯̸" },
    Entity { entity: "&NotPrecedesSlantEqual;", codepoints: Codepoints::Single(8928), characters: "⋠" },
    Entity { entity: "&NotReverseElement;", codepoints: Codepoints::Single(8716), characters: "∌" },
    Entity { entity: "&NotRightTriangle;", codepoints: Codepoints::Single(8939), characters: "⋫" },
    Entity { entity: "&NotRightTriangleBar;", codepoints: Codepoints::Double(10704, 824), characters: "⧐̸" },
    Entity { entity: "&NotRightTriangleEqual;", codepoints: Codepoints::Single(8941), characters: "⋭" },
    Entity { entity: "&NotSquareSubset;", codepoints: Codepoints::Double(8847, 824), characters: "⊏̸" },
    Entity { entity: "&NotSquareSubsetEqual;", codepoints: Codepoints::Single(8930), characters: "⋢" },
    Entity { entity: "&NotSquareSuperset;", codepoints: Codepoints::Double(8848, 824), characters: "⊐̸" },
    Entity { entity: "&NotSquareSupersetEqual;", codepoints: Codepoints::Single(8931), characters: "⋣" },
    Entity { entity: "&NotSubset;", codepoints: Codepoints::Double(8834, 8402), characters: "⊂⃒" },
    Entity { entity: "&NotSubsetEqual;", codepoints: Codepoints::Single(8840), characters: "⊈" },
    Entity { entity: "&NotSucceeds;", codepoints: Codepoints::Single(8833), characters: "⊁" },
    Entity { entity: "&NotSucceedsEqual;", codepoints: Codepoints::Double(10928, 824), characters: "⪰̸" },
    Entity { entity: "&NotSucceedsSlantEqual;", codepoints: Codepoints::Single(8929), characters: "⋡" },
    Entity { entity: "&NotSucceedsTilde;", codepoints: Codepoints::Double(8831, 824), characters: "≿̸" },
    Entity { entity: "&NotSuperset;", codepoints: Codepoints::Double(8835, 8402), characters: "⊃⃒" },
    Entity { entity: "&NotSupersetEqual;", codepoints: Codepoints::Single(8841), characters: "⊉" },
    Entity { entity: "&NotTilde;", codepoints: Codepoints::Single(8769), characters: "≁" },
    Entity { entity: "&NotTildeEqual;", codepoints: Codepoints::Single(8772), characters: "≄" },
    Entity { entity: "&NotTildeFullEqual;", codepoints: Codepoints::Single(8775), characters: "≇" },
    Entity { entity: "&NotTildeTilde;", codepoints: Codepoints::Single(8777), characters: "≉" },
    Entity { entity: "&NotVerticalBar;", codepoints: Codepoints::Single(8740), characters: "∤" },
    Entity { entity: "&npar;", codepoints: Codepoints::Single(8742), characters: "∦" },
    Entity { entity: "&nparallel;", codepoints: Codepoints::Single(8742), characters: "∦" },
    Entity { entity: "&nparsl;", codepoints: Codepoints::Double(11005, 8421), characters: "⫽⃥" },
    Entity { entity: "&npart;", codepoints: Codepoints::Double(8706, 824), characters: "∂̸" },
    Entity { entity: "&npolint;", codepoints: Codepoints::Single(10772), characters: "⨔" },
    Entity { entity: "&npr;", codepoints: Codepoints::Single(8832), characters: "⊀" },
    Entity { entity: "&nprcue;", codepoints: Codepoints::Single(8928), characters: "⋠" },
    Entity { entity: "&npre;", codepoints: Codepoints::Double(10927, 824), characters: "⪯̸" },
    Entity { entity: "&nprec;", codepoints: Codepoints::Single(8832), characters: "⊀" },
    Entity { entity: "&npreceq;", codepoints: Codepoints::Double(10927, 824), characters: "⪯̸" },
    Entity { entity: "&nrArr;", codepoints: Codepoints::Single(8655), characters: "⇏" },
    Entity { entity: "&nrarr;", codepoints: Codepoints::Single(8603), characters: "↛" },
    Entity { entity: "&nrarrc;", codepoints: Codepoints::Double(10547, 824), characters: "⤳̸" },
    Entity { entity: "&nrarrw;", codepoints: Codepoints::Double(8605, 824), characters: "↝̸" },
    Entity { entity: "&nRightarrow;", codepoints: Codepoints::Single(8655), characters: "⇏" },
    Entity { entity: "&nrightarrow;", codepoints: Codepoints::Single(8603), characters: "↛" },
    Entity { entity: "&nrtri;", codepoints: Codepoints::Single(8939), characters: "⋫" },
    Entity { entity: "&nrtrie;", codepoints: Codepoints::Single(8941), characters: "⋭" },
    Entity { entity: "&nsc;", codepoints: Codepoints::Single(8833), characters: "⊁" },
    Entity { entity: "&nsccue;", codepoints: Codepoints::Single(8929), characters: "⋡" },
    Entity { entity: "&nsce;", codepoints: Codepoints::Double(10928, 824), characters: "⪰̸" },
    Entity { entity: "&Nscr;", codepoints: Codepoints::Single(119977), characters: "𝒩" },
    Entity { entity: "&nscr;", codepoints: Codepoints::Single(120003), characters: "𝓃" },
    Entity { entity: "&nshortmid;", codepoints: Codepoints::Single(8740), characters: "∤" },
    Entity { entity: "&nshortparallel;", codepoints: Codepoints::Single(8742), characters: "∦" },
    Entity { entity: "&nsim;", codepoints: Codepoints::Single(8769), characters: "≁" },
    Entity { entity: "&nsime;", codepoints: Codepoints::Single(8772), characters: "≄" },
    Entity { entity: "&nsimeq;", codepoints: Codepoints::Single(8772), characters: "≄" },
    Entity { entity: "&nsmid;", codepoints: Codepoints::Single(8740), characters: "∤" },
    Entity { entity: "&nspar;", codepoints: Codepoints::Single(8742), characters: "∦" },
    Entity { entity: "&nsqsube;", codepoints: Codepoints::Single(8930), characters: "⋢" },
    Entity { entity: "&nsqsupe;", codepoints: Codepoints::Single(8931), characters: "⋣" },
    Entity { entity: "&nsub;", codepoints: Codepoints::Single(8836), characters: "⊄" },
    Entity { entity: "&nsubE;", codepoints: Codepoints::Double(10949, 824), characters: "⫅̸" },
    Entity { entity: "&nsube;", codepoints: Codepoints::Single(8840), characters: "⊈" },
    Entity { entity: "&nsubset;", codepoints: Codepoints::Double(8834, 8402), characters: "⊂⃒" },
    Entity { entity: "&nsubseteq;", codepoints: Codepoints::Single(8840), characters: "⊈" },
    Entity { entity: "&nsubseteqq;", codepoints: Codepoints::Double(10949, 824), characters: "⫅̸" },
    Entity { entity: "&nsucc;", codepoints: Codepoints::Single(8833), characters: "⊁" },
    Entity { entity: "&nsucceq;", codepoints: Codepoints::Double(10928, 824), characters: "⪰̸" },
    Entity { entity: "&nsup;", codepoints: Codepoints::Single(8837), characters: "⊅" },
    Entity { entity: "&nsupE;", codepoints: Codepoints::Double(10950, 824), characters: "⫆̸" },
    Entity { entity: "&nsupe;", codepoints: Codepoints::Single(8841), characters: "⊉" },
    Entity { entity: "&nsupset;", codepoints: Codepoints::Double(8835, 8402), characters: "⊃⃒" },
    Entity { entity: "&nsupseteq;", codepoints: Codepoints::Single(8841), characters: "⊉" },
    Entity { entity: "&nsupseteqq;", codepoints: Codepoints::Double(10950, 824), characters: "⫆̸" },
    Entity { entity: "&ntgl;", codepoints: Codepoints::Single(8825), characters: "≹" },
    Entity { entity: "&Ntilde;", codepoints: Codepoints::Single(209), characters: "Ñ" },
    Entity { entity: "&Ntilde", codepoints: Codepoints::Single(209), characters: "Ñ" },
    Entity { entity: "&ntilde;", codepoints: Codepoints::Single(241), characters: "ñ" },
    Entity { entity: "&ntilde", codepoints: Codepoints::Single(241), characters: "ñ" },
    Entity { entity: "&ntlg;", codepoints: Codepoints::Single(8824), characters: "≸" },
    Entity { entity: "&ntriangleleft;", codepoints: Codepoints::Single(8938), characters: "⋪" },
    Entity { entity: "&ntrianglelefteq;", codepoints: Codepoints::Single(8940), characters: "⋬" },
    Entity { entity: "&ntriangleright;", codepoints: Codepoints::Single(8939), characters: "⋫" },
    Entity { entity: "&ntrianglerighteq;", codepoints: Codepoints::Single(8941), characters: "⋭" },
    Entity { entity: "&Nu;", codepoints: Codepoints::Single(925), characters: "Ν" },
    Entity { entity: "&nu;", codepoints: Codepoints::Single(957), characters: "ν" },
    Entity { entity: "&num;", codepoints: Codepoints::Single(35), characters: "#" },
    Entity { entity: "&numero;", codepoints: Codepoints::Single(8470), characters: "№" },
    Entity { entity: "&numsp;", codepoints: Codepoints::Single(8199), characters: " " },
    Entity { entity: "&nvap;", codepoints: Codepoints::Double(8781, 8402), characters: "≍⃒" },
    Entity { entity: "&nVDash;", codepoints: Codepoints::Single(8879), characters: "⊯" },
    Entity { entity: "&nVdash;", codepoints: Codepoints::Single(8878), characters: "⊮" },
    Entity { entity: "&nvDash;", codepoints: Codepoints::Single(8877), characters: "⊭" },
    Entity { entity: "&nvdash;", codepoints: Codepoints::Single(8876), characters: "⊬" },
    Entity { entity: "&nvge;", codepoints: Codepoints::Double(8805, 8402), characters: "≥⃒" },
    Entity { entity: "&nvgt;", codepoints: Codepoints::Double(62, 8402), characters: ">⃒" },
    Entity { entity: "&nvHarr;", codepoints: Codepoints::Single(10500), characters: "⤄" },
    Entity { entity: "&nvinfin;", codepoints: Codepoints::Single(10718), characters: "⧞" },
    Entity { entity: "&nvlArr;", codepoints: Codepoints::Single(10498), characters: "⤂" },
    Entity { entity: "&nvle;", codepoints: Codepoints::Double(8804, 8402), characters: "≤⃒" },
    Entity { entity: "&nvlt;", codepoints: Codepoints::Double(60, 8402), characters: "<⃒" },
    Entity { entity: "&nvltrie;", codepoints: Codepoints::Double(8884, 8402), characters: "⊴⃒" },
    Entity { entity: "&nvrArr;", codepoints: Codepoints::Single(10499), characters: "⤃" },
    Entity { entity: "&nvrtrie;", codepoints: Codepoints::Double(8885, 8402), characters: "⊵⃒" },
    Entity { entity: "&nvsim;", codepoints: Codepoints::Double(8764, 8402), characters: "∼⃒" },
    Entity { entity: "&nwarhk;", codepoints: Codepoints::Single(10531), characters: "⤣" },
    Entity { entity: "&nwArr;", codepoints: Codepoints::Single(8662), characters: "⇖" },
    Entity { entity: "&nwarr;", codepoints: Codepoints::Single(8598), characters: "↖" },
    Entity { entity: "&nwarrow;", codepoints: Codepoints::Single(8598), characters: "↖" },
    Entity { entity: "&nwnear;", codepoints: Codepoints::Single(10535), characters: "⤧" },
    Entity { entity: "&Oacute;", codepoints: Codepoints::Single(211), characters: "Ó" },
    Entity { entity: "&Oacute", codepoints: Codepoints::Single(211), characters: "Ó" },
    Entity { entity: "&oacute;", codepoints: Codepoints::Single(243), characters: "ó" },
    Entity { entity: "&oacute", codepoints: Codepoints::Single(243), characters: "ó" },
    Entity { entity: "&oast;", codepoints: Codepoints::Single(8859), characters: "⊛" },
    Entity { entity: "&ocir;", codepoints: Codepoints::Single(8858), characters: "⊚" },
    Entity { entity: "&Ocirc;", codepoints: Codepoints::Single(212), characters: "Ô" },
    Entity { entity: "&Ocirc", codepoints: Codepoints::Single(212), characters: "Ô" },
    Entity { entity: "&ocirc;", codepoints: Codepoints::Single(244), characters: "ô" },
    Entity { entity: "&ocirc", codepoints: Codepoints::Single(244), characters: "ô" },
    Entity { entity: "&Ocy;", codepoints: Codepoints::Single(1054), characters: "О" },
    Entity { entity: "&ocy;", codepoints: Codepoints::Single(1086), characters: "о" },
    Entity { entity: "&odash;", codepoints: Codepoints::Single(8861), characters: "⊝" },
    Entity { entity: "&Odblac;", codepoints: Codepoints::Single(336), characters: "Ő" },
    Entity { entity: "&odblac;", codepoints: Codepoints::Single(337), characters: "ő" },
    Entity { entity: "&odiv;", codepoints: Codepoints::Single(10808), characters: "⨸" },
    Entity { entity: "&odot;", codepoints: Codepoints::Single(8857), characters: "⊙" },
    Entity { entity: "&odsold;", codepoints: Codepoints::Single(10684), characters: "⦼" },
    Entity { entity: "&OElig;", codepoints: Codepoints::Single(338), characters: "Œ" },
    Entity { entity: "&oelig;", codepoints: Codepoints::Single(339), characters: "œ" },
    Entity { entity: "&ofcir;", codepoints: Codepoints::Single(10687), characters: "⦿" },
    Entity { entity: "&Ofr;", codepoints: Codepoints::Single(120082), characters: "𝔒" },
    Entity { entity: "&ofr;", codepoints: Codepoints::Single(120108), characters: "𝔬" },
    Entity { entity: "&ogon;", codepoints: Codepoints::Single(731), characters: "˛" },
    Entity { entity: "&Ograve;", codepoints: Codepoints::Single(210), characters: "Ò" },
    Entity { entity: "&Ograve", codepoints: Codepoints::Single(210), characters: "Ò" },
    Entity { entity: "&ograve;", codepoints: Codepoints::Single(242), characters: "ò" },
    Entity { entity: "&ograve", codepoints: Codepoints::Single(242), characters: "ò" },
    Entity { entity: "&ogt;", codepoints: Codepoints::Single(10689), characters: "⧁" },
    Entity { entity: "&ohbar;", codepoints: Codepoints::Single(10677), characters: "⦵" },
    Entity { entity: "&ohm;", codepoints: Codepoints::Single(937), characters: "Ω" },
    Entity { entity: "&oint;", codepoints: Codepoints::Single(8750), characters: "∮" },
    Entity { entity: "&olarr;", codepoints: Codepoints::Single(8634), characters: "↺" },
    Entity { entity: "&olcir;", codepoints: Codepoints::Single(10686), characters: "⦾" },
    Entity { entity: "&olcross;", codepoints: Codepoints::Single(10683), characters: "⦻" },
    Entity { entity: "&oline;", codepoints: Codepoints::Single(8254), characters: "‾" },
    Entity { entity: "&olt;", codepoints: Codepoints::Single(10688), characters: "⧀" },
    Entity { entity: "&Omacr;", codepoints: Codepoints::Single(332), characters: "Ō" },
    Entity { entity: "&omacr;", codepoints: Codepoints::Single(333), characters: "ō" },
    Entity { entity: "&Omega;", codepoints: Codepoints::Single(937), characters: "Ω" },
    Entity { entity: "&omega;", codepoints: Codepoints::Single(969), characters: "ω" },
    Entity { entity: "&Omicron;", codepoints: Codepoints::Single(927), characters: "Ο" },
    Entity { entity: "&omicron;", codepoints: Codepoints::Single(959), characters: "ο" },
    Entity { entity: "&omid;", codepoints: Codepoints::Single(10678), characters: "⦶" },
    Entity { entity: "&ominus;", codepoints: Codepoints::Single(8854), characters: "⊖" },
    Entity { entity: "&Oopf;", codepoints: Codepoints::Single(120134), characters: "𝕆" },
    Entity { entity: "&oopf;", codepoints: Codepoints::Single(120160), characters: "𝕠" },
    Entity { entity: "&opar;", codepoints: Codepoints::Single(10679), characters: "⦷" },
    Entity { entity: "&OpenCurlyDoubleQuote;", codepoints: Codepoints::Single(8220), characters: "“" },
    Entity { entity: "&OpenCurlyQuote;", codepoints: Codepoints::Single(8216), characters: "‘" },
    Entity { entity: "&operp;", codepoints: Codepoints::Single(10681), characters: "⦹" },
    Entity { entity: "&oplus;", codepoints: Codepoints::Single(8853), characters: "⊕" },
    Entity { entity: "&Or;", codepoints: Codepoints::Single(10836), characters: "⩔" },
    Entity { entity: "&or;", codepoints: Codepoints::Single(8744), characters: "∨" },
    Entity { entity: "&orarr;", codepoints: Codepoints::Single(8635), characters: "↻" },
    Entity { entity: "&ord;", codepoints: Codepoints::Single(10845), characters: "⩝" },
    Entity { entity: "&order;", codepoints: Codepoints::Single(8500), characters: "ℴ" },
    Entity { entity: "&orderof;", codepoints: Codepoints::Single(8500), characters: "ℴ" },
    Entity { entity: "&ordf;", codepoints: Codepoints::Single(170), characters: "ª" },
    Entity { entity: "&ordf", codepoints: Codepoints::Single(170), characters: "ª" },
    Entity { entity: "&ordm;", codepoints: Codepoints::Single(186), characters: "º" },
    Entity { entity: "&ordm", codepoints: Codepoints::Single(186), characters: "º" },
    Entity { entity: "&origof;", codepoints: Codepoints::Single(8886), characters: "⊶" },
    Entity { entity: "&oror;", codepoints: Codepoints::Single(10838), characters: "⩖" },
    Entity { entity: "&orslope;", codepoints: Codepoints::Single(10839), characters: "⩗" },
    Entity { entity: "&orv;", codepoints: Codepoints::Single(10843), characters: "⩛" },
    Entity { entity: "&oS;", codepoints: Codepoints::Single(9416), characters: "Ⓢ" },
    Entity { entity: "&Oscr;", codepoints: Codepoints::Single(119978), characters: "𝒪" },
    Entity { entity: "&oscr;", codepoints: Codepoints::Single(8500), characters: "ℴ" },
    Entity { entity: "&Oslash;", codepoints: Codepoints::Single(216), characters: "Ø" },
    Entity { entity: "&Oslash", codepoints: Codepoints::Single(216), characters: "Ø" },
    Entity { entity: "&oslash;", codepoints: Codepoints::Single(248), characters: "ø" },
    Entity { entity: "&oslash", codepoints: Codepoints::Single(248), characters: "ø" },
    Entity { entity: "&osol;", codepoints: Codepoints::Single(8856), characters: "⊘" },
    Entity { entity: "&Otilde;", codepoints: Codepoints::Single(213), characters: "Õ" },
    Entity { entity: "&Otilde", codepoints: Codepoints::Single(213), characters: "Õ" },
    Entity { entity: "&otilde;", codepoints: Codepoints::Single(245), characters: "õ" },
    Entity { entity: "&otilde", codepoints: Codepoints::Single(245), characters: "õ" },
    Entity { entity: "&Otimes;", codepoints: Codepoints::Single(10807), characters: "⨷" },
    Entity { entity: "&otimes;", codepoints: Codepoints::Single(8855), characters: "⊗" },
    Entity { entity: "&otimesas;", codepoints: Codepoints::Single(10806), characters: "⨶" },
    Entity { entity: "&Ouml;", codepoints: Codepoints::Single(214), characters: "Ö" },
    Entity { entity: "&Ouml", codepoints: Codepoints::Single(214), characters: "Ö" },
    Entity { entity: "&ouml;", codepoints: Codepoints::Single(246), characters: "ö" },
    Entity { entity: "&ouml", codepoints: Codepoints::Single(246), characters: "ö" },
    Entity { entity: "&ovbar;", codepoints: Codepoints::Single(9021), characters: "⌽" },
    Entity { entity: "&OverBar;", codepoints: Codepoints::Single(8254), characters: "‾" },
    Entity { entity: "&OverBrace;", codepoints: Codepoints::Single(9182), characters: "⏞" },
    Entity { entity: "&OverBracket;", codepoints: Codepoints::Single(9140), characters: "⎴" },
    Entity { entity: "&OverParenthesis;", codepoints: Codepoints::Single(9180), characters: "⏜" },
    Entity { entity: "&par;", codepoints: Codepoints::Single(8741), characters: "∥" },
    Entity { entity: "&para;", codepoints: Codepoints::Single(182), characters: "¶" },
    Entity { entity: "&para", codepoints: Codepoints::Single(182), characters: "¶" },
    Entity { entity: "&parallel;", codepoints: Codepoints::Single(8741), characters: "∥" },
    Entity { entity: "&parsim;", codepoints: Codepoints::Single(10995), characters: "⫳" },
    Entity { entity: "&parsl;", codepoints: Codepoints::Single(11005), characters: "⫽" },
    Entity { entity: "&part;", codepoints: Codepoints::Single(8706), characters: "∂" },
    Entity { entity: "&PartialD;", codepoints: Codepoints::Single(8706), characters: "∂" },
    Entity { entity: "&Pcy;", codepoints: Codepoints::Single(1055), characters: "П" },
    Entity { entity: "&pcy;", codepoints: Codepoints::Single(1087), characters: "п" },
    Entity { entity: "&percnt;", codepoints: Codepoints::Single(37), characters: "%" },
    Entity { entity: "&period;", codepoints: Codepoints::Single(46), characters: "." },
    Entity { entity: "&permil;", codepoints: Codepoints::Single(8240), characters: "‰" },
    Entity { entity: "&perp;", codepoints: Codepoints::Single(8869), characters: "⊥" },
    Entity { entity: "&pertenk;", codepoints: Codepoints::Single(8241), characters: "‱" },
    Entity { entity: "&Pfr;", codepoints: Codepoints::Single(120083), characters: "𝔓" },
    Entity { entity: "&pfr;", codepoints: Codepoints::Single(120109), characters: "𝔭" },
    Entity { entity: "&Phi;", codepoints: Codepoints::Single(934), characters: "Φ" },
    Entity { entity: "&phi;", codepoints: Codepoints::Single(966), characters: "φ" },
    Entity { entity: "&phiv;", codepoints: Codepoints::Single(981), characters: "ϕ" },
    Entity { entity: "&phmmat;", codepoints: Codepoints::Single(8499), characters: "ℳ" },
    Entity { entity: "&phone;", codepoints: Codepoints::Single(9742), characters: "☎" },
    Entity { entity: "&Pi;", codepoints: Codepoints::Single(928), characters: "Π" },
    Entity { entity: "&pi;", codepoints: Codepoints::Single(960), characters: "π" },
    Entity { entity: "&pitchfork;", codepoints: Codepoints::Single(8916), characters: "⋔" },
    Entity { entity: "&piv;", codepoints: Codepoints::Single(982), characters: "ϖ" },
    Entity { entity: "&planck;", codepoints: Codepoints::Single(8463), characters: "ℏ" },
    Entity { entity: "&planckh;", codepoints: Codepoints::Single(8462), characters: "ℎ" },
    Entity { entity: "&plankv;", codepoints: Codepoints::Single(8463), characters: "ℏ" },
    Entity { entity: "&plus;", codepoints: Codepoints::Single(43), characters: "+" },
    Entity { entity: "&plusacir;", codepoints: Codepoints::Single(10787), characters: "⨣" },
    Entity { entity: "&plusb;", codepoints: Codepoints::Single(8862), characters: "⊞" },
    Entity { entity: "&pluscir;", codepoints: Codepoints::Single(10786), characters: "⨢" },
    Entity { entity: "&plusdo;", codepoints: Codepoints::Single(8724), characters: "∔" },
    Entity { entity: "&plusdu;", codepoints: Codepoints::Single(10789), characters: "⨥" },
    Entity { entity: "&pluse;", codepoints: Codepoints::Single(10866), characters: "⩲" },
    Entity { entity: "&PlusMinus;", codepoints: Codepoints::Single(177), characters: "±" },
    Entity { entity: "&plusmn;", codepoints: Codepoints::Single(177), characters: "±" },
    Entity { entity: "&plusmn", codepoints: Codepoints::Single(177), characters: "±" },
    Entity { entity: "&plussim;", codepoints: Codepoints::Single(10790), characters: "⨦" },
    Entity { entity: "&plustwo;", codepoints: Codepoints::Single(10791), characters: "⨧" },
    Entity { entity: "&pm;", codepoints: Codepoints::Single(177), characters: "±" },
    Entity { entity: "&Poincareplane;", codepoints: Codepoints::Single(8460), characters: "ℌ" },
    Entity { entity: "&pointint;", codepoints: Codepoints::Single(10773), characters: "⨕" },
    Entity { entity: "&Popf;", codepoints: Codepoints::Single(8473), characters: "ℙ" },
    Entity { entity: "&popf;", codepoints: Codepoints::Single(120161), characters: "𝕡" },
    Entity { entity: "&pound;", codepoints: Codepoints::Single(163), characters: "£" },
    Entity { entity: "&pound", codepoints: Codepoints::Single(163), characters: "£" },
    Entity { entity: "&Pr;", codepoints: Codepoints::Single(10939), characters: "⪻" },
    Entity { entity: "&pr;", codepoints: Codepoints::Single(8826), characters: "≺" },
    Entity { entity: "&prap;", codepoints: Codepoints::Single(10935), characters: "⪷" },
    Entity { entity: "&prcue;", codepoints: Codepoints::Single(8828), characters: "≼" },
    Entity { entity: "&prE;", codepoints: Codepoints::Single(10931), characters: "⪳" },
    Entity { entity: "&pre;", codepoints: Codepoints::Single(10927), characters: "⪯" },
    Entity { entity: "&prec;", codepoints: Codepoints::Single(8826), characters: "≺" },
    Entity { entity: "&precapprox;", codepoints: Codepoints::Single(10935), characters: "⪷" },
    Entity { entity: "&preccurlyeq;", codepoints: Codepoints::Single(8828), characters: "≼" },
    Entity { entity: "&Precedes;", codepoints: Codepoints::Single(8826), characters: "≺" },
    Entity { entity: "&PrecedesEqual;", codepoints: Codepoints::Single(10927), characters: "⪯" },
    Entity { entity: "&PrecedesSlantEqual;", codepoints: Codepoints::Single(8828), characters: "≼" },
    Entity { entity: "&PrecedesTilde;", codepoints: Codepoints::Single(8830), characters: "≾" },
    Entity { entity: "&preceq;", codepoints: Codepoints::Single(10927), characters: "⪯" },
    Entity { entity: "&precnapprox;", codepoints: Codepoints::Single(10937), characters: "⪹" },
    Entity { entity: "&precneqq;", codepoints: Codepoints::Single(10933), characters: "⪵" },
    Entity { entity: "&precnsim;", codepoints: Codepoints::Single(8936), characters: "⋨" },
    Entity { entity: "&precsim;", codepoints: Codepoints::Single(8830), characters: "≾" },
    Entity { entity: "&Prime;", codepoints: Codepoints::Single(8243), characters: "″" },
    Entity { entity: "&prime;", codepoints: Codepoints::Single(8242), characters: "′" },
    Entity { entity: "&primes;", codepoints: Codepoints::Single(8473), characters: "ℙ" },
    Entity { entity: "&prnap;", codepoints: Codepoints::Single(10937), characters: "⪹" },
    Entity { entity: "&prnE;", codepoints: Codepoints::Single(10933), characters: "⪵" },
    Entity { entity: "&prnsim;", codepoints: Codepoints::Single(8936), characters: "⋨" },
    Entity { entity: "&prod;", codepoints: Codepoints::Single(8719), characters: "∏" },
    Entity { entity: "&Product;", codepoints: Codepoints::Single(8719), characters: "∏" },
    Entity { entity: "&profalar;", codepoints: Codepoints::Single(9006), characters: "⌮" },
    Entity { entity: "&profline;", codepoints: Codepoints::Single(8978), characters: "⌒" },
    Entity { entity: "&profsurf;", codepoints: Codepoints::Single(8979), characters: "⌓" },
    Entity { entity: "&prop;", codepoints: Codepoints::Single(8733), characters: "∝" },
    Entity { entity: "&Proportion;", codepoints: Codepoints::Single(8759), characters: "∷" },
    Entity { entity: "&Proportional;", codepoints: Codepoints::Single(8733), characters: "∝" },
    Entity { entity: "&propto;", codepoints: Codepoints::Single(8733), characters: "∝" },
    Entity { entity: "&prsim;", codepoints: Codepoints::Single(8830), characters: "≾" },
    Entity { entity: "&prurel;", codepoints: Codepoints::Single(8880), characters: "⊰" },
    Entity { entity: "&Pscr;", codepoints: Codepoints::Single(119979), characters: "𝒫" },
    Entity { entity: "&pscr;", codepoints: Codepoints::Single(120005), characters: "𝓅" },
    Entity { entity: "&Psi;", codepoints: Codepoints::Single(936), characters: "Ψ" },
    Entity { entity: "&psi;", codepoints: Codepoints::Single(968), characters: "ψ" },
    Entity { entity: "&puncsp;", codepoints: Codepoints::Single(8200), characters: " " },
    Entity { entity: "&Qfr;", codepoints: Codepoints::Single(120084), characters: "𝔔" },
    Entity { entity: "&qfr;", codepoints: Codepoints::Single(120110), characters: "𝔮" },
    Entity { entity: "&qint;", codepoints: Codepoints::Single(10764), characters: "⨌" },
    Entity { entity: "&Qopf;", codepoints: Codepoints::Single(8474), characters: "ℚ" },
    Entity { entity: "&qopf;", codepoints: Codepoints::Single(120162), characters: "𝕢" },
    Entity { entity: "&qprime;", codepoints: Codepoints::Single(8279), characters: "⁗" },
    Entity { entity: "&Qscr;", codepoints: Codepoints::Single(119980), characters: "𝒬" },
    Entity { entity: "&qscr;", codepoints: Codepoints::Single(120006), characters: "𝓆" },
    Entity { entity: "&quaternions;", codepoints: Codepoints::Single(8461), characters: "ℍ" },
    Entity { entity: "&quatint;", codepoints: Codepoints::Single(10774), characters: "⨖" },
    Entity { entity: "&quest;", codepoints: Codepoints::Single(63), characters: "?" },
    Entity { entity: "&questeq;", codepoints: Codepoints::Single(8799), characters: "≟" },
    Entity { entity: "&QUOT;", codepoints: Codepoints::Single(34), characters: "\"" },
    Entity { entity: "&QUOT", codepoints: Codepoints::Single(34), characters: "\"" },
    Entity { entity: "&quot;", codepoints: Codepoints::Single(34), characters: "\"" },
    Entity { entity: "&quot", codepoints: Codepoints::Single(34), characters: "\"" },
    Entity { entity: "&rAarr;", codepoints: Codepoints::Single(8667), characters: "⇛" },
    Entity { entity: "&race;", codepoints: Codepoints::Double(8765, 817), characters: "∽̱" },
    Entity { entity: "&Racute;", codepoints: Codepoints::Single(340), characters: "Ŕ" },
    Entity { entity: "&racute;", codepoints: Codepoints::Single(341), characters: "ŕ" },
    Entity { entity: "&radic;", codepoints: Codepoints::Single(8730), characters: "√" },
    Entity { entity: "&raemptyv;", codepoints: Codepoints::Single(10675), characters: "⦳" },
    Entity { entity: "&Rang;", codepoints: Codepoints::Single(10219), characters: "⟫" },
    Entity { entity: "&rang;", codepoints: Codepoints::Single(10217), characters: "⟩" },
    Entity { entity: "&rangd;", codepoints: Codepoints::Single(10642), characters: "⦒" },
    Entity { entity: "&range;", codepoints: Codepoints::Single(10661), characters: "⦥" },
    Entity { entity: "&rangle;", codepoints: Codepoints::Single(10217), characters: "⟩" },
    Entity { entity: "&raquo;", codepoints: Codepoints::Single(187), characters: "»" },
    Entity { entity: "&raquo", codepoints: Codepoints::Single(187), characters: "»" },
    Entity { entity: "&Rarr;", codepoints: Codepoints::Single(8608), characters: "↠" },
    Entity { entity: "&rArr;", codepoints: Codepoints::Single(8658), characters: "⇒" },
    Entity { entity: "&rarr;", codepoints: Codepoints::Single(8594), characters: "→" },
    Entity { entity: "&rarrap;", codepoints: Codepoints::Single(10613), characters: "⥵" },
    Entity { entity: "&rarrb;", codepoints: Codepoints::Single(8677), characters: "⇥" },
    Entity { entity: "&rarrbfs;", codepoints: Codepoints::Single(10528), characters: "⤠" },
    Entity { entity: "&rarrc;", codepoints: Codepoints::Single(10547), characters: "⤳" },
    Entity { entity: "&rarrfs;", codepoints: Codepoints::Single(10526), characters: "⤞" },
    Entity { entity: "&rarrhk;", codepoints: Codepoints::Single(8618), characters: "↪" },
    Entity { entity: "&rarrlp;", codepoints: Codepoints::Single(8620), characters: "↬" },
    Entity { entity: "&rarrpl;", codepoints: Codepoints::Single(10565), characters: "⥅" },
    Entity { entity: "&rarrsim;", codepoints: Codepoints::Single(10612), characters: "⥴" },
    Entity { entity: "&Rarrtl;", codepoints: Codepoints::Single(10518), characters: "⤖" },
    Entity { entity: "&rarrtl;", codepoints: Codepoints::Single(8611), characters: "↣" },
    Entity { entity: "&rarrw;", codepoints: Codepoints::Single(8605), characters: "↝" },
    Entity { entity: "&rAtail;", codepoints: Codepoints::Single(10524), characters: "⤜" },
    Entity { entity: "&ratail;", codepoints: Codepoints::Single(10522), characters: "⤚" },
    Entity { entity: "&ratio;", codepoints: Codepoints::Single(8758), characters: "∶" },
    Entity { entity: "&rationals;", codepoints: Codepoints::Single(8474), characters: "ℚ" },
    Entity { entity: "&RBarr;", codepoints: Codepoints::Single(10512), characters: "⤐" },
    Entity { entity: "&rBarr;", codepoints: Codepoints::Single(10511), characters: "⤏" },
    Entity { entity: "&rbarr;", codepoints: Codepoints::Single(10509), characters: "⤍" },
    Entity { entity: "&rbbrk;", codepoints: Codepoints::Single(10099), characters: "❳" },
    Entity { entity: "&rbrace;", codepoints: Codepoints::Single(125), characters: "}" },
    Entity { entity: "&rbrack;", codepoints: Codepoints::Single(93), characters: "]" },
    Entity { entity: "&rbrke;", codepoints: Codepoints::Single(10636), characters: "⦌" },
    Entity { entity: "&rbrksld;", codepoints: Codepoints::Single(10638), characters: "⦎" },
    Entity { entity: "&rbrkslu;", codepoints: Codepoints::Single(10640), characters: "⦐" },
    Entity { entity: "&Rcaron;", codepoints: Codepoints::Single(344), characters: "Ř" },
    Entity { entity: "&rcaron;", codepoints: Codepoints::Single(345), characters: "ř" },
    Entity { entity: "&Rcedil;", codepoints: Codepoints::Single(342), characters: "Ŗ" },
    Entity { entity: "&rcedil;", codepoints: Codepoints::Single(343), characters: "ŗ" },
    Entity { entity: "&rceil;", codepoints: Codepoints::Single(8969), characters: "⌉" },
    Entity { entity: "&rcub;", codepoints: Codepoints::Single(125), characters: "}" },
    Entity { entity: "&Rcy;", codepoints: Codepoints::Single(1056), characters: "Р" },
    Entity { entity: "&rcy;", codepoints: Codepoints::Single(1088), characters: "р" },
    Entity { entity: "&rdca;", codepoints: Codepoints::Single(10551), characters: "⤷" },
    Entity { entity: "&rdldhar;", codepoints: Codepoints::Single(10601), characters: "⥩" },
    Entity { entity: "&rdquo;", codepoints: Codepoints::Single(8221), characters: "”" },
    Entity { entity: "&rdquor;", codepoints: Codepoints::Single(8221), characters: "”" },
    Entity { entity: "&rdsh;", codepoints: Codepoints::Single(8627), characters: "↳" },
    Entity { entity: "&Re;", codepoints: Codepoints::Single(8476), characters: "ℜ" },
    Entity { entity: "&real;", codepoints: Codepoints::Single(8476), characters: "ℜ" },
    Entity { entity: "&realine;", codepoints: Codepoints::Single(8475), characters: "ℛ" },
    Entity { entity: "&realpart;", codepoints: Codepoints::Single(8476), characters: "ℜ" },
    Entity { entity: "&reals;", codepoints: Codepoints::Single(8477), characters: "ℝ" },
    Entity { entity: "&rect;", codepoints: Codepoints::Single(9645), characters: "▭" },
    Entity { entity: "&REG;", codepoints: Codepoints::Single(174), characters: "®" },
    Entity { entity: "&REG", codepoints: Codepoints::Single(174), characters: "®" },
    Entity { entity: "&reg;", codepoints: Codepoints::Single(174), characters: "®" },
    Entity { entity: "&reg", codepoints: Codepoints::Single(174), characters: "®" },
    Entity { entity: "&ReverseElement;", codepoints: Codepoints::Single(8715), characters: "∋" },
    Entity { entity: "&ReverseEquilibrium;", codepoints: Codepoints::Single(8651), characters: "⇋" },
    Entity { entity: "&ReverseUpEquilibrium;", codepoints: Codepoints::Single(10607), characters: "⥯" },
    Entity { entity: "&rfisht;", codepoints: Codepoints::Single(10621), characters: "⥽" },
    Entity { entity: "&rfloor;", codepoints: Codepoints::Single(8971), characters: "⌋" },
    Entity { entity: "&Rfr;", codepoints: Codepoints::Single(8476), characters: "ℜ" },
    Entity { entity: "&rfr;", codepoints: Codepoints::Single(120111), characters: "𝔯" },
    Entity { entity: "&rHar;", codepoints: Codepoints::Single(10596), characters: "⥤" },
    Entity { entity: "&rhard;", codepoints: Codepoints::Single(8641), characters: "⇁" },
    Entity { entity: "&rharu;", codepoints: Codepoints::Single(8640), characters: "⇀" },
    Entity { entity: "&rharul;", codepoints: Codepoints::Single(10604), characters: "⥬" },
    Entity { entity: "&Rho;", codepoints: Codepoints::Single(929), characters: "Ρ" },
    Entity { entity: "&rho;", codepoints: Codepoints::Single(961), characters: "ρ" },
    Entity { entity: "&rhov;", codepoints: Codepoints::Single(1009), characters: "ϱ" },
    Entity { entity: "&RightAngleBracket;", codepoints: Codepoints::Single(10217), characters: "⟩" },
    Entity { entity: "&RightArrow;", codepoints: Codepoints::Single(8594), characters: "→" },
    Entity { entity: "&Rightarrow;", codepoints: Codepoints::Single(8658), characters: "⇒" },
    Entity { entity: "&rightarrow;", codepoints: Codepoints::Single(8594), characters: "→" },
    Entity { entity: "&RightArrowBar;", codepoints: Codepoints::Single(8677), characters: "⇥" },
    Entity { entity: "&RightArrowLeftArrow;", codepoints: Codepoints::Single(8644), characters: "⇄" },
    Entity { entity: "&rightarrowtail;", codepoints: Codepoints::Single(8611), characters: "↣" },
    Entity { entity: "&RightCeiling;", codepoints: Codepoints::Single(8969), characters: "⌉" },
    Entity { entity: "&RightDoubleBracket;", codepoints: Codepoints::Single(10215), characters: "⟧" },
    Entity { entity: "&RightDownTeeVector;", codepoints: Codepoints::Single(10589), characters: "⥝" },
    Entity { entity: "&RightDownVector;", codepoints: Codepoints::Single(8642), characters: "⇂" },
    Entity { entity: "&RightDownVectorBar;", codepoints: Codepoints::Single(10581), characters: "⥕" },
    Entity { entity: "&RightFloor;", codepoints: Codepoints::Single(8971), characters: "⌋" },
    Entity { entity: "&rightharpoondown;", codepoints: Codepoints::Single(8641), characters: "⇁" },
    Entity { entity: "&rightharpoonup;", codepoints: Codepoints::Single(8640), characters: "⇀" },
    Entity { entity: "&rightleftarrows;", codepoints: Codepoints::Single(8644), characters: "⇄" },
    Entity { entity: "&rightleftharpoons;", codepoints: Codepoints::Single(8652), characters: "⇌" },
    Entity { entity: "&rightrightarrows;", codepoints: Codepoints::Single(8649), characters: "⇉" },
    Entity { entity: "&rightsquigarrow;", codepoints: Codepoints::Single(8605), characters: "↝" },
    Entity { entity: "&RightTee;", codepoints: Codepoints::Single(8866), characters: "⊢" },
    Entity { entity: "&RightTeeArrow;", codepoints: Codepoints::Single(8614), characters: "↦" },
    Entity { entity: "&RightTeeVector;", codepoints: Codepoints::Single(10587), characters: "⥛" },
    Entity { entity: "&rightthreetimes;", codepoints: Codepoints::Single(8908), characters: "⋌" },
    Entity { entity: "&RightTriangle;", codepoints: Codepoints::Single(8883), characters: "⊳" },
    Entity { entity: "&RightTriangleBar;", codepoints: Codepoints::Single(10704), characters: "⧐" },
    Entity { entity: "&RightTriangleEqual;", codepoints: Codepoints::Single(8885), characters: "⊵" },
    Entity { entity: "&RightUpDownVector;", codepoints: Codepoints::Single(10575), characters: "⥏" },
    Entity { entity: "&RightUpTeeVector;", codepoints: Codepoints::Single(10588), characters: "⥜" },
    Entity { entity: "&RightUpVector;", codepoints: Codepoints::Single(8638), characters: "↾" },
    Entity { entity: "&RightUpVectorBar;", codepoints: Codepoints::Single(10580), characters: "⥔" },
    Entity { entity: "&RightVector;", codepoints: Codepoints::Single(8640), characters: "⇀" },
    Entity { entity: "&RightVectorBar;", codepoints: Codepoints::Single(10579), characters: "⥓" },
    Entity { entity: "&ring;", codepoints: Codepoints::Single(730), characters: "˚" },
    Entity { entity: "&risingdotseq;", codepoints: Codepoints::Single(8787), characters: "≓" },
    Entity { entity: "&rlarr;", codepoints: Codepoints::Single(8644), characters: "⇄" },
    Entity { entity: "&rlhar;", codepoints: Codepoints::Single(8652), characters: "⇌" },
    Entity { entity: "&rlm;", codepoints: Codepoints::Single(8207), characters: "‏" },
    Entity { entity: "&rmoust;", codepoints: Codepoints::Single(9137), characters: "⎱" },
    Entity { entity: "&rmoustache;", codepoints: Codepoints::Single(9137), characters: "⎱" },
    Entity { entity: "&rnmid;", codepoints: Codepoints::Single(10990), characters: "⫮" },
    Entity { entity: "&roang;", codepoints: Codepoints::Single(10221), characters: "⟭" },
    Entity { entity: "&roarr;", codepoints: Codepoints::Single(8702), characters: "⇾" },
    Entity { entity: "&robrk;", codepoints: Codepoints::Single(10215), characters: "⟧" },
    Entity { entity: "&ropar;", codepoints: Codepoints::Single(10630), characters: "⦆" },
    Entity { entity: "&Ropf;", codepoints: Codepoints::Single(8477), characters: "ℝ" },
    Entity { entity: "&ropf;", codepoints: Codepoints::Single(120163), characters: "𝕣" },
    Entity { entity: "&roplus;", codepoints: Codepoints::Single(10798), characters: "⨮" },
    Entity { entity: "&rotimes;", codepoints: Codepoints::Single(10805), characters: "⨵" },
    Entity { entity: "&RoundImplies;", codepoints: Codepoints::Single(10608), characters: "⥰" },
    Entity { entity: "&rpar;", codepoints: Codepoints::Single(41), characters: ")" },
    Entity { entity: "&rpargt;", codepoints: Codepoints::Single(10644), characters: "⦔" },
    Entity { entity: "&rppolint;", codepoints: Codepoints::Single(10770), characters: "⨒" },
    Entity { entity: "&rrarr;", codepoints: Codepoints::Single(8649), characters: "⇉" },
    Entity { entity: "&Rrightarrow;", codepoints: Codepoints::Single(8667), characters: "⇛" },
    Entity { entity: "&rsaquo;", codepoints: Codepoints::Single(8250), characters: "›" },
    Entity { entity: "&Rscr;", codepoints: Codepoints::Single(8475), characters: "ℛ" },
    Entity { entity: "&rscr;", codepoints: Codepoints::Single(120007), characters: "𝓇" },
    Entity { entity: "&Rsh;", codepoints: Codepoints::Single(8625), characters: "↱" },
    Entity { entity: "&rsh;", codepoints: Codepoints::Single(8625), characters: "↱" },
    Entity { entity: "&rsqb;", codepoints: Codepoints::Single(93), characters: "]" },
    Entity { entity: "&rsquo;", codepoints: Codepoints::Single(8217), characters: "’" },
    Entity { entity: "&rsquor;", codepoints: Codepoints::Single(8217), characters: "’" },
    Entity { entity: "&rthree;", codepoints: Codepoints::Single(8908), characters: "⋌" },
    Entity { entity: "&rtimes;", codepoints: Codepoints::Single(8906), characters: "⋊" },
    Entity { entity: "&rtri;", codepoints: Codepoints::Single(9657), characters: "▹" },
    Entity { entity: "&rtrie;", codepoints: Codepoints::Single(8885), characters: "⊵" },
    Entity { entity: "&rtrif;", codepoints: Codepoints::Single(9656), characters: "▸" },
    Entity { entity: "&rtriltri;", codepoints: Codepoints::Single(10702), characters: "⧎" },
    Entity { entity: "&RuleDelayed;", codepoints: Codepoints::Single(10740), characters: "⧴" },
    Entity { entity: "&ruluhar;", codepoints: Codepoints::Single(10600), characters: "⥨" },
    Entity { entity: "&rx;", codepoints: Codepoints::Single(8478), characters: "℞" },
    Entity { entity: "&Sacute;", codepoints: Codepoints::Single(346), characters: "Ś" },
    Entity { entity: "&sacute;", codepoints: Codepoints::Single(347), characters: "ś" },
    Entity { entity: "&sbquo;", codepoints: Codepoints::Single(8218), characters: "‚" },
    Entity { entity: "&Sc;", codepoints: Codepoints::Single(10940), characters: "⪼" },
    Entity { entity: "&sc;", codepoints: Codepoints::Single(8827), characters: "≻" },
    Entity { entity: "&scap;", codepoints: Codepoints::Single(10936), characters: "⪸" },
    Entity { entity: "&Scaron;", codepoints: Codepoints::Single(352), characters: "Š" },
    Entity { entity: "&scaron;", codepoints: Codepoints::Single(353), characters: "š" },
    Entity { entity: "&sccue;", codepoints: Codepoints::Single(8829), characters: "≽" },
    Entity { entity: "&scE;", codepoints: Codepoints::Single(10932), characters: "⪴" },
    Entity { entity: "&sce;", codepoints: Codepoints::Single(10928), characters: "⪰" },
    Entity { entity: "&Scedil;", codepoints: Codepoints::Single(350), characters: "Ş" },
    Entity { entity: "&scedil;", codepoints: Codepoints::Single(351), characters: "ş" },
    Entity { entity: "&Scirc;", codepoints: Codepoints::Single(348), characters: "Ŝ" },
    Entity { entity: "&scirc;", codepoints: Codepoints::Single(349), characters: "ŝ" },
    Entity { entity: "&scnap;", codepoints: Codepoints::Single(10938), characters: "⪺" },
    Entity { entity: "&scnE;", codepoints: Codepoints::Single(10934), characters: "⪶" },
    Entity { entity: "&scnsim;", codepoints: Codepoints::Single(8937), characters: "⋩" },
    Entity { entity: "&scpolint;", codepoints: Codepoints::Single(10771), characters: "⨓" },
    Entity { entity: "&scsim;", codepoints: Codepoints::Single(8831), characters: "≿" },
    Entity { entity: "&Scy;", codepoints: Codepoints::Single(1057), characters: "С" },
    Entity { entity: "&scy;", codepoints: Codepoints::Single(1089), characters: "с" },
    Entity { entity: "&sdot;", codepoints: Codepoints::Single(8901), characters: "⋅" },
    Entity { entity: "&sdotb;", codepoints: Codepoints::Single(8865), characters: "⊡" },
    Entity { entity: "&sdote;", codepoints: Codepoints::Single(10854), characters: "⩦" },
    Entity { entity: "&searhk;", codepoints: Codepoints::Single(10533), characters: "⤥" },
    Entity { entity: "&seArr;", codepoints: Codepoints::Single(8664), characters: "⇘" },
    Entity { entity: "&searr;", codepoints: Codepoints::Single(8600), characters: "↘" },
    Entity { entity: "&searrow;", codepoints: Codepoints::Single(8600), characters: "↘" },
    Entity { entity: "&sect;", codepoints: Codepoints::Single(167), characters: "§" },
    Entity { entity: "&sect", codepoints: Codepoints::Single(167), characters: "§" },
    Entity { entity: "&semi;", codepoints: Codepoints::Single(59), characters: ";" },
    Entity { entity: "&seswar;", codepoints: Codepoints::Single(10537), characters: "⤩" },
    Entity { entity: "&setminus;", codepoints: Codepoints::Single(8726), characters: "∖" },
    Entity { entity: "&setmn;", codepoints: Codepoints::Single(8726), characters: "∖" },
    Entity { entity: "&sext;", codepoints: Codepoints::Single(10038), characters: "✶" },
    Entity { entity: "&Sfr;", codepoints: Codepoints::Single(120086), characters: "𝔖" },
    Entity { entity: "&sfr;", codepoints: Codepoints::Single(120112), characters: "𝔰" },
    Entity { entity: "&sfrown;", codepoints: Codepoints::Single(8994), characters: "⌢" },
    Entity { entity: "&sharp;", codepoints: Codepoints::Single(9839), characters: "♯" },
    Entity { entity: "&SHCHcy;", codepoints: Codepoints::Single(1065), characters: "Щ" },
    Entity { entity: "&shchcy;", codepoints: Codepoints::Single(1097), characters: "щ" },
    Entity { entity: "&SHcy;", codepoints: Codepoints::Single(1064), characters: "Ш" },
    Entity { entity: "&shcy;", codepoints: Codepoints::Single(1096), characters: "ш" },
    Entity { entity: "&ShortDownArrow;", codepoints: Codepoints::Single(8595), characters: "↓" },
    Entity { entity: "&ShortLeftArrow;", codepoints: Codepoints::Single(8592), characters: "←" },
    Entity { entity: "&shortmid;", codepoints: Codepoints::Single(8739), characters: "∣" },
    Entity { entity: "&shortparallel;", codepoints: Codepoints::Single(8741), characters: "∥" },
    Entity { entity: "&ShortRightArrow;", codepoints: Codepoints::Single(8594), characters: "→" },
    Entity { entity: "&ShortUpArrow;", codepoints: Codepoints::Single(8593), characters: "↑" },
    Entity { entity: "&shy;", codepoints: Codepoints::Single(173), characters: "­" },
    Entity { entity: "&shy", codepoints: Codepoints::Single(173), characters: "­" },
    Entity { entity: "&Sigma;", codepoints: Codepoints::Single(931), characters: "Σ" },
    Entity { entity: "&sigma;", codepoints: Codepoints::Single(963), characters: "σ" },
    Entity { entity: "&sigmaf;", codepoints: Codepoints::Single(962), characters: "ς" },
    Entity { entity: "&sigmav;", codepoints: Codepoints::Single(962), characters: "ς" },
    Entity { entity: "&sim;", codepoints: Codepoints::Single(8764), characters: "∼" },
    Entity { entity: "&simdot;", codepoints: Codepoints::Single(10858), characters: "⩪" },
    Entity { entity: "&sime;", codepoints: Codepoints::Single(8771), characters: "≃" },
    Entity { entity: "&simeq;", codepoints: Codepoints::Single(8771), characters: "≃" },
    Entity { entity: "&simg;", codepoints: Codepoints::Single(10910), characters: "⪞" },
    Entity { entity: "&simgE;", codepoints: Codepoints::Single(10912), characters: "⪠" },
    Entity { entity: "&siml;", codepoints: Codepoints::Single(10909), characters: "⪝" },
    Entity { entity: "&simlE;", codepoints: Codepoints::Single(10911), characters: "⪟" },
    Entity { entity: "&simne;", codepoints: Codepoints::Single(8774), characters: "≆" },
    Entity { entity: "&simplus;", codepoints: Codepoints::Single(10788), characters: "⨤" },
    Entity { entity: "&simrarr;", codepoints: Codepoints::Single(10610), characters: "⥲" },
    Entity { entity: "&slarr;", codepoints: Codepoints::Single(8592), characters: "←" },
    Entity { entity: "&SmallCircle;", codepoints: Codepoints::Single(8728), characters: "∘" },
    Entity { entity: "&smallsetminus;", codepoints: Codepoints::Single(8726), characters: "∖" },
    Entity { entity: "&smashp;", codepoints: Codepoints::Single(10803), characters: "⨳" },
    Entity { entity: "&smeparsl;", codepoints: Codepoints::Single(10724), characters: "⧤" },
    Entity { entity: "&smid;", codepoints: Codepoints::Single(8739), characters: "∣" },
    Entity { entity: "&smile;", codepoints: Codepoints::Single(8995), characters: "⌣" },
    Entity { entity: "&smt;", codepoints: Codepoints::Single(10922), characters: "⪪" },
    Entity { entity: "&smte;", codepoints: Codepoints::Single(10924), characters: "⪬" },
    Entity { entity: "&smtes;", codepoints: Codepoints::Double(10924, 65024), characters: "⪬︀" },
    Entity { entity: "&SOFTcy;", codepoints: Codepoints::Single(1068), characters: "Ь" },
    Entity { entity: "&softcy;", codepoints: Codepoints::Single(1100), characters: "ь" },
    Entity { entity: "&sol;", codepoints: Codepoints::Single(47), characters: "/" },
    Entity { entity: "&solb;", codepoints: Codepoints::Single(10692), characters: "⧄" },
    Entity { entity: "&solbar;", codepoints: Codepoints::Single(9023), characters: "⌿" },
    Entity { entity: "&Sopf;", codepoints: Codepoints::Single(120138), characters: "𝕊" },
    Entity { entity: "&sopf;", codepoints: Codepoints::Single(120164), characters: "𝕤" },
    Entity { entity: "&spades;", codepoints: Codepoints::Single(9824), characters: "♠" },
    Entity { entity: "&spadesuit;", codepoints: Codepoints::Single(9824), characters: "♠" },
    Entity { entity: "&spar;", codepoints: Codepoints::Single(8741), characters: "∥" },
    Entity { entity: "&sqcap;", codepoints: Codepoints::Single(8851), characters: "⊓" },
    Entity { entity: "&sqcaps;", codepoints: Codepoints::Double(8851, 65024), characters: "⊓︀" },
    Entity { entity: "&sqcup;", codepoints: Codepoints::Single(8852), characters: "⊔" },
    Entity { entity: "&sqcups;", codepoints: Codepoints::Double(8852, 65024), characters: "⊔︀" },
    Entity { entity: "&Sqrt;", codepoints: Codepoints::Single(8730), characters: "√" },
    Entity { entity: "&sqsub;", codepoints: Codepoints::Single(8847), characters: "⊏" },
    Entity { entity: "&sqsube;", codepoints: Codepoints::Single(8849), characters: "⊑" },
    Entity { entity: "&sqsubset;", codepoints: Codepoints::Single(8847), characters: "⊏" },
    Entity { entity: "&sqsubseteq;", codepoints: Codepoints::Single(8849), characters: "⊑" },
    Entity { entity: "&sqsup;", codepoints: Codepoints::Single(8848), characters: "⊐" },
    Entity { entity: "&sqsupe;", codepoints: Codepoints::Single(8850), characters: "⊒" },
    Entity { entity: "&sqsupset;", codepoints: Codepoints::Single(8848), characters: "⊐" },
    Entity { entity: "&sqsupseteq;", codepoints: Codepoints::Single(8850), characters: "⊒" },
    Entity { entity: "&squ;", codepoints: Codepoints::Single(9633), characters: "□" },
    Entity { entity: "&Square;", codepoints: Codepoints::Single(9633), characters: "□" },
    Entity { entity: "&square;", codepoints: Codepoints::Single(9633), characters: "□" },
    Entity { entity: "&SquareIntersection;", codepoints: Codepoints::Single(8851), characters: "⊓" },
    Entity { entity: "&SquareSubset;", codepoints: Codepoints::Single(8847), characters: "⊏" },
    Entity { entity: "&SquareSubsetEqual;", codepoints: Codepoints::Single(8849), characters: "⊑" },
    Entity { entity: "&SquareSuperset;", codepoints: Codepoints::Single(8848), characters: "⊐" },
    Entity { entity: "&SquareSupersetEqual;", codepoints: Codepoints::Single(8850), characters: "⊒" },
    Entity { entity: "&SquareUnion;", codepoints: Codepoints::Single(8852), characters: "⊔" },
    Entity { entity: "&squarf;", codepoints: Codepoints::Single(9642), characters: "▪" },
    Entity { entity: "&squf;", codepoints: Codepoints::Single(9642), characters: "▪" },
    Entity { entity: "&srarr;", codepoints: Codepoints::Single(8594), characters: "→" },
    Entity { entity: "&Sscr;", codepoints: Codepoints::Single(119982), characters: "𝒮" },
    Entity { entity: "&sscr;", codepoints: Codepoints::Single(120008), characters: "𝓈" },
    Entity { entity: "&ssetmn;", codepoints: Codepoints::Single(8726), characters: "∖" },
    Entity { entity: "&ssmile;", codepoints: Codepoints::Single(8995), characters: "⌣" },
    Entity { entity: "&sstarf;", codepoints: Codepoints::Single(8902), characters: "⋆" },
    Entity { entity: "&Star;", codepoints: Codepoints::Single(8902), characters: "⋆" },
    Entity { entity: "&star;", codepoints: Codepoints::Single(9734), characters: "☆" },
    Entity { entity: "&starf;", codepoints: Codepoints::Single(9733), characters: "★" },
    Entity { entity: "&straightepsilon;", codepoints: Codepoints::Single(1013), characters: "ϵ" },
    Entity { entity: "&straightphi;", codepoints: Codepoints::Single(981), characters: "ϕ" },
    Entity { entity: "&strns;", codepoints: Codepoints::Single(175), characters: "¯" },
    Entity { entity: "&Sub;", codepoints: Codepoints::Single(8912), characters: "⋐" },
    Entity { entity: "&sub;", codepoints: Codepoints::Single(8834), characters: "⊂" },
    Entity { entity: "&subdot;", codepoints: Codepoints::Single(10941), characters: "⪽" },
    Entity { entity: "&subE;", codepoints: Codepoints::Single(10949), characters: "⫅" },
    Entity { entity: "&sube;", codepoints: Codepoints::Single(8838), characters: "⊆" },
    Entity { entity: "&subedot;", codepoints: Codepoints::Single(10947), characters: "⫃" },
    Entity { entity: "&submult;", codepoints: Codepoints::Single(10945), characters: "⫁" },
    Entity { entity: "&subnE;", codepoints: Codepoints::Single(10955), characters: "⫋" },
    Entity { entity: "&subne;", codepoints: Codepoints::Single(8842), characters: "⊊" },
    Entity { entity: "&subplus;", codepoints: Codepoints::Single(10943), characters: "⪿" },
    Entity { entity: "&subrarr;", codepoints: Codepoints::Single(10617), characters: "⥹" },
    Entity { entity: "&Subset;", codepoints: Codepoints::Single(8912), characters: "⋐" },
    Entity { entity: "&subset;", codepoints: Codepoints::Single(8834), characters: "⊂" },
    Entity { entity: "&subseteq;", codepoints: Codepoints::Single(8838), characters: "⊆" },
    Entity { entity: "&subseteqq;", codepoints: Codepoints::Single(10949), characters: "⫅" },
    Entity { entity: "&SubsetEqual;", codepoints: Codepoints::Single(8838), characters: "⊆" },
    Entity { entity: "&subsetneq;", codepoints: Codepoints::Single(8842), characters: "⊊" },
    Entity { entity: "&subsetneqq;", codepoints: Codepoints::Single(10955), characters: "⫋" },
    Entity { entity: "&subsim;", codepoints: Codepoints::Single(10951), characters: "⫇" },
    Entity { entity: "&subsub;", codepoints: Codepoints::Single(10965), characters: "⫕" },
    Entity { entity: "&subsup;", codepoints: Codepoints::Single(10963), characters: "⫓" },
    Entity { entity: "&succ;", codepoints: Codepoints::Single(8827), characters: "≻" },
    Entity { entity: "&succapprox;", codepoints: Codepoints::Single(10936), characters: "⪸" },
    Entity { entity: "&succcurlyeq;", codepoints: Codepoints::Single(8829), characters: "≽" },
    Entity { entity: "&Succeeds;", codepoints: Codepoints::Single(8827), characters: "≻" },
    Entity { entity: "&SucceedsEqual;", codepoints: Codepoints::Single(10928), characters: "⪰" },
    Entity { entity: "&SucceedsSlantEqual;", codepoints: Codepoints::Single(8829), characters: "≽" },
    Entity { entity: "&SucceedsTilde;", codepoints: Codepoints::Single(8831), characters: "≿" },
    Entity { entity: "&succeq;", codepoints: Codepoints::Single(10928), characters: "⪰" },
    Entity { entity: "&succnapprox;", codepoints: Codepoints::Single(10938), characters: "⪺" },
    Entity { entity: "&succneqq;", codepoints: Codepoints::Single(10934), characters: "⪶" },
    Entity { entity: "&succnsim;", codepoints: Codepoints::Single(8937), characters: "⋩" },
    Entity { entity: "&succsim;", codepoints: Codepoints::Single(8831), characters: "≿" },
    Entity { entity: "&SuchThat;", codepoints: Codepoints::Single(8715), characters: "∋" },
    Entity { entity: "&Sum;", codepoints: Codepoints::Single(8721), characters: "∑" },
    Entity { entity: "&sum;", codepoints: Codepoints::Single(8721), characters: "∑" },
    Entity { entity: "&sung;", codepoints: Codepoints::Single(9834), characters: "♪" },
    Entity { entity: "&Sup;", codepoints: Codepoints::Single(8913), characters: "⋑" },
    Entity { entity: "&sup;", codepoints: Codepoints::Single(8835), characters: "⊃" },
    Entity { entity: "&sup1;", codepoints: Codepoints::Single(185), characters: "¹" },
    Entity { entity: "&sup1", codepoints: Codepoints::Single(185), characters: "¹" },
    Entity { entity: "&sup2;", codepoints: Codepoints::Single(178), characters: "²" },
    Entity { entity: "&sup2", codepoints: Codepoints::Single(178), characters: "²" },
    Entity { entity: "&sup3;", codepoints: Codepoints::Single(179), characters: "³" },
    Entity { entity: "&sup3", codepoints: Codepoints::Single(179), characters: "³" },
    Entity { entity: "&supdot;", codepoints: Codepoints::Single(10942), characters: "⪾" },
    Entity { entity: "&supdsub;", codepoints: Codepoints::Single(10968), characters: "⫘" },
    Entity { entity: "&supE;", codepoints: Codepoints::Single(10950), characters: "⫆" },
    Entity { entity: "&supe;", codepoints: Codepoints::Single(8839), characters: "⊇" },
    Entity { entity: "&supedot;", codepoints: Codepoints::Single(10948), characters: "⫄" },
    Entity { entity: "&Superset;", codepoints: Codepoints::Single(8835), characters: "⊃" },
    Entity { entity: "&SupersetEqual;", codepoints: Codepoints::Single(8839), characters: "⊇" },
    Entity { entity: "&suphsol;", codepoints: Codepoints::Single(10185), characters: "⟉" },
    Entity { entity: "&suphsub;", codepoints: Codepoints::Single(10967), characters: "⫗" },
    Entity { entity: "&suplarr;", codepoints: Codepoints::Single(10619), characters: "⥻" },
    Entity { entity: "&supmult;", codepoints: Codepoints::Single(10946), characters: "⫂" },
    Entity { entity: "&supnE;", codepoints: Codepoints::Single(10956), characters: "⫌" },
    Entity { entity: "&supne;", codepoints: Codepoints::Single(8843), characters: "⊋" },
    Entity { entity: "&supplus;", codepoints: Codepoints::Single(10944), characters: "⫀" },
    Entity { entity: "&Supset;", codepoints: Codepoints::Single(8913), characters: "⋑" },
    Entity { entity: "&supset;", codepoints: Codepoints::Single(8835), characters: "⊃" },
    Entity { entity: "&supseteq;", codepoints: Codepoints::Single(8839), characters: "⊇" },
    Entity { entity: "&supseteqq;", codepoints: Codepoints::Single(10950), characters: "⫆" },
    Entity { entity: "&supsetneq;", codepoints: Codepoints::Single(8843), characters: "⊋" },
    Entity { entity: "&supsetneqq;", codepoints: Codepoints::Single(10956), characters: "⫌" },
    Entity { entity: "&supsim;", codepoints: Codepoints::Single(10952), characters: "⫈" },
    Entity { entity: "&supsub;", codepoints: Codepoints::Single(10964), characters: "⫔" },
    Entity { entity: "&supsup;", codepoints: Codepoints::Single(10966), characters: "⫖" },
    Entity { entity: "&swarhk;", codepoints: Codepoints::Single(10534), characters: "⤦" },
    Entity { entity: "&swArr;", codepoints: Codepoints::Single(8665), characters: "⇙" },
    Entity { entity: "&swarr;", codepoints: Codepoints::Single(8601), characters: "↙" },
    Entity { entity: "&swarrow;", codepoints: Codepoints::Single(8601), characters: "↙" },
    Entity { entity: "&swnwar;", codepoints: Codepoints::Single(10538), characters: "⤪" },
    Entity { entity: "&szlig;", codepoints: Codepoints::Single(223), characters: "ß" },
    Entity { entity: "&szlig", codepoints: Codepoints::Single(223), characters: "ß" },
    Entity { entity: "&Tab;", codepoints: Codepoints::Single(9), characters: "	" },
    Entity { entity: "&target;", codepoints: Codepoints::Single(8982), characters: "⌖" },
    Entity { entity: "&Tau;", codepoints: Codepoints::Single(932), characters: "Τ" },
    Entity { entity: "&tau;", codepoints: Codepoints::Single(964), characters: "τ" },
    Entity { entity: "&tbrk;", codepoints: Codepoints::Single(9140), characters: "⎴" },
    Entity { entity: "&Tcaron;", codepoints: Codepoints::Single(356), characters: "Ť" },
    Entity { entity: "&tcaron;", codepoints: Codepoints::Single(357), characters: "ť" },
    Entity { entity: "&Tcedil;", codepoints: Codepoints::Single(354), characters: "Ţ" },
    Entity { entity: "&tcedil;", codepoints: Codepoints::Single(355), characters: "ţ" },
    Entity { entity: "&Tcy;", codepoints: Codepoints::Single(1058), characters: "Т" },
    Entity { entity: "&tcy;", codepoints: Codepoints::Single(1090), characters: "т" },
    Entity { entity: "&tdot;", codepoints: Codepoints::Single(8411), characters: "⃛" },
    Entity { entity: "&telrec;", codepoints: Codepoints::Single(8981), characters: "⌕" },
    Entity { entity: "&Tfr;", codepoints: Codepoints::Single(120087), characters: "𝔗" },
    Entity { entity: "&tfr;", codepoints: Codepoints::Single(120113), characters: "𝔱" },
    Entity { entity: "&there4;", codepoints: Codepoints::Single(8756), characters: "∴" },
    Entity { entity: "&Therefore;", codepoints: Codepoints::Single(8756), characters: "∴" },
    Entity { entity: "&therefore;", codepoints: Codepoints::Single(8756), characters: "∴" },
    Entity { entity: "&Theta;", codepoints: Codepoints::Single(920), characters: "Θ" },
    Entity { entity: "&theta;", codepoints: Codepoints::Single(952), characters: "θ" },
    Entity { entity: "&thetasym;", codepoints: Codepoints::Single(977), characters: "ϑ" },
    Entity { entity: "&thetav;", codepoints: Codepoints::Single(977), characters: "ϑ" },
    Entity { entity: "&thickapprox;", codepoints: Codepoints::Single(8776), characters: "≈" },
    Entity { entity: "&thicksim;", codepoints: Codepoints::Single(8764), characters: "∼" },
    Entity { entity: "&ThickSpace;", codepoints: Codepoints::Double(8287, 8202), characters: "  " },
    Entity { entity: "&thinsp;", codepoints: Codepoints::Single(8201), characters: " " },
    Entity { entity: "&ThinSpace;", codepoints: Codepoints::Single(8201), characters: " " },
    Entity { entity: "&thkap;", codepoints: Codepoints::Single(8776), characters: "≈" },
    Entity { entity: "&thksim;", codepoints: Codepoints::Single(8764), characters: "∼" },
    Entity { entity: "&THORN;", codepoints: Codepoints::Single(222), characters: "Þ" },
    Entity { entity: "&THORN", codepoints: Codepoints::Single(222), characters: "Þ" },
    Entity { entity: "&thorn;", codepoints: Codepoints::Single(254), characters: "þ" },
    Entity { entity: "&thorn", codepoints: Codepoints::Single(254), characters: "þ" },
    Entity { entity: "&Tilde;", codepoints: Codepoints::Single(8764), characters: "∼" },
    Entity { entity: "&tilde;", codepoints: Codepoints::Single(732), characters: "˜" },
    Entity { entity: "&TildeEqual;", codepoints: Codepoints::Single(8771), characters: "≃" },
    Entity { entity: "&TildeFullEqual;", codepoints: Codepoints::Single(8773), characters: "≅" },
    Entity { entity: "&TildeTilde;", codepoints: Codepoints::Single(8776), characters: "≈" },
    Entity { entity: "&times;", codepoints: Codepoints::Single(215), characters: "×" },
    Entity { entity: "&times", codepoints: Codepoints::Single(215), characters: "×" },
    Entity { entity: "&timesb;", codepoints: Codepoints::Single(8864), characters: "⊠" },
    Entity { entity: "&timesbar;", codepoints: Codepoints::Single(10801), characters: "⨱" },
    Entity { entity: "&timesd;", codepoints: Codepoints::Single(10800), characters: "⨰" },
    Entity { entity: "&tint;", codepoints: Codepoints::Single(8749), characters: "∭" },
    Entity { entity: "&toea;", codepoints: Codepoints::Single(10536), characters: "⤨" },
    Entity { entity: "&top;", codepoints: Codepoints::Single(8868), characters: "⊤" },
    Entity { entity: "&topbot;", codepoints: Codepoints::Single(9014), characters: "⌶" },
    Entity { entity: "&topcir;", codepoints: Codepoints::Single(10993), characters: "⫱" },
    Entity { entity: "&Topf;", codepoints: Codepoints::Single(120139), characters: "𝕋" },
    Entity { entity: "&topf;", codepoints: Codepoints::Single(120165), characters: "𝕥" },
    Entity { entity: "&topfork;", codepoints: Codepoints::Single(10970), characters: "⫚" },
    Entity { entity: "&tosa;", codepoints: Codepoints::Single(10537), characters: "⤩" },
    Entity { entity: "&tprime;", codepoints: Codepoints::Single(8244), characters: "‴" },
    Entity { entity: "&TRADE;", codepoints: Codepoints::Single(8482), characters: "™" },
    Entity { entity: "&trade;", codepoints: Codepoints::Single(8482), characters: "™" },
    Entity { entity: "&triangle;", codepoints: Codepoints::Single(9653), characters: "▵" },
    Entity { entity: "&triangledown;", codepoints: Codepoints::Single(9663), characters: "▿" },
    Entity { entity: "&triangleleft;", codepoints: Codepoints::Single(9667), characters: "◃" },
    Entity { entity: "&trianglelefteq;", codepoints: Codepoints::Single(8884), characters: "⊴" },
    Entity { entity: "&triangleq;", codepoints: Codepoints::Single(8796), characters: "≜" },
    Entity { entity: "&triangleright;", codepoints: Codepoints::Single(9657), characters: "▹" },
    Entity { entity: "&trianglerighteq;", codepoints: Codepoints::Single(8885), characters: "⊵" },
    Entity { entity: "&tridot;", codepoints: Codepoints::Single(9708), characters: "◬" },
    Entity { entity: "&trie;", codepoints: Codepoints::Single(8796), characters: "≜" },
    Entity { entity: "&triminus;", codepoints: Codepoints::Single(10810), characters: "⨺" },
    Entity { entity: "&TripleDot;", codepoints: Codepoints::Single(8411), characters: "⃛" },
    Entity { entity: "&triplus;", codepoints: Codepoints::Single(10809), characters: "⨹" },
    Entity { entity: "&trisb;", codepoints: Codepoints::Single(10701), characters: "⧍" },
    Entity { entity: "&tritime;", codepoints: Codepoints::Single(10811), characters: "⨻" },
    Entity { entity: "&trpezium;", codepoints: Codepoints::Single(9186), characters: "⏢" },
    Entity { entity: "&Tscr;", codepoints: Codepoints::Single(119983), characters: "𝒯" },
    Entity { entity: "&tscr;", codepoints: Codepoints::Single(120009), characters: "𝓉" },
    Entity { entity: "&TScy;", codepoints: Codepoints::Single(1062), characters: "Ц" },
    Entity { entity: "&tscy;", codepoints: Codepoints::Single(1094), characters: "ц" },
    Entity { entity: "&TSHcy;", codepoints: Codepoints::Single(1035), characters: "Ћ" },
    Entity { entity: "&tshcy;", codepoints: Codepoints::Single(1115), characters: "ћ" },
    Entity { entity: "&Tstrok;", codepoints: Codepoints::Single(358), characters: "Ŧ" },
    Entity { entity: "&tstrok;", codepoints: Codepoints::Single(359), characters: "ŧ" },
    Entity { entity: "&twixt;", codepoints: Codepoints::Single(8812), characters: "≬" },
    Entity { entity: "&twoheadleftarrow;", codepoints: Codepoints::Single(8606), characters: "↞" },
    Entity { entity: "&twoheadrightarrow;", codepoints: Codepoints::Single(8608), characters: "↠" },
    Entity { entity: "&Uacute;", codepoints: Codepoints::Single(218), characters: "Ú" },
    Entity { entity: "&Uacute", codepoints: Codepoints::Single(218), characters: "Ú" },
    Entity { entity: "&uacute;", codepoints: Codepoints::Single(250), characters: "ú" },
    Entity { entity: "&uacute", codepoints: Codepoints::Single(250), characters: "ú" },
    Entity { entity: "&Uarr;", codepoints: Codepoints::Single(8607), characters: "↟" },
    Entity { entity: "&uArr;", codepoints: Codepoints::Single(8657), characters: "⇑" },
    Entity { entity: "&uarr;", codepoints: Codepoints::Single(8593), characters: "↑" },
    Entity { entity: "&Uarrocir;", codepoints: Codepoints::Single(10569), characters: "⥉" },
    Entity { entity: "&Ubrcy;", codepoints: Codepoints::Single(1038), characters: "Ў" },
    Entity { entity: "&ubrcy;", codepoints: Codepoints::Single(1118), characters: "ў" },
    Entity { entity: "&Ubreve;", codepoints: Codepoints::Single(364), characters: "Ŭ" },
    Entity { entity: "&ubreve;", codepoints: Codepoints::Single(365), characters: "ŭ" },
    Entity { entity: "&Ucirc;", codepoints: Codepoints::Single(219), characters: "Û" },
    Entity { entity: "&Ucirc", codepoints: Codepoints::Single(219), characters: "Û" },
    Entity { entity: "&ucirc;", codepoints: Codepoints::Single(251), characters: "û" },
    Entity { entity: "&ucirc", codepoints: Codepoints::Single(251), characters: "û" },
    Entity { entity: "&Ucy;", codepoints: Codepoints::Single(1059), characters: "У" },
    Entity { entity: "&ucy;", codepoints: Codepoints::Single(1091), characters: "у" },
    Entity { entity: "&udarr;", codepoints: Codepoints::Single(8645), characters: "⇅" },
    Entity { entity: "&Udblac;", codepoints: Codepoints::Single(368), characters: "Ű" },
    Entity { entity: "&udblac;", codepoints: Codepoints::Single(369), characters: "ű" },
    Entity { entity: "&udhar;", codepoints: Codepoints::Single(10606), characters: "⥮" },
    Entity { entity: "&ufisht;", codepoints: Codepoints::Single(10622), characters: "⥾" },
    Entity { entity: "&Ufr;", codepoints: Codepoints::Single(120088), characters: "𝔘" },
    Entity { entity: "&ufr;", codepoints: Codepoints::Single(120114), characters: "𝔲" },
    Entity { entity: "&Ugrave;", codepoints: Codepoints::Single(217), characters: "Ù" },
    Entity { entity: "&Ugrave", codepoints: Codepoints::Single(217), characters: "Ù" },
    Entity { entity: "&ugrave;", codepoints: Codepoints::Single(249), characters: "ù" },
    Entity { entity: "&ugrave", codepoints: Codepoints::Single(249), characters: "ù" },
    Entity { entity: "&uHar;", codepoints: Codepoints::Single(10595), characters: "⥣" },
    Entity { entity: "&uharl;", codepoints: Codepoints::Single(8639), characters: "↿" },
    Entity { entity: "&uharr;", codepoints: Codepoints::Single(8638), characters: "↾" },
    Entity { entity: "&uhblk;", codepoints: Codepoints::Single(9600), characters: "▀" },
    Entity { entity: "&ulcorn;", codepoints: Codepoints::Single(8988), characters: "⌜" },
    Entity { entity: "&ulcorner;", codepoints: Codepoints::Single(8988), characters: "⌜" },
    Entity { entity: "&ulcrop;", codepoints: Codepoints::Single(8975), characters: "⌏" },
    Entity { entity: "&ultri;", codepoints: Codepoints::Single(9720), characters: "◸" },
    Entity { entity: "&Umacr;", codepoints: Codepoints::Single(362), characters: "Ū" },
    Entity { entity: "&umacr;", codepoints: Codepoints::Single(363), characters: "ū" },
    Entity { entity: "&uml;", codepoints: Codepoints::Single(168), characters: "¨" },
    Entity { entity: "&uml", codepoints: Codepoints::Single(168), characters: "¨" },
    Entity { entity: "&UnderBar;", codepoints: Codepoints::Single(95), characters: "_" },
    Entity { entity: "&UnderBrace;", codepoints: Codepoints::Single(9183), characters: "⏟" },
    Entity { entity: "&UnderBracket;", codepoints: Codepoints::Single(9141), characters: "⎵" },
    Entity { entity: "&UnderParenthesis;", codepoints: Codepoints::Single(9181), characters: "⏝" },
    Entity { entity: "&Union;", codepoints: Codepoints::Single(8899), characters: "⋃" },
    Entity { entity: "&UnionPlus;", codepoints: Codepoints::Single(8846), characters: "⊎" },
    Entity { entity: "&Uogon;", codepoints: Codepoints::Single(370), characters: "Ų" },
    Entity { entity: "&uogon;", codepoints: Codepoints::Single(371), characters: "ų" },
    Entity { entity: "&Uopf;", codepoints: Codepoints::Single(120140), characters: "𝕌" },
    Entity { entity: "&uopf;", codepoints: Codepoints::Single(120166), characters: "𝕦" },
    Entity { entity: "&UpArrow;", codepoints: Codepoints::Single(8593), characters: "↑" },
    Entity { entity: "&Uparrow;", codepoints: Codepoints::Single(8657), characters: "⇑" },
    Entity { entity: "&uparrow;", codepoints: Codepoints::Single(8593), characters: "↑" },
    Entity { entity: "&UpArrowBar;", codepoints: Codepoints::Single(10514), characters: "⤒" },
    Entity { entity: "&UpArrowDownArrow;", codepoints: Codepoints::Single(8645), characters: "⇅" },
    Entity { entity: "&UpDownArrow;", codepoints: Codepoints::Single(8597), characters: "↕" },
    Entity { entity: "&Updownarrow;", codepoints: Codepoints::Single(8661), characters: "⇕" },
    Entity { entity: "&updownarrow;", codepoints: Codepoints::Single(8597), characters: "↕" },
    Entity { entity: "&UpEquilibrium;", codepoints: Codepoints::Single(10606), characters: "⥮" },
    Entity { entity: "&upharpoonleft;", codepoints: Codepoints::Single(8639), characters: "↿" },
    Entity { entity: "&upharpoonright;", codepoints: Codepoints::Single(8638), characters: "↾" },
    Entity { entity: "&uplus;", codepoints: Codepoints::Single(8846), characters: "⊎" },
    Entity { entity: "&UpperLeftArrow;", codepoints: Codepoints::Single(8598), characters: "↖" },
    Entity { entity: "&UpperRightArrow;", codepoints: Codepoints::Single(8599), characters: "↗" },
    Entity { entity: "&Upsi;", codepoints: Codepoints::Single(978), characters: "ϒ" },
    Entity { entity: "&upsi;", codepoints: Codepoints::Single(965), characters: "υ" },
    Entity { entity: "&upsih;", codepoints: Codepoints::Single(978), characters: "ϒ" },
    Entity { entity: "&Upsilon;", codepoints: Codepoints::Single(933), characters: "Υ" },
    Entity { entity: "&upsilon;", codepoints: Codepoints::Single(965), characters: "υ" },
    Entity { entity: "&UpTee;", codepoints: Codepoints::Single(8869), characters: "⊥" },
    Entity { entity: "&UpTeeArrow;", codepoints: Codepoints::Single(8613), characters: "↥" },
    Entity { entity: "&upuparrows;", codepoints: Codepoints::Single(8648), characters: "⇈" },
    Entity { entity: "&urcorn;", codepoints: Codepoints::Single(8989), characters: "⌝" },
    Entity { entity: "&urcorner;", codepoints: Codepoints::Single(8989), characters: "⌝" },
    Entity { entity: "&urcrop;", codepoints: Codepoints::Single(8974), characters: "⌎" },
    Entity { entity: "&Uring;", codepoints: Codepoints::Single(366), characters: "Ů" },
    Entity { entity: "&uring;", codepoints: Codepoints::Single(367), characters: "ů" },
    Entity { entity: "&urtri;", codepoints: Codepoints::Single(9721), characters: "◹" },
    Entity { entity: "&Uscr;", codepoints: Codepoints::Single(119984), characters: "𝒰" },
    Entity { entity: "&uscr;", codepoints: Codepoints::Single(120010), characters: "𝓊" },
    Entity { entity: "&utdot;", codepoints: Codepoints::Single(8944), characters: "⋰" },
    Entity { entity: "&Utilde;", codepoints: Codepoints::Single(360), characters: "Ũ" },
    Entity { entity: "&utilde;", codepoints: Codepoints::Single(361), characters: "ũ" },
    Entity { entity: "&utri;", codepoints: Codepoints::Single(9653), characters: "▵" },
    Entity { entity: "&utrif;", codepoints: Codepoints::Single(9652), characters: "▴" },
    Entity { entity: "&uuarr;", codepoints: Codepoints::Single(8648), characters: "⇈" },
    Entity { entity: "&Uuml;", codepoints: Codepoints::Single(220), characters: "Ü" },
    Entity { entity: "&Uuml", codepoints: Codepoints::Single(220), characters: "Ü" },
    Entity { entity: "&uuml;", codepoints: Codepoints::Single(252), characters: "ü" },
    Entity { entity: "&uuml", codepoints: Codepoints::Single(252), characters: "ü" },
    Entity { entity: "&uwangle;", codepoints: Codepoints::Single(10663), characters: "⦧" },
    Entity { entity: "&vangrt;", codepoints: Codepoints::Single(10652), characters: "⦜" },
    Entity { entity: "&varepsilon;", codepoints: Codepoints::Single(1013), characters: "ϵ" },
    Entity { entity: "&varkappa;", codepoints: Codepoints::Single(1008), characters: "ϰ" },
    Entity { entity: "&varnothing;", codepoints: Codepoints::Single(8709), characters: "∅" },
    Entity { entity: "&varphi;", codepoints: Codepoints::Single(981), characters: "ϕ" },
    Entity { entity: "&varpi;", codepoints: Codepoints::Single(982), characters: "ϖ" },
    Entity { entity: "&varpropto;", codepoints: Codepoints::Single(8733), characters: "∝" },
    Entity { entity: "&vArr;", codepoints: Codepoints::Single(8661), characters: "⇕" },
    Entity { entity: "&varr;", codepoints: Codepoints::Single(8597), characters: "↕" },
    Entity { entity: "&varrho;", codepoints: Codepoints::Single(1009), characters: "ϱ" },
    Entity { entity: "&varsigma;", codepoints: Codepoints::Single(962), characters: "ς" },
    Entity { entity: "&varsubsetneq;", codepoints: Codepoints::Double(8842, 65024), characters: "⊊︀" },
    Entity { entity: "&varsubsetneqq;", codepoints: Codepoints::Double(10955, 65024), characters: "⫋︀" },
    Entity { entity: "&varsupsetneq;", codepoints: Codepoints::Double(8843, 65024), characters: "⊋︀" },
    Entity { entity: "&varsupsetneqq;", codepoints: Codepoints::Double(10956, 65024), characters: "⫌︀" },
    Entity { entity: "&vartheta;", codepoints: Codepoints::Single(977), characters: "ϑ" },
    Entity { entity: "&vartriangleleft;", codepoints: Codepoints::Single(8882), characters: "⊲" },
    Entity { entity: "&vartriangleright;", codepoints: Codepoints::Single(8883), characters: "⊳" },
    Entity { entity: "&Vbar;", codepoints: Codepoints::Single(10987), characters: "⫫" },
    Entity { entity: "&vBar;", codepoints: Codepoints::Single(10984), characters: "⫨" },
    Entity { entity: "&vBarv;", codepoints: Codepoints::Single(10985), characters: "⫩" },
    Entity { entity: "&Vcy;", codepoints: Codepoints::Single(1042), characters: "В" },
    Entity { entity: "&vcy;", codepoints: Codepoints::Single(1074), characters: "в" },
    Entity { entity: "&VDash;", codepoints: Codepoints::Single(8875), characters: "⊫" },
    Entity { entity: "&Vdash;", codepoints: Codepoints::Single(8873), characters: "⊩" },
    Entity { entity: "&vDash;", codepoints: Codepoints::Single(8872), characters: "⊨" },
    Entity { entity: "&vdash;", codepoints: Codepoints::Single(8866), characters: "⊢" },
    Entity { entity: "&Vdashl;", codepoints: Codepoints::Single(10982), characters: "⫦" },
    Entity { entity: "&Vee;", codepoints: Codepoints::Single(8897), characters: "⋁" },
    Entity { entity: "&vee;", codepoints: Codepoints::Single(8744), characters: "∨" },
    Entity { entity: "&veebar;", codepoints: Codepoints::Single(8891), characters: "⊻" },
    Entity { entity: "&veeeq;", codepoints: Codepoints::Single(8794), characters: "≚" },
    Entity { entity: "&vellip;", codepoints: Codepoints::Single(8942), characters: "⋮" },
    Entity { entity: "&Verbar;", codepoints: Codepoints::Single(8214), characters: "‖" },
    Entity { entity: "&verbar;", codepoints: Codepoints::Single(124), characters: "|" },
    Entity { entity: "&Vert;", codepoints: Codepoints::Single(8214), characters: "‖" },
    Entity { entity: "&vert;", codepoints: Codepoints::Single(124), characters: "|" },
    Entity { entity: "&VerticalBar;", codepoints: Codepoints::Single(8739), characters: "∣" },
    Entity { entity: "&VerticalLine;", codepoints: Codepoints::Single(124), characters: "|" },
    Entity { entity: "&VerticalSeparator;", codepoints: Codepoints::Single(10072), characters: "❘" },
    Entity { entity: "&VerticalTilde;", codepoints: Codepoints::Single(8768), characters: "≀" },
    Entity { entity: "&VeryThinSpace;", codepoints: Codepoints::Single(8202), characters: " " },
    Entity { entity: "&Vfr;", codepoints: Codepoints::Single(120089), characters: "𝔙" },
    Entity { entity: "&vfr;", codepoints: Codepoints::Single(120115), characters: "𝔳" },
    Entity { entity: "&vltri;", codepoints: Codepoints::Single(8882), characters: "⊲" },
    Entity { entity: "&vnsub;", codepoints: Codepoints::Double(8834, 8402), characters: "⊂⃒" },
    Entity { entity: "&vnsup;", codepoints: Codepoints::Double(8835, 8402), characters: "⊃⃒" },
    Entity { entity: "&Vopf;", codepoints: Codepoints::Single(120141), characters: "𝕍" },
    Entity { entity: "&vopf;", codepoints: Codepoints::Single(120167), characters: "𝕧" },
    Entity { entity: "&vprop;", codepoints: Codepoints::Single(8733), characters: "∝" },
    Entity { entity: "&vrtri;", codepoints: Codepoints::Single(8883), characters: "⊳" },
    Entity { entity: "&Vscr;", codepoints: Codepoints::Single(119985), characters: "𝒱" },
    Entity { entity: "&vscr;", codepoints: Codepoints::Single(120011), characters: "𝓋" },
    Entity { entity: "&vsubnE;", codepoints: Codepoints::Double(10955, 65024), characters: "⫋︀" },
    Entity { entity: "&vsubne;", codepoints: Codepoints::Double(8842, 65024), characters: "⊊︀" },
    Entity { entity: "&vsupnE;", codepoints: Codepoints::Double(10956, 65024), characters: "⫌︀" },
    Entity { entity: "&vsupne;", codepoints: Codepoints::Double(8843, 65024), characters: "⊋︀" },
    Entity { entity: "&Vvdash;", codepoints: Codepoints::Single(8874), characters: "⊪" },
    Entity { entity: "&vzigzag;", codepoints: Codepoints::Single(10650), characters: "⦚" },
    Entity { entity: "&Wcirc;", codepoints: Codepoints::Single(372), characters: "Ŵ" },
    Entity { entity: "&wcirc;", codepoints: Codepoints::Single(373), characters: "ŵ" },
    Entity { entity: "&wedbar;", codepoints: Codepoints::Single(10847), characters: "⩟" },
    Entity { entity: "&Wedge;", codepoints: Codepoints::Single(8896), characters: "⋀" },
    Entity { entity: "&wedge;", codepoints: Codepoints::Single(8743), characters: "∧" },
    Entity { entity: "&wedgeq;", codepoints: Codepoints::Single(8793), characters: "≙" },
    Entity { entity: "&weierp;", codepoints: Codepoints::Single(8472), characters: "℘" },
    Entity { entity: "&Wfr;", codepoints: Codepoints::Single(120090), characters: "𝔚" },
    Entity { entity: "&wfr;", codepoints: Codepoints::Single(120116), characters: "𝔴" },
    Entity { entity: "&Wopf;", codepoints: Codepoints::Single(120142), characters: "𝕎" },
    Entity { entity: "&wopf;", codepoints: Codepoints::Single(120168), characters: "𝕨" },
    Entity { entity: "&wp;", codepoints: Codepoints::Single(8472), characters: "℘" },
    Entity { entity: "&wr;", codepoints: Codepoints::Single(8768), characters: "≀" },
    Entity { entity: "&wreath;", codepoints: Codepoints::Single(8768), characters: "≀" },
    Entity { entity: "&Wscr;", codepoints: Codepoints::Single(119986), characters: "𝒲" },
    Entity { entity: "&wscr;", codepoints: Codepoints::Single(120012), characters: "𝓌" },
    Entity { entity: "&xcap;", codepoints: Codepoints::Single(8898), characters: "⋂" },
    Entity { entity: "&xcirc;", codepoints: Codepoints::Single(9711), characters: "◯" },
    Entity { entity: "&xcup;", codepoints: Codepoints::Single(8899), characters: "⋃" },
    Entity { entity: "&xdtri;", codepoints: Codepoints::Single(9661), characters: "▽" },
    Entity { entity: "&Xfr;", codepoints: Codepoints::Single(120091), characters: "𝔛" },
    Entity { entity: "&xfr;", codepoints: Codepoints::Single(120117), characters: "𝔵" },
    Entity { entity: "&xhArr;", codepoints: Codepoints::Single(10234), characters: "⟺" },
    Entity { entity: "&xharr;", codepoints: Codepoints::Single(10231), characters: "⟷" },
    Entity { entity: "&Xi;", codepoints: Codepoints::Single(926), characters: "Ξ" },
    Entity { entity: "&xi;", codepoints: Codepoints::Single(958), characters: "ξ" },
    Entity { entity: "&xlArr;", codepoints: Codepoints::Single(10232), characters: "⟸" },
    Entity { entity: "&xlarr;", codepoints: Codepoints::Single(10229), characters: "⟵" },
    Entity { entity: "&xmap;", codepoints: Codepoints::Single(10236), characters: "⟼" },
    Entity { entity: "&xnis;", codepoints: Codepoints::Single(8955), characters: "⋻" },
    Entity { entity: "&xodot;", codepoints: Codepoints::Single(10752), characters: "⨀" },
    Entity { entity: "&Xopf;", codepoints: Codepoints::Single(120143), characters: "𝕏" },
    Entity { entity: "&xopf;", codepoints: Codepoints::Single(120169), characters: "𝕩" },
    Entity { entity: "&xoplus;", codepoints: Codepoints::Single(10753), characters: "⨁" },
    Entity { entity: "&xotime;", codepoints: Codepoints::Single(10754), characters: "⨂" },
    Entity { entity: "&xrArr;", codepoints: Codepoints::Single(10233), characters: "⟹" },
    Entity { entity: "&xrarr;", codepoints: Codepoints::Single(10230), characters: "⟶" },
    Entity { entity: "&Xscr;", codepoints: Codepoints::Single(119987), characters: "𝒳" },
    Entity { entity: "&xscr;", codepoints: Codepoints::Single(120013), characters: "𝓍" },
    Entity { entity: "&xsqcup;", codepoints: Codepoints::Single(10758), characters: "⨆" },
    Entity { entity: "&xuplus;", codepoints: Codepoints::Single(10756), characters: "⨄" },
    Entity { entity: "&xutri;", codepoints: Codepoints::Single(9651), characters: "△" },
    Entity { entity: "&xvee;", codepoints: Codepoints::Single(8897), characters: "⋁" },
    Entity { entity: "&xwedge;", codepoints: Codepoints::Single(8896), characters: "⋀" },
    Entity { entity: "&Yacute;", codepoints: Codepoints::Single(221), characters: "Ý" },
    Entity { entity: "&Yacute", codepoints: Codepoints::Single(221), characters: "Ý" },
    Entity { entity: "&yacute;", codepoints: Codepoints::Single(253), characters: "ý" },
    Entity { entity: "&yacute", codepoints: Codepoints::Single(253), characters: "ý" },
    Entity { entity: "&YAcy;", codepoints: Codepoints::Single(1071), characters: "Я" },
    Entity { entity: "&yacy;", codepoints: Codepoints::Single(1103), characters: "я" },
    Entity { entity: "&Ycirc;", codepoints: Codepoints::Single(374), characters: "Ŷ" },
    Entity { entity: "&ycirc;", codepoints: Codepoints::Single(375), characters: "ŷ" },
    Entity { entity: "&Ycy;", codepoints: Codepoints::Single(1067), characters: "Ы" },
    Entity { entity: "&ycy;", codepoints: Codepoints::Single(1099), characters: "ы" },
    Entity { entity: "&yen;", codepoints: Codepoints::Single(165), characters: "¥" },
    Entity { entity: "&yen", codepoints: Codepoints::Single(165), characters: "¥" },
    Entity { entity: "&Yfr;", codepoints: Codepoints::Single(120092), characters: "𝔜" },
    Entity { entity: "&yfr;", codepoints: Codepoints::Single(120118), characters: "𝔶" },
    Entity { entity: "&YIcy;", codepoints: Codepoints::Single(1031), characters: "Ї" },
    Entity { entity: "&yicy;", codepoints: Codepoints::Single(1111), characters: "ї" },
    Entity { entity: "&Yopf;", codepoints: Codepoints::Single(120144), characters: "𝕐" },
    Entity { entity: "&yopf;", codepoints: Codepoints::Single(120170), characters: "𝕪" },
    Entity { entity: "&Yscr;", codepoints: Codepoints::Single(119988), characters: "𝒴" },
    Entity { entity: "&yscr;", codepoints: Codepoints::Single(120014), characters: "𝓎" },
    Entity { entity: "&YUcy;", codepoints: Codepoints::Single(1070), characters: "Ю" },
    Entity { entity: "&yucy;", codepoints: Codepoints::Single(1102), characters: "ю" },
    Entity { entity: "&Yuml;", codepoints: Codepoints::Single(376), characters: "Ÿ" },
    Entity { entity: "&yuml;", codepoints: Codepoints::Single(255), characters: "ÿ" },
    Entity { entity: "&yuml", codepoints: Codepoints::Single(255), characters: "ÿ" },
    Entity { entity: "&Zacute;", codepoints: Codepoints::Single(377), characters: "Ź" },
    Entity { entity: "&zacute;", codepoints: Codepoints::Single(378), characters: "ź" },
    Entity { entity: "&Zcaron;", codepoints: Codepoints::Single(381), characters: "Ž" },
    Entity { entity: "&zcaron;", codepoints: Codepoints::Single(382), characters: "ž" },
    Entity { entity: "&Zcy;", codepoints: Codepoints::Single(1047), characters: "З" },
    Entity { entity: "&zcy;", codepoints: Codepoints::Single(1079), characters: "з" },
    Entity { entity: "&Zdot;", codepoints: Codepoints::Single(379), characters: "Ż" },
    Entity { entity: "&zdot;", codepoints: Codepoints::Single(380), characters: "ż" },
    Entity { entity: "&zeetrf;", codepoints: Codepoints::Single(8488), characters: "ℨ" },
    Entity { entity: "&ZeroWidthSpace;", codepoints: Codepoints::Single(8203), characters: "​" },
    Entity { entity: "&Zeta;", codepoints: Codepoints::Single(918), characters: "Ζ" },
    Entity { entity: "&zeta;", codepoints: Codepoints::Single(950), characters: "ζ" },
    Entity { entity: "&Zfr;", codepoints: Codepoints::Single(8488), characters: "ℨ" },
    Entity { entity: "&zfr;", codepoints: Codepoints::Single(120119), characters: "𝔷" },
    Entity { entity: "&ZHcy;", codepoints: Codepoints::Single(1046), characters: "Ж" },
    Entity { entity: "&zhcy;", codepoints: Codepoints::Single(1078), characters: "ж" },
    Entity { entity: "&zigrarr;", codepoints: Codepoints::Single(8669), characters: "⇝" },
    Entity { entity: "&Zopf;", codepoints: Codepoints::Single(8484), characters: "ℤ" },
    Entity { entity: "&zopf;", codepoints: Codepoints::Single(120171), characters: "𝕫" },
    Entity { entity: "&Zscr;", codepoints: Codepoints::Single(119989), characters: "𝒵" },
    Entity { entity: "&zscr;", codepoints: Codepoints::Single(120015), characters: "𝓏" },
    Entity { entity: "&zwj;", codepoints: Codepoints::Single(8205), characters: "‍" },
    Entity { entity: "&zwnj;", codepoints: Codepoints::Single(8204), characters: "‌" },
];
