#include "rheolef.h"
using namespace rheolef;
using namespace std;
Float nu = 1e-3;
point u (const point & x) { return point(-x[1], x[0]); }
struct phi : unary_function<point,Float> {
  Float operator() (const point& x) {
    point xc (0.25, 0, 0);
    Float sigma = 0.01;
    return sigma/(sigma + 4*nu*t)
        * exp(-(sqr( x[0]*cos(t) + x[1]*sin(t) - xc[0])
              + sqr(-x[0]*sin(t) + x[1]*cos(t) - xc[1]))/(sigma + 4*nu*t));
  }
  phi (Float tau) : t(tau) {}
  protected: Float t;
};
int main (int argc, char **argv) {
  geo omega (argv[1]);
  size_t n_max  = (argc > 2) ? atoi(argv[2]) : 24;
  Float delta_t = 2*acos(-1.)/n_max;
  space Vh (omega, "P1");
  Vh.block ("boundary");
  form m (Vh, Vh, "mass");
  form a (Vh, Vh, "grad_grad");
  form c = m + delta_t*nu*a;
  ssk<Float> c_fact = ldlt (c.uu);
  field uh = interpolate (Vh*Vh, u);
  field phih = interpolate (Vh, phi(0));
  cerr << "# # t\terror" << endl;
  geomap X (Vh, -delta_t*uh);
  branch event ("t","phi");
  cout << event (0, phih);
  for (size_t n = 1; n <= n_max; n++) {
    Float t = Float(n)*delta_t;
    field prec_phih = compose (phih, X);
    phih.u = c_fact.solve (m.uu*prec_phih.u + m.ub*prec_phih.b - c.ub*phih.b);
    field e = phih - interpolate (Vh, phi(t));
    cerr << "# " << t << "\t" << sqrt(m(e,e)) << endl;
    cout << event (t, phih);
  }
}
