// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from AuthManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.auth {
  public class AuthManager : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("auth.AuthManager:1.0.0", null);

    public AuthManager(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public AuthManager(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new AuthManager StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new AuthManager(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_UNSUPPORTED_TYPE = 1;

    public class GetPolicyResult {
      public Com.Raritan.Idl.auth.Policy _ret_;
    }

    public GetPolicyResult getPolicy() {
      JsonObject _parameters = null;
      var _result = RpcCall("getPolicy", _parameters);
      var _ret = new GetPolicyResult();
      _ret._ret_ = Com.Raritan.Idl.auth.Policy.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getPolicy(AsyncRpcResponse<GetPolicyResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getPolicy(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getPolicy(AsyncRpcResponse<GetPolicyResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getPolicy", _parameters,
        _result => {
          try {
            var _ret = new GetPolicyResult();
            _ret._ret_ = Com.Raritan.Idl.auth.Policy.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetPolicyResult {
      public int _ret_;
    }

    public SetPolicyResult setPolicy(Com.Raritan.Idl.auth.Policy p) {
      var _parameters = new LightJson.JsonObject();
      _parameters["p"] = p.Encode();

      var _result = RpcCall("setPolicy", _parameters);
      var _ret = new SetPolicyResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setPolicy(Com.Raritan.Idl.auth.Policy p, AsyncRpcResponse<SetPolicyResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setPolicy(p, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setPolicy(Com.Raritan.Idl.auth.Policy p, AsyncRpcResponse<SetPolicyResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["p"] = p.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setPolicy", _parameters,
        _result => {
          try {
            var _ret = new SetPolicyResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
