% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variant2evidence.R
\name{variant2evidence}
\alias{variant2evidence}
\title{Retrieves evidences supporting a gene-disease association, for a gene, or list of genes and generates an \code{DataGeNET.DGN}}
\usage{
variant2evidence(
  variant,
  disease = NULL,
  year = c(0, 2050),
  database = "CURATED",
  score = c(0, 1),
  api_key = NULL,
  verbose = FALSE,
  warnings = TRUE
)
}
\arguments{
\item{variant}{a variant or a list of variants}

\item{database}{Name of the database that will be queried. It can take the values:
\code{'CTD_human'} to use Comparative Toxicogenomics Database, human data;
\code{'UNIPROT'} to use Universal Protein Resource;
\code{'CLINGEN'} to use Clinical Genome Resource;
\code{'CGI'} to use Cancer Genome Interpreter;
\code{'ORPHANET'}, to use Orphanet, the portal for rare diseases and orphan drugs;
\code{'PSYGENET'} to use PSYGENET;
\code{'GENOMICS_ENGLAND'} to use Genomics England PanelApp;
\code{'CURATED'} to use expert curated, human databases;
\code{'HPO'} to use HPO;
\code{'INFERRED'} to use inferred data from HPO, GWASDB, GWASCAT, and CLINVAR;
\code{'CTD_rat'} to use Comparative Toxicogenomics Database, rat data;
\code{'CTD_mouse'} to use Comparative Toxicogenomics Database, mouse data;
\code{'RGD'}, to use Rat Genome Database;
\code{'MGD'}, to use the Mouse Genome Database;
\code{'ANIMAL_MODELS'} to use the expert curated, animal models data;
\code{'GWASCAT'} to use the NHGRI-EBI GWAS Catalog;
\code{'GWASDB'} to use the GWAS Database GWASdb;
\code{'CLINVAR'} to use ClinVar, a public archive of relationships
among sequence variation and human phenotype;
\code{'BEFREE'} to use text mining data, generated using BeFree System;
\code{'ALL'} to use all these databases. Default \code{'CURATED'}.}

\item{score}{A vector with two elements: 1) initial value of score 2) final value of score}

\item{verbose}{By default \code{FALSE}. Change it to \code{TRUE} to get a
on-time log from the function.}

\item{warnings}{By default \code{TRUE}. Change it to \code{FALSE} to not see
the warnings.}
}
\value{
An object of class \code{DataGeNET.Dis}
}
\description{
Retrieves evidences supporting a gene-disease association, for a gene, or list of genes and generates an \code{DataGeNET.DGN}
}
\examples{
g <- variant2evidence( variant = "rs121913279", "CURATED", score=c(0,1)  )
}
