% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.R
\name{split_lines}
\alias{split_lines}
\title{Split a character vector by line breaks}
\usage{
split_lines(x)
}
\arguments{
\item{x}{A character vector.}
}
\value{
All elements of the character vector are split by \code{'\\n'} into
lines.
}
\description{
Call \code{unlist(strsplit(x, '\\n'))} on the character vector \code{x} and
make sure it works in a few edge cases: \code{split_lines('')} returns
\code{''} instead of \code{character(0)} (which is the returned value of
\code{strsplit('', '\\n')}); \code{split_lines('a\\n')} returns \code{c('a', '')} instead of \code{c('a')} (which is the returned value of
\code{strsplit('a\\n', '\\n')}.
}
\examples{
xfun::split_lines(c("a", "b\nc"))
}
