% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timezone.R
\name{with_timezone}
\alias{with_timezone}
\alias{local_timezone}
\title{Time zone}
\usage{
with_timezone(tz, code)

local_timezone(tz, .local_envir = parent.frame())
}
\arguments{
\item{tz}{\verb{[character(1)]} a valid time zone specification, note that
time zone names might be platform dependent.}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{.local_envir}{The environment to apply the change to.}
}
\value{
\code{[any]}\cr The results of the evaluation of the \code{code}
argument.
}
\description{
Change the time zone, and restore it afterwards.
}
\details{
\code{with_time_zone()} runs the code with the specified time zone and
resets it afterwards.

\code{local_time_zone()} changes the time zone for the caller
execution environment.
}
\examples{
Sys.time()
with_timezone("Europe/Paris", print(Sys.time()))
with_timezone("US/Pacific", print(Sys.time()))

fun1 <- function() {
  local_timezone("CET")
  print(Sys.time())
}

fun2 <- function() {
  local_timezone("US/Pacific")
  print(Sys.time())
}
Sys.time()
fun1()
fun2()
Sys.time()
}
\seealso{
\code{\link{withr}} for examples

\code{\link[=Sys.timezone]{Sys.timezone()}}.
}
