% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_info}
\alias{get_info}
\alias{get_ext}
\title{Get File Info}
\usage{
get_info(file)

get_ext(file)
}
\arguments{
\item{file}{A character string containing a filename, file path, or URL.}
}
\value{
For \code{\link[=get_info]{get_info()}}, a list is return with the following slots
\itemize{
\item \code{input} file extension or information used to identify the possible file format
\item \code{format} file format, see \code{format} argument of \code{\link[=import]{import()}}
\item \code{type} "import" (supported by default); "suggest" (supported by suggested packages, see \code{\link[=install_formats]{install_formats()}}); "enhance" and "known " are not directly supported; \code{NA} is unsupported
\item \code{format_name} name of the format
\item \code{import_function} What function is used to import this file
\item \code{export_function} What function is used to export this file
\item \code{file} \code{file}
}
For \code{\link[=get_ext]{get_ext()}}, just \code{input} (usually file extension) is returned; retained for backward compatibility.
}
\description{
A utility function to retrieve the file information of a filename, path, or URL.
}
\examples{
get_info("starwars.xlsx")
get_info("starwars.ods")
get_info("https://github.com/ropensci/readODS/raw/v2.1/starwars.ods")
get_info("~/duran_duran_rio.mp3")
get_ext("clipboard") ## "clipboard"
get_ext("https://github.com/ropensci/readODS/raw/v2.1/starwars.ods")
}
