% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melt.r
\name{melt.data.frame}
\alias{melt.data.frame}
\title{Melt a data frame into form suitable for easy casting.}
\usage{
\method{melt}{data.frame}(data, id.vars, measure.vars,
  variable.name = "variable", ..., na.rm = FALSE, value.name = "value",
  factorsAsStrings = TRUE)
}
\arguments{
\item{data}{data frame to melt}

\item{id.vars}{vector of id variables. Can be integer (variable position)
or string (variable name). If blank, will use all non-measured variables.}

\item{measure.vars}{vector of measured variables. Can be integer (variable
position) or string (variable name)If blank, will use all non id.vars}

\item{variable.name}{name of variable used to store measured variable names}

\item{...}{further arguments passed to or from other methods.}

\item{na.rm}{Should NA values be removed from the data set? This will
convert explicit missings to implicit missings.}

\item{value.name}{name of variable used to store values}

\item{factorsAsStrings}{Control whether factors are converted to character
when melted as measure variables. When \code{FALSE}, coercion is forced if
levels are not identical across the \code{measure.vars}.}
}
\description{
You need to tell melt which of your variables are id variables, and which
are measured variables. If you only supply one of \code{id.vars} and
\code{measure.vars}, melt will assume the remainder of the variables in the
data set belong to the other. If you supply neither, melt will assume
factor and character variables are id variables, and all others are
measured.
}
\examples{
names(airquality) <- tolower(names(airquality))
melt(airquality, id=c("month", "day"))
names(ChickWeight) <- tolower(names(ChickWeight))
melt(ChickWeight, id=2:4)
}
\seealso{
\code{\link{cast}}

Other melt methods: \code{\link{melt.array}},
  \code{\link{melt.default}}, \code{\link{melt.list}}
}
\concept{melt methods}
\keyword{manip}
