% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log.R
\name{step_log}
\alias{step_log}
\title{Logarithmic Transformation}
\usage{
step_log(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  base = exp(1),
  offset = 0,
  columns = NULL,
  skip = FALSE,
  signed = FALSE,
  id = rand_id("log")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{base}{A numeric value for the base.}

\item{offset}{An optional value to add to the data prior to
logging (to avoid \code{log(0)}).}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{signed}{A logical indicating whether to take the signed log.
This is sign(x) * abs(log(x)) when abs(x) => 1 or 0 if abs(x) < 1.
If \code{TRUE} the \code{offset} argument will be ignored.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_log} creates a \emph{specification} of a recipe step
that will log transform data.
}
\details{
When you \code{\link[=tidy]{tidy()}} this step, a tibble with columns \code{terms} (the
columns that will be affected) and \code{base}.
}
\examples{
set.seed(313)
examples <- matrix(exp(rnorm(40)), ncol = 2)
examples <- as.data.frame(examples)

rec <- recipe(~ V1 + V2, data = examples)

log_trans <- rec  \%>\%
  step_log(all_numeric_predictors())

log_obj <- prep(log_trans, training = examples)

transformed_te <- bake(log_obj, examples)
plot(examples$V1, transformed_te$V1)

tidy(log_trans, number = 1)
tidy(log_obj, number = 1)

# using the signed argument with negative values

examples2 <- matrix(rnorm(40, sd = 5), ncol = 2)
examples2 <- as.data.frame(examples2)

recipe(~ V1 + V2, data = examples2) \%>\%
  step_log(all_numeric_predictors()) \%>\%
  prep(training = examples2) \%>\%
  bake(examples2)

recipe(~ V1 + V2, data = examples2) \%>\%
  step_log(all_numeric_predictors(), signed = TRUE) \%>\%
  prep(training = examples2) \%>\%
  bake(examples2)

}
\seealso{
Other individual transformation steps: 
\code{\link{step_BoxCox}()},
\code{\link{step_YeoJohnson}()},
\code{\link{step_bs}()},
\code{\link{step_harmonic}()},
\code{\link{step_hyperbolic}()},
\code{\link{step_inverse}()},
\code{\link{step_invlogit}()},
\code{\link{step_logit}()},
\code{\link{step_mutate}()},
\code{\link{step_ns}()},
\code{\link{step_poly}()},
\code{\link{step_relu}()},
\code{\link{step_sqrt}()}
}
\concept{individual transformation steps}
