% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/followupTable.R
\name{followupTable}
\alias{followupTable}
\title{Summary tables for a given followup time point.}
\usage{
followupTable(formula, data, followup.time, compare.groups, ...)
}
\arguments{
\item{formula}{Formula A formula whose left hand side is a
\code{Hist} object. In some special cases it can also be a
\code{Surv} response object.  The right hand side is as in
\code{\link{utable}}.}

\item{data}{A data.frame in which all the variables of
\code{formula} can be interpreted.}

\item{followup.time}{Time point at which to evaluate outcome
status.}

\item{compare.groups}{Method for comparing groups.}

\item{...}{Passed to \code{utable}. All arguments of \code{utable}
can be controlled in this way except for \code{compare.groups}
which is set to \code{"Cox"}. See details.}
}
\value{
Summary table.
}
\description{
Summarize baseline variables in groups defined by outcome
at a given followup time point
}
\details{
If \code{compare.groups!=FALSE}, p-values are obtained from stopped Cox regression, i.e., all events are censored at follow-up time.
A univariate Cox regression model is fitted to assess the effect of each variable on the right hand side of the formula on the event hazard and shown is the p-value of \code{anova(fit)}, see \code{\link{anova.coxph}}.
}
\examples{
library(survival)
data(pbc)
pbc$edema <- factor(pbc$edema,levels=c("0","0.5","1"),labels=c("0","0.5","1"))
pbc$sex <- factor(pbc$sex,levels=c("m","f"),labels=c("m","f"))
followupTable(Hist(time,status)~age+edema+sex,data=pbc,followup.time=1000)

}
\seealso{
univariateTable
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
