% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta.score.R
\name{delta.score}
\alias{delta.score}
\title{Computes the \eqn{\delta} score}
\usage{
delta.score(x, arg = "mean", ...)
}
\arguments{
\item{x}{an object of class \code{phyDat}}

\item{arg}{Specifies the return value, one of "all", "mean" or "sd"}

\item{...}{further arguments passed through \code{dist.hamming}}
}
\value{
A vector containing the \eqn{\delta} scores.
}
\description{
Computes the treelikeness
}
\examples{

data(yeast)
hist(delta.score(yeast, "all"))

}
\references{
BR Holland, KT Huber, A Dress, V Moulton (2002) \eqn{\delta}
Plots: a tool for analyzing phylogenetic distance data Russell D. Gray,
David Bryant, Simon J. Greenhill (2010) On the shape and fabric of human
history \emph{Molecular Biology and Evolution}, \bold{19(12)} 2051--2059

Russell D. Gray, David Bryant, Simon J. Greenhill (2010) On the shape and
fabric of human history \emph{Phil. Trans. R. Soc. B}, \bold{365}
3923--3933; DOI: 10.1098/rstb.2010.0162
}
\seealso{
\code{\link{dist.hamming}}
}
\author{
Alastair Potts and Klaus Schliep
}
\keyword{cluster}
