% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliques.R
\name{ivs}
\alias{ivs}
\alias{largest_ivs}
\alias{max_ivs}
\alias{ivs_size}
\alias{independence_number}
\title{Independent vertex sets}
\usage{
ivs(graph, min = NULL, max = NULL)

largest_ivs(graph)

max_ivs(graph)

ivs_size(graph)

independence_number(graph)
}
\arguments{
\item{graph}{The input graph, directed graphs are considered as undirected,
loop edges and multiple edges are ignored.}

\item{min}{Numeric constant, limit for the minimum size of the independent
vertex sets to find. \code{NULL} means no limit.}

\item{max}{Numeric constant, limit for the maximum size of the independent
vertex sets to find. \code{NULL} means no limit.}
}
\value{
\code{ivs()},
\code{largest_ivs()} and
\code{max_ivs()} return a list containing numeric
vertex ids, each list element is an independent vertex set.

\code{ivs_size()} returns an integer constant.
}
\description{
A vertex set is called independent if there no edges between any two
vertices in it. These functions find independent vertex sets in undirected
graphs
}
\details{
\code{ivs()} finds all independent vertex sets in the
network, obeying the size limitations given in the \code{min} and \code{max}
arguments.

\code{largest_ivs()} finds the largest independent vertex
sets in the graph. An independent vertex set is largest if there is no
independent vertex set with more vertices.

\code{max_ivs()} finds the maximal independent vertex
sets in the graph. An independent vertex set is maximal if it cannot be
extended to a larger independent vertex set. The largest independent vertex
sets are maximal, but the opposite is not always true.

\code{ivs_size()} calculate the size of the largest independent
vertex set(s).

\code{independence_number()} is an alias for \code{ivs_size()}.

These functions use the algorithm described by Tsukiyama et al., see
reference below.
}
\examples{

# Do not run, takes a couple of seconds

# A quite dense graph
set.seed(42)
g <- sample_gnp(100, 0.9)
ivs_size(g)
ivs(g, min = ivs_size(g))
largest_ivs(g)
# Empty graph
induced_subgraph(g, largest_ivs(g)[[1]])

length(max_ivs(g))
}
\references{
S. Tsukiyama, M. Ide, H. Ariyoshi and I. Shirawaka. A new
algorithm for generating all the maximal independent sets. \emph{SIAM J
Computing}, 6:505--517, 1977.
}
\seealso{
Other cliques: 
\code{\link{cliques}()},
\code{\link{weighted_cliques}()}
}
\author{
Tamas Nepusz \email{ntamas@gmail.com} ported it from the Very Nauty
Graph Library by Keith Briggs (\url{http://keithbriggs.info/}) and Gabor
Csardi \email{csardi.gabor@gmail.com} wrote the R interface and this manual
page.
}
\concept{cliques}
\keyword{graphs}
