#include <gsl/gsl_sf_coulomb.h>
#include <gsl/gsl_errno.h>

/* function names generated by removing  "gsl_sf" from the beginning
   of the name and _e from the end. */


void hydrogenicR_1(double *Z, double *r, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_hydrogenicR_1_e(Z[i], r[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void hydrogenicR(int *n, int *l, double *Z, double *r, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_hydrogenicR_e(n[i], l[i], Z[i], r[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void coulomb_wave_FG(double *eta, double *x, double *L_F, int *k, int *len,
		     double *val_F   , double *err_F  ,
		     double *val_Fp  , double *err_Fp ,
		     double *val_G   , double *err_G  , 
		     double *val_Gp  , double *err_Gp ,
		     double *exp_F   , double *exp_G  , 
		     int *status)
{
	int i;
	gsl_sf_result F;
	gsl_sf_result Fp;
	gsl_sf_result G;
	gsl_sf_result Gp;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_coulomb_wave_FG_e(eta[i], x[i], L_F[i], k[i], &F, &Fp, &G, &Gp, exp_F+i, exp_G+i);
		val_F[i]  = F.val;
		err_F[i]  = F.err;
		val_Fp[i] = Fp.val;
		err_Fp[i] = Fp.err;
		val_G[i]  = G.val;
		err_G[i]  = G.err;
		val_Gp[i] = Gp.val;
		err_Gp[i] = Gp.err;
	}
}  

void coulomb_wave_F_array(double *L_min, int *kmax, double *eta, double *x, int *len, double *fc_array, double *F_exponent, int* status)
{
	int i;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_coulomb_wave_F_array(*L_min, *kmax, eta[i], x[i], fc_array+i*(*kmax+1), F_exponent+i);
	}
}

void coulomb_wave_FG_array(double *L_min, int *kmax, double *eta, double *x, int *len, double *fc_array, double *gc_array, double *F_exponent, double *G_exponent, int* status)
{
	int i;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_coulomb_wave_FG_array(*L_min, *kmax, eta[i], x[i], fc_array+i*(*kmax+1), gc_array+i*(*kmax+1), F_exponent+i, G_exponent+i);
	}
}


void coulomb_wave_FGp_array(double *L_min, int *kmax, double *eta, double *x, int *len, double *fc_array, double *fcp_array, double *gc_array, double *gcp_array, double *F_exponent, double *G_exponent, int* status)
{
	int i;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_coulomb_wave_FGp_array(*L_min, *kmax, eta[i], x[i], fc_array+i*(*kmax+1), fcp_array+i*(*kmax+1), gc_array+i*(*kmax+1), gcp_array+i*(*kmax+1), F_exponent+i, G_exponent+i);
	}
}

void coulomb_wave_sphF_array(double *L_min, int *kmax, double *eta, double *x, int *len, double *fc_array, double *F_exponent, int* status)
{
	int i;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_coulomb_wave_sphF_array(*L_min, *kmax, eta[i], x[i], fc_array+i*(*kmax+1), F_exponent+i);
	}
}


void coulomb_CL(double *L, double *eta, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_coulomb_CL_e(L[i], eta[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  


void coulomb_CL_array(double *L_min, int *kmax, double *eta,  int *len, double *cl, int* status)
{
	int i;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_coulomb_CL_array(*L_min, *kmax, eta[i], cl+i*(*kmax+1));
	}
}
