% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs4_formula.R
\name{gs4_formula}
\alias{gs4_formula}
\title{Class for Google Sheets formulas}
\usage{
gs4_formula(x = character())
}
\arguments{
\item{x}{Character.}
}
\value{
An S3 vector of class \code{googlesheets4_formula}.
}
\description{
In order to write a formula into Google Sheets, you need to store it as an
object of class \code{googlesheets4_formula}. This is how we distinguish a
"regular" character string from a string that should be interpreted as a
formula. \code{googlesheets4_formula} is an S3 class implemented using the \href{https://vctrs.r-lib.org/articles/s3-vector.html}{vctrs package}.
}
\examples{
\dontshow{if (gs4_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dat <- data.frame(x = c(1, 5, 3, 2, 4, 6))

ss <- gs4_create("gs4-formula-demo", sheets = dat)
ss

summaries <- tibble::tribble(
  ~desc, ~summaries,
  "max", "=max(A:A)",
  "sum", "=sum(A:A)",
  "min", "=min(A:A)",
  "sparkline", "=SPARKLINE(A:A, {\"color\", \"blue\"})"
)

# explicitly declare a column as `googlesheets4_formula`
summaries$summaries <- gs4_formula(summaries$summaries)
summaries

range_write(ss, data = summaries, range = "C1", reformat = FALSE)

miscellany <- tibble::tribble(
  ~desc, ~example,
  "hyperlink", "=HYPERLINK(\"http://www.google.com/\",\"Google\")",
  "image", "=IMAGE(\"https://www.google.com/images/srpr/logo3w.png\")"
)
miscellany$example <- gs4_formula(miscellany$example)
miscellany

sheet_write(miscellany, ss = ss)

# clean up
gs4_find("gs4-formula-demo") \%>\%
  googledrive::drive_trash()
\dontshow{\}) # examplesIf}
}
\seealso{
Other write functions: 
\code{\link{gs4_create}()},
\code{\link{range_delete}()},
\code{\link{range_flood}()},
\code{\link{range_write}()},
\code{\link{sheet_append}()},
\code{\link{sheet_write}()}
}
\concept{write functions}
