% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_welch_anova_test.R
\name{stat_welch_anova_test}
\alias{stat_welch_anova_test}
\title{Add Welch One-Way ANOVA Test P-values to a GGPlot}
\usage{
stat_welch_anova_test(
  mapping = NULL,
  data = NULL,
  group.by = NULL,
  label = "{method}, p = {p.format}",
  label.x.npc = "left",
  label.y.npc = "top",
  label.x = NULL,
  label.y = NULL,
  step.increase = 0.1,
  p.adjust.method = "holm",
  significance = list(),
  geom = "text",
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  parse = FALSE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{group.by}{(optional) character vector specifying the grouping variable;
it should be used only for grouped plots. Possible values are : \itemize{
\item \code{"x.var"}: Group by the x-axis variable and perform the test
between legend groups. In other words, the p-value is compute between legend
groups at each x position \item \code{"legend.var"}: Group by the legend
variable and perform the test between x-axis groups. In other words, the
test is performed between the x-groups for each legend level. }}

\item{label}{the column containing the label (e.g.: label = "p" or label =
"p.adj"), where \code{p} is the p-value. Can be also an expression that can
be formatted by the \code{\link[glue]{glue}()} package. For example, when
specifying label = "t-test, p = \{p\}", the expression \{p\} will be
replaced by its value.}

\item{label.x.npc, label.y.npc}{can be \code{numeric} or \code{character}
vector of the same length as the number of groups and/or panels. If too
short they will be recycled. \itemize{ \item If \code{numeric}, value should
be between 0 and 1. Coordinates to be used for positioning the label,
expressed in "normalized parent coordinates". \item If \code{character},
allowed values include: i) one of c('right', 'left', 'center', 'centre',
'middle') for x-axis; ii) and one of c( 'bottom', 'top', 'center', 'centre',
'middle') for y-axis.}}

\item{label.x, label.y}{\code{numeric} Coordinates (in data units) to be used
for absolute positioning of the label. If too short they will be recycled.}

\item{step.increase}{numeric vector with the increase in fraction of total
height for every additional comparison to minimize overlap.}

\item{p.adjust.method}{method for adjusting p values (see
\code{\link[stats]{p.adjust}}).  Has impact only in a situation, where
multiple pairwise tests are performed; or when there are multiple grouping
variables. Allowed values include "holm", "hochberg", "hommel",
"bonferroni", "BH", "BY", "fdr", "none". If you don't want to adjust the p
value (not recommended), use p.adjust.method = "none".}

\item{significance}{a list of arguments specifying the signifcance cutpoints
 and symbols. For example, \code{significance <- list(cutpoints = c(0,
 0.0001, 0.001, 0.01, 0.05, Inf), symbols = c("****", "***", "**", "*",
 "ns"))}.

 In other words, we use the following convention for symbols indicating
 statistical significance: \itemize{ \item \code{ns}: p > 0.05 \item
 \code{*}: p <= 0.05 \item \code{**}: p <= 0.01 \item \code{***}: p <= 0.001
 \item \code{****}:  p <= 0.0001 }}

\item{geom}{The geometric object to use to display the data, either as a
\code{ggproto} \code{Geom} subclass or as a string naming the geom stripped of the
\code{geom_} prefix (e.g. \code{"point"} rather than \code{"geom_point"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If FALSE (the default), removes missing values with a warning. If
TRUE silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{parse}{If TRUE, the labels will be parsed into expressions and displayed
as described in \code{?plotmath}.}

\item{...}{other arguments passed to the function \code{geom_bracket()} or
\code{geom_text()}}
}
\description{
Add Welch one-way ANOVA test p-values to a ggplot, such as
 box blots, dot plots and stripcharts.
}
\section{Computed variables}{
 \itemize{
 \item{statistic}:	the value of the test statistic (F-value)
 \item{DFn}: Degrees of Freedom in the numerator (i.e. DF effect)
 \item{DFd}:	Degrees of Freedom in the denominator (i.e., DF error)
 \item{p}:	p-value.
 \item{p.adj}: Adjusted p-values.
 \item{p.signif}: P-value significance.
 \item{p.adj.signif}: Adjusted p-value significance.
 \item{p.format}: Formated p-value.
 \item{p.adj.format}: Formated adjusted p-value.
 \item{n}: number of samples.
  }
}

\examples{
# Data preparation
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Transform `dose` into factor variable
df <- ToothGrowth
df$dose <- as.factor(df$dose)
# Add a random grouping variable
set.seed(123)
df$group <- sample(factor(rep(c("grp1", "grp2", "grp3"), 20)))
df$len <- ifelse(df$group == "grp2", df$len+2, df$len)
df$len <- ifelse(df$group == "grp3", df$len+7, df$len)
head(df, 3)


# Basic boxplot
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Create a basic boxplot
# Add 5\% and 10\% space to the plot bottom and the top, respectively
bxp <- ggboxplot(df, x = "dose", y = "len") +
  scale_y_continuous(expand = expansion(mult = c(0.05, 0.1)))

# Add the p-value to the boxplot
bxp + stat_welch_anova_test()

# Change the label position
# Using coordinates in data units
bxp + stat_welch_anova_test(label.x = "1", label.y = 10, hjust = 0)

# Format the p-value differently
custom_p_format <- function(p) {
  rstatix::p_format(p, accuracy = 0.0001, digits = 3, leading.zero = FALSE)
}
bxp + stat_welch_anova_test(
  label = "Welch Anova, italic(p) = {custom_p_format(p)}{p.signif}"
)

# Show a detailed label in italic
bxp + stat_welch_anova_test(label = "as_detailed_italic")


# Faceted plots
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Create a ggplot facet
bxp <- ggboxplot(df, x = "dose", y = "len", facet.by = "supp") +
 scale_y_continuous(expand = expansion(mult = c(0.05, 0.1)))
# Add p-values
bxp + stat_welch_anova_test()


# Grouped plots
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
bxp2 <- ggboxplot(df, x = "group", y = "len", color = "dose", palette = "npg")

# For each x-position, computes tests between legend groups
bxp2 + stat_welch_anova_test(aes(group = dose), label = "p = {p.format}{p.signif}")

#  For each legend group, computes tests between x variable groups
bxp2 + stat_welch_anova_test(aes(group = dose, color = dose), group.by = "legend.var")

}
