% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-ac.R
\name{fcor}
\alias{fcor}
\title{Fixed residual correlation (FCOR) structures}
\usage{
fcor(M)
}
\arguments{
\item{M}{Known correlation/covariance matrix of the response variable.
If a vector is passed, it will be used as diagonal entries
(variances) and correlations/covariances will be set to zero.
The actual covariance matrix used in the likelihood is obtained
by multiplying \code{M} by the square of the residual standard
deviation parameter \code{sigma} estimated as part of the model.}
}
\value{
An object of class \code{'fcor_term'}, which is a list
  of arguments to be interpreted by the formula
  parsing functions of \pkg{brms}.
}
\description{
Set up a fixed residual correlation (FCOR) term in \pkg{brms}. The function
does not evaluate its arguments -- it exists purely to help set up a model
with FCOR terms.
}
\examples{
\dontrun{
dat <- data.frame(y = rnorm(3))
V <- cbind(c(0.5, 0.3, 0.2), c(0.3, 1, 0.1), c(0.2, 0.1, 0.2))
fit <- brm(y ~ 1 + fcor(V), data = dat, data2 = list(V = V))
}

}
\seealso{
\code{\link{autocor-terms}}
}
