% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{Sorting}
\alias{Sorting}
\alias{ramsort}
\alias{ramorder}
\alias{ramsortorder}
\alias{mergesort}
\alias{mergeorder}
\alias{mergesortorder}
\alias{quicksort}
\alias{quickorder}
\alias{quicksortorder}
\alias{shellsort}
\alias{shellorder}
\alias{shellsortorder}
\alias{radixsort}
\alias{radixorder}
\alias{radixsortorder}
\alias{keysort}
\alias{keyorder}
\alias{keysortorder}
\title{Generics for in-RAM sorting and ordering}
\usage{
ramsort(x, ...)

ramorder(x, i, ...)

ramsortorder(x, i, ...)

mergesort(x, ...)

mergeorder(x, i, ...)

mergesortorder(x, i, ...)

quicksort(x, ...)

quickorder(x, i, ...)

quicksortorder(x, i, ...)

shellsort(x, ...)

shellorder(x, i, ...)

shellsortorder(x, i, ...)

radixsort(x, ...)

radixorder(x, i, ...)

radixsortorder(x, i, ...)

keysort(x, ...)

keyorder(x, i, ...)

keysortorder(x, i, ...)
}
\arguments{
\item{x}{a vector to be sorted by \code{\link[=ramsort]{ramsort()}} and
\code{\link[=ramsortorder]{ramsortorder()}}, i.e. the output of \code{\link[=sort]{sort()}}}

\item{...}{further arguments to the sorting methods}

\item{i}{integer positions to be modified by \code{\link[=ramorder]{ramorder()}} and
\code{\link[=ramsortorder]{ramsortorder()}}, default is 1:n, in this case the output is
similar to \code{\link[=order]{order()}}}
}
\value{
These functions return the number of \code{NAs} found or assumed
during sorting
}
\description{
These are generic stubs for low-level sorting and ordering methods
implemented in packages 'bit64' and 'ff'.  The \code{..sortorder} methods do
sorting and ordering at once, which requires more RAM than ordering but is
(almost) as fast as as sorting.
}
\details{
The \code{sort} generics do sort their argument 'x', some methods need
temporary RAM of the same size as 'x'.  The \code{order} generics do order
their argument 'i' leaving 'x' as it was, some methods need temporary RAM of
the same size as 'i'.  The \code{sortorder} generics do sort their argument
'x' and order their argument 'i', this way of ordering is much faster at the
price of requiring temporary RAM for both, 'x' and 'i', if the method
requires temporary RAM.  The \code{ram} generics are high-level functions
containing an optimizer that chooses the 'best' algorithms given some
context.
}
\note{
Note that these methods purposely violate the functional programming
paradigm: they are called for the side-effect of changing some of their
arguments.  The rationale behind this is that sorting is very RAM-intensive
and in certain situations we might not want to allocate additional memory if
not necessary to do so.  The \code{sort}-methods change \code{x}, the
\code{order}-methods change \code{i}, and the \code{sortoder}-methods change
both \code{x} and \code{i} You as the user are responsible to create copies
of the input data 'x' and 'i' if you need non-modified versions.
}
\section{Index of implemented methods}{
\tabular{rrl}{
   \strong{generic} \tab \strong{ff} \tab \strong{bit64} \cr
   \code{ramsort} \tab \code{\link[ff:ramsort.default]{ff::ramsort.default()}} \tab \code{\link[bit64:ramsort.integer64]{bit64::ramsort.integer64()}} \cr
   \code{shellsort} \tab \code{\link[ff:ramsort.default]{ff::shellsort.default()}} \tab \code{\link[bit64:ramsort.integer64]{bit64::shellsort.integer64()}} \cr
   \code{quicksort} \tab  \tab \code{\link[bit64:ramsort.integer64]{bit64::quicksort.integer64()}} \cr
   \code{mergesort} \tab \code{\link[ff:ramsort.default]{ff::mergesort.default()}} \tab \code{\link[bit64:ramsort.integer64]{bit64::mergesort.integer64()}} \cr
   \code{radixsort} \tab \code{\link[ff:ramsort.default]{ff::radixsort.default()}} \tab \code{\link[bit64:ramsort.integer64]{bit64::radixsort.integer64()}} \cr
   \code{keysort} \tab \code{\link[ff:ramsort.default]{ff::keysort.default()}} \tab  \cr
   \code{ramorder} \tab \code{\link[ff:ramorder.default]{ff::ramorder.default()}} \tab \code{\link[bit64:ramsort.integer64]{bit64::ramorder.integer64()}} \cr
   \code{shellorder} \tab \code{\link[ff:ramorder.default]{ff::shellorder.default()}} \tab \code{\link[bit64:ramsort.integer64]{bit64::shellorder.integer64()}} \cr
   \code{quickorder} \tab  \tab \code{\link[bit64:ramsort.integer64]{bit64::quickorder.integer64()}} \cr
   \code{mergeorder} \tab \code{\link[ff:ramorder.default]{ff::mergeorder.default()}} \tab \code{\link[bit64:ramsort.integer64]{bit64::mergeorder.integer64()}} \cr
   \code{radixorder} \tab \code{\link[ff:ramorder.default]{ff::radixorder.default()}} \tab \code{\link[bit64:ramsort.integer64]{bit64::radixorder.integer64()}} \cr
   \code{keyorder} \tab \code{\link[ff:ramorder.default]{ff::keyorder.default()}} \tab  \cr
   \code{ramsortorder} \tab  \tab \code{\link[bit64:ramsort.integer64]{bit64::ramsortorder.integer64()}} \cr
   \code{shellsortorder} \tab  \tab \code{\link[bit64:ramsort.integer64]{bit64::shellsortorder.integer64()}} \cr
   \code{quicksortorder} \tab  \tab \code{\link[bit64:ramsort.integer64]{bit64::quicksortorder.integer64()}} \cr
   \code{mergesortorder} \tab  \tab \code{\link[bit64:ramsort.integer64]{bit64::mergesortorder.integer64()}} \cr
   \code{radixsortorder} \tab  \tab \code{\link[bit64:ramsort.integer64]{bit64::radixsortorder.integer64()}} \cr
   \code{keysortorder} \tab  \tab  \cr
}
}

\seealso{
\code{\link[=sort]{sort()}} and \code{\link[=order]{order()}} in base R, \code{\link[=bitsort]{bitsort()}} for faster inteer sorting
}
\author{
Jens Oehlschlägel \href{mailto:Jens.Oehlschlaegel@truecluster.com}{Jens.Oehlschlaegel@truecluster.com}
}
\keyword{arith}
\keyword{manip}
\keyword{univar}
