% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringConvenience.R
\name{newRccSet}
\alias{newRccSet}
\title{Create a new RccSet object}
\usage{
newRccSet(rccFiles, rccCollectorToolExport = NULL, rlf = NULL,
  cdrDesignData = NULL, extraPdata = NULL, blankLabel = "blank",
  addEgAnnotations = FALSE, dropPdataCols = c("FileVersion",
  "SoftwareVersion", "Owner", "SystemAPF", "ScannerID", "CartridgeBarcode"),
  dropFdataCols = c("CodeClass_codesetAnnot", "Accession_codesetAnnot",
  "GeneName_codesetAnnot", "Accession_CDR"), experimentData.name = "",
  experimentData.lab = "", experimentData.contact = "",
  experimentData.title = "", experimentData.abstract = "",
  experimentData.url = "", experimentData.other = list())
}
\arguments{
\item{rccFiles}{Vector of paths to .RCC files with the raw count data.}

\item{rccCollectorToolExport}{Path to a .CSV file generated via the RCC Collector
Tool Export feature of NanoString's nSolver
Analysis Software. (Note that this is an alternative
to rccFiles, and if both arguments are specified at the
same time, the function will throw an error.)}

\item{rlf}{Path to the NanoString .RLF file describing
the codeset used in generating the .RCCs.}

\item{cdrDesignData}{Path to a .CSV extract of the "Design Data"
tab of a CDR spreadsheet corresponding to the
rest of the input files. See 'Details'
section of the buildCodesetAnnotation() help page
for more info on how this extract should be
prepared.}

\item{extraPdata}{Vector of paths to files containing additional
annotation about the samples which will be added
to the phenoData of the output RccSet. All
files should be tab-separated and should contain
a column labelled "FileName" whose values correspond
exactly to the basenames (including .RCC extension)
of the files specified in rccFiles or listed in
the RCC Collector Tool Export. More than one such file
may be used. A SampleType column should be present
in at most one file.}

\item{blankLabel}{Value for the output's phenoData SampleType column
that will indicate blank samples. This will be
recorded in the varMetadata for
SampleType. Blank samples, if available,
play an important role in preprocessing.}

\item{addEgAnnotations}{Logical indicating whether or not to add
EntrezGene annotations from the org.Hs.eg.db
package.}

\item{dropPdataCols}{Character vector specifying phenoData columns
to be dropped from the output object (if empty or
NULL, no columns will be dropped).}

\item{dropFdataCols}{Character vector specifying featureData columns
to be dropped from the output object (if empty or
NULL, no columns will be dropped).}

\item{experimentData.name}{String passed to the 'name' slot of the
output RccSet's experimentData.}

\item{experimentData.lab}{String passed to the 'lab' slot of the
output RccSet's experimentData.}

\item{experimentData.contact}{String passed to the 'contact' slot of the
output RccSet's experimentData.}

\item{experimentData.title}{String passed to the 'title' slot of the
output RccSet's experimentData.}

\item{experimentData.abstract}{String passed to the 'abstract' slot of the
output RccSet's experimentData.}

\item{experimentData.url}{String passed to the 'url' slot of the
output RccSet's experimentData.}

\item{experimentData.other}{List passed to the 'other' slot of the
output RccSet's experimentData.}
}
\value{
An \code{\linkS4class{RccSet}} containing the raw NanoString data and annotations.
}
\description{
This is the main wrapper function for generating an RccSet from NanoString
data. The function takes as input a vector of NanoString .RCC files with the
raw data or a .CSV file generated via the RCC Collector Tool Export feature
of NanoString's nSolver Analysis Software, an optional path to the .RLF file
describing the codeset used, optional paths to additional annotation about
the features and samples, and details about the experiment. It returns an
RccSet object.
}
\details{
In the .RLF (and sometimes in the .RCC files), the GeneName field for
positive and negative control probes contains a parenthesized label
indicating the RNA \dQuote{spike-in} levels for each probe. These labels are
removed from the control probe GeneNames in the output and recorded instead
in SpikeInInput in the output's featureData.

A pseudocount of 1 is added to all measurements to enable subsequent
log transformation of the data.

If the phenoData SampleType column is not specified via an annotation file
passed in through extraPdata, it will be created and assigned NA for all
samples.
}
\examples{
rccDir <- system.file("extdata", "RCC", package="NanoStringQCPro")
rccSet <- newRccSet(
    rccFiles = dir(rccDir, full.names=TRUE),
    rlf = system.file("extdata", "RLF", "NQCP_example.rlf", package="NanoStringQCPro"),
    extraPdata = system.file("extdata", "extraPdata", "SampleType.txt", package="NanoStringQCPro"),
    blankLabel = "blank",
    experimentData.name = "Robert Ziman",
    experimentData.lab = "Richard Bourgon",
    experimentData.contact = "ziman.robert@gene.com",
    experimentData.title = "NanoStringQCPro example dataset",
    experimentData.abstract = "Example data for the NanoStringQCPro package"
)

}
\author{
Robert Ziman
}
