% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDataFrameList.R
\name{readDataFrameList}
\alias{readDataFrameList}
\alias{loadDataFrameList}
\title{Load a data frame list}
\usage{
readDataFrameList(path, metadata, ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created with the \code{\link{saveObject}} method for \linkS4class{CompressedSplitDataFrameList} objects.}

\item{metadata}{Named list of metadata for this object, see \code{\link{readObjectFile}} for details.}

\item{...}{Further arguments, to be passed to internal \code{\link{altReadObject}} calls.}
}
\value{
A CompressedSplitDataFrameList.
}
\description{
Load a list of data frames as a \linkS4class{CompressedSplitDataFrameList} from its on-disk representation.
This is usually not directly called by users, but is instead called by dispatch in \code{\link{readObject}}.
}
\examples{
library(S4Vectors)
Y <- splitAsList(DataFrame(Xxx=LETTERS, Yyy=1:26), sample(3, 26, replace=TRUE))

tmp <- tempfile()
saveObject(Y, tmp)
readObject(tmp)

}
\seealso{
\code{"\link{saveObject,CompressedSplitDataFrameList-method}"}, to save an object to disk.
}
\author{
Aaron Lun
}
