#ifndef StreamModel_H
#define StreamModel_H


#include <QObject>
#include <QString>
#include <QQmlParserStatus>
#include <QQmlListProperty>
#include "deelistmodel.h"
#include <dee-1.0/dee.h>

class StreamModelPrivate;
class StreamModel : public DeeListModel, public QQmlParserStatus
{
    Q_OBJECT
    Q_INTERFACES(QQmlParserStatus)
    Q_PROPERTY(QString stream READ stream WRITE setStream NOTIFY streamChanged)
    Q_PROPERTY(QString service READ service WRITE setService NOTIFY serviceChanged)
    Q_PROPERTY(uint account READ account WRITE setAccount NOTIFY accountChanged)

public:
    explicit StreamModel(DeeListModel *parent = 0);
    ~StreamModel();

    void setStream(const QString& streamId);
    QString stream() const;
    void setService(const QString& serviceId);
    QString service() const;
    void setAccount(uint account);
    uint account() const;
    void classBegin();
    void componentComplete();
    QHash<int, QByteArray> roleNames() const;

    
Q_SIGNALS:
    void streamChanged();
    void serviceChanged();
    void accountChanged();

private:
    StreamModelPrivate* const d_ptr;
    Q_DECLARE_PRIVATE(StreamModel)

};

#endif // StreamModel_H
