/***************************************************************************
 *   Copyright (C) 2008-2009 by Nicolas Dubuit <dubuit@sourceforge.net>    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

// Here we avoid loading the header multiple times
#ifndef Monitor_HEADER
#define Monitor_HEADER
// We need the Plasma Applet headers
#include <KIcon>
#include <QtCore>
#include <Plasma/Applet>
#include <Plasma/Svg>
 
class QSizeF;
 
// Define our plasma Applet
class Monitor : public Plasma::Applet
{
    Q_OBJECT
    public:
        // Basic Create/Destroy
        Monitor(QObject *parent, const QVariantList &args);
        ~Monitor();
 
        // The paintInterface procedure paints the applet to screen
        void paintInterface(QPainter *painter,
                const QStyleOptionGraphicsItem *option,
                const QRect& contentsRect);
        void init();
		
	public slots :
		void updateMemValues(void) ;
		void updateCpuValues(void) ;

	private :
		QTimer tm ;
		QQueue<float> mem_vals ;
		QQueue<float> mem_cache_vals ;
		QList< QQueue<float> > cpus_vals ;
};
 
// This is the command that links your applet to the .desktop file
K_EXPORT_PLASMA_APPLET(simplemonitor, Monitor)
#endif
