<?php
	/*
	For whatever reasons run-tests.php sets new environment variables
	and gives no acceess to original environment :(. If it would at least
	preserve and overwrite only selected ones ...
	*/

	putenv("MYSQL_TEST_HOST=127.0.0.1");
	putenv("MYSQL_TEST_PORT=3306");
	putenv("MYSQL_TEST_USER=root");
	putenv("MYSQL_TEST_PASSWD=root");
	putenv("MYSQL_TEST_DB=test");
	putenv("MYSQL_TEST_ENGINE=InnoDB");
	putenv("MYSQL_TEST_SOCKET=/tmp/mysql.sock");

	putenv("MYSQL_TEST_SKIP_CONNECT_FAILURE=1");
	putenv("MYSQL_TEST_CONNECT_FLAGS=0");
	putenv("MYSQL_TEST_EXPERIMENTAL=0");

	/*
	Tests will automatically detect server roles and will be skipped if required.

	For running all tests you need all four different servers. For running
	most tests you just need the two emulated once. Some tests require only one
	server, this emulated defaults to MYSQL_TEST_HOST. If that's not enough, the
	test is skipped automatically.
	*/

	/* emulated master - standalone MySQL, not part of a replication cluster */
	putenv("MYSQL_TEST_EMULATED_MASTER_HOST=". getenv("MYSQL_TEST_HOST"));
	/* emulated slave - standalone MySQL, not part of a replication cluster */
	putenv("MYSQL_TEST_EMULATED_SLAVE_HOST=127.0.0.1:3307");

	/*
	Some tests require real replication cluster.
	Tests will check if the condfigured servers are part of a cluster.
	They default to MYSQL_TEST_EMULATED*, because some old tests may
	still use them, although they only need the emulated ones and should use them.

	Yeah, I shall fix that...
	*/

	/* master - master of a replication cluster */
	putenv("MYSQL_TEST_MASTER_HOST=127.0.0.1:5610");
	/* slave - slave of the replication cluster using the above master */
	putenv("MYSQL_TEST_SLAVE_HOST=127.0.0.1:5611");
?>