%feature("docstring") PERSALYS::Variable
"Create a variable base class.

Represents a variable.

Parameters
----------
name : str
    Name
description : str
    Description text (optional)

Examples
--------
>>> import persalys
>>> G = persalys.Variable('G', 'deviation')"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::Variable::setDescription
"Description accessor.

Parameters
----------
description : str
    Text describing the variable"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::Variable::getDescription
"Description accessor.

Returns
-------
description : :py:class:`openturns.Description`
    Text describing the variable"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::Variable::getPythonScript
"Python script accessor.

Returns
-------
script : str
    Python script to replay the analysis"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::Variable::setValue
"Default value accessor.

Parameters
----------
value : float
    Default value"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::Variable::getValue
"Default value accessor.

Returns
-------
value : float
    Default value"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::Variable::setUnit
"Unit accessor.

Parameters
----------
unit : str
    Physical quantity unit, if applicable"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::Variable::getUnit
"Unit accessor.

Returns
-------
unit : str
    Physical quantity unit, if applicable"
