#ifndef __NAPT_DUMPAVAILEPARSER_H_2024_11_10
#define __NAPT_DUMPAVAILEPARSER_H_2024_11_10

#include <map>

#include "dpkgparser.h"
#include "ipackage.h"
#include "iprogressobserver.h"
#include "packagedetails.h"

using namespace std;

namespace NApt {

class AptPackageBuilder;

class AptCacheParser
{
    static void mergeIntoPackageMap(
        const AptPackageBuilder& builder,
        map<QString, unique_ptr<const IPackage>>& target
    );
public:
    AptCacheParser();
    static map<QString, unique_ptr<const IPackage>> parseDumpAvail(
        int packageCount,
        const map<string, const DpkgParser::PackageInformation>& installedPackagesToVersion,
        NUtil::IProgressObserver& progressObserver
    );

    static PackageDetails parseCacheShow(const string& packageName);
};

}

#endif // __NAPT_DUMPAVAILEPARSER_H_2024_11_10
