###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_adobe_flex_sdk_xss_vuln_win.nasl 4212 2009-08-27 13:00:29Z aug $
#
# Adobe Flex SDK Cross-Site Scripting Vulnerability (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900829);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"2.6");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1879");
  script_bugtraq_id(36087);
  script_name("Adobe Flex SDK Cross-Site Scripting Vulnerability (Win)");
  desc = "
  Overview: This host is installed with Adobe Flex SDK and is prone to
  Cross-Site Scripting vulnerability.

  Vulnerability Insight:
  The flaw is due to error in 'index.template.html' in the express-install
  templates and it occurs when the installed Flash version is older than a
  specified 'requiredMajorVersion' value.

  Impact:
  Successful exploitation could allow remote attackers to cause XSS attacks by
  injecting arbitrary web script or HTML via the query string on the affected
  application.

  Impact Level: Application

  Affected Software/OS:
  Adobe Flex SDK version prior to 3.4 on Windows

  Fix: Upgrade to Flex SDK version 3.4
  http://opensource.adobe.com/wiki/display/flexsdk/Download+Flex+3

  ****************************************************************
  Note: This script detects Adobe Flex SDK installed as part of Adobe
  Flex Builder only. If SDK is installed seperately, manual verification
  is required.
  ****************************************************************

  References:
  http://secunia.com/advisories/36374
  http://xforce.iss.net/xforce/xfdb/52608
  http://www.adobe.com/support/security/bulletins/apsb09-13.html
  http://www.securityfocus.com/archive/1/archive/1/505948/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 2.6 (AV:N/AC:H/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 2.0
  Risk factor: Low";

  script_description(desc);
  script_summary("Check for the version of Adobe Flex SDK");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  flexName = registry_get_sz(key:key + item, item:"DisplayName");

  if("Adobe Flex" >< flexName)
  {
    sdkPath = registry_get_sz(key:key + item, item:"FrameworkPath");

    if("sdk" >< sdkPath)
    {
      sdkVer = eregmatch(pattern:"\\([0-9.]+)", string:sdkPath);

      if(!isnull(sdkVer[1]))
      {
        # Check for Flex SDK version < 3.4
        if(version_is_less(version:jrunVer, test_version:"3.4")){
          security_warning(0);
        }
      }
    }
    exit(0);
  }
}
