###############################################################################
# OpenVAS Vulnerability Test
# $Id: mysql_37640.nasl 7646 2010-05-11 18:07:01Z mime $
#
# MySQL 5.0.51a Unspecified Remote Code Execution Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100436);
 script_cve_id("CVE-2009-4484");
 script_bugtraq_id(37640);
 script_version ("1.0-$Revision: 7646 $");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");

 script_name("MySQL 5.0.51a Unspecified Remote Code Execution Vulnerability");

desc = "Overview:
MySQL 5.0.51a is prone to an unspecified remote code-execution
vulnerability.

Very few technical details are currently available.

An attacker can leverage this issue to execute arbitrary code within
the context of the vulnerable application. Failed exploit attempts
will result in a denial-of-service condition.

This issue affects MySQL 5.0.51a; other versions may also be
vulnerable.

References:
http://www.securityfocus.com/bid/37640
http://archives.neohapsis.com/archives/dailydave/2010-q1/0002.html
http://www.mysql.com/
http://intevydis.com/mysql_demo.html

Risk factor : High";

 script_description(desc);
 script_summary("Determine if MySQL version is 5.0.51a");
 script_category(ACT_GATHER_INFO);
 script_family("Databases");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencie("mysql_version.nasl");
 script_require_ports("Services/mysql", 3306);
 exit(0);
}

include("version_func.inc");
include("misc_func.inc");

port = get_kb_item("Services/mysql");
if(!port)exit(0);
if(!get_tcp_port_state(port))exit(0);

if(!ver = get_mysql_version(port:port))exit(0);
if(isnull(ver))exit(0);

if(ver =~ "5.0.51a") {
  security_hole(port:port);
  exit(0);
}

exit(0);
