###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms08-046.nasl 310 2008-10-04 12:15:05Z oct $
#
# Microsoft Windows Image Color Management System Code Execution Vulnerability (952954)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(800023);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-2245");
  script_bugtraq_id(30594);
  script_name("Microsoft Windows Image Color Management System Code Execution Vulnerability (952954)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS08-046.

  Vulnerability Insight:
  The flaw is caused due to the way Microsoft Color Management System (MSCMS)
  module of the Microsoft ICM component handles memory allocation.

  Impact:
  Successful exploitation could execute arbitrary code when a user opens a
  specially crafted image file and can gain same user rights as the local
  user. An attacker could then install programs; view, change, or delete
  data, or create new accounts.

  Impact Level: System

  Affected Software/OS: Microsoft Windows 2K/XP/2003

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms08-049.mspx

  References:
  http://www.microsoft.com/technet/security/bulletin/ms08-046.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the vulnerable File Version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

function get_version()
{
  dllPath = registry_get_sz(item:"Install Path",
                           key:"SOFTWARE\Microsoft\COM3\Setup");
  if(!dllPath){
    exit(0);
  }
  dllPath += "\Mscms.dll";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
  file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

  soc = open_sock_tcp(port);
  if(!soc){
    exit(0);
  }

  r = smb_session_request(soc:soc, remote:name);
  if(!r)
  {
    close(soc);
    exit(0);
  }
  prot = smb_neg_prot(soc:soc);
  if(!prot)
  {
    close(soc);
    exit(0);
  }

  r = smb_session_setup(soc:soc, login:login, password:pass,
                        domain:domain, prot:prot);
  if(!r)
  {
    close(soc);
    exit(0);
  }

  uid = session_extract_uid(reply:r);

  r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
  tid = tconx_extract_tid(reply:r);
  if(!tid)
  {
    close(soc);
    exit(0);
  }

  fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
  if(!fid)
  {
    close(soc);
    exit(0);
  }

  v = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, offset:60000,
                 verstr:"prod");
  close(soc);
  return v;
}

# Check for MS08-046 Hotfix (952954)
if(hotfix_missing(name:"952954") == 0){
  exit(0);
}

fileVer = get_version();
if(!fileVer){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  # Check for version < 5.0.2195.7162
  if(version_is_less(version:fileVer, test_version:"5.0.2195.7162")){
    security_hole(0);
  }
  exit(0);
}
else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # < 5.1.2600.3396
    if(version_is_less(version:fileVer, test_version:"5.1.2600.3396")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Check for version < 5.1.2600.5627
    if(version_is_less(version:fileVer, test_version:"5.1.2600.5627")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Check for version < 5.2.3790.3163
    if(version_is_less(version:fileVer, test_version:"5.2.3790.3163")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 2" >< SP)
  {
    # Check for version < 5.2.3790.4320
    if(version_is_less(version:fileVer, test_version:"5.2.3790.4320")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
