###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for jackit MDVA-2008:200 (jackit)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830539);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2008:200");
  script_name( "Mandriva Update for jackit MDVA-2008:200 (jackit)");
  desc = "

  Vulnerability Insight:

  This update provides the latest version of the JACK audio server.
  It is not provided to fix any specific bugs, but due to the
  recommendation of the JACK development community that all users should
  http://jackaudio.org/
  The release fixes many bugs and adds new features, most important
  among them being the integration of netjack functionality.

  Affected Software/OS:
  jackit on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-12/msg00023.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of jackit");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"jackit", rpm:"jackit~0.116.1~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"jackit-example-clients", rpm:"jackit-example-clients~0.116.1~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libjack0", rpm:"libjack0~0.116.1~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libjack-devel", rpm:"libjack-devel~0.116.1~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64jack0", rpm:"lib64jack0~0.116.1~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64jack-devel", rpm:"lib64jack-devel~0.116.1~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}