# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7315 (drupal)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64346);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 11 FEDORA-2009-7315 (drupal)";
 script_name(name);

 desc = "The remote host is missing an update to drupal
announced via advisory FEDORA-2009-7315.

For details, on the issues addressed, please visit the
referenced security advisories.

ChangeLog:

* Thu Jul  2 2009 Jon Ciesla  - 6.13-1
- Update to 6.11, SA-CORE-2009-007.
- Added clarifying text on module installation to readme, BZ 500707.

References:

[ 1 ] Bug #500707 - drupal-README.fedora should give hints about where to install modules
https://bugzilla.redhat.com/show_bug.cgi?id=500707

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update drupal' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7315

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 11 FEDORA-2009-7315 (drupal)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"drupal", rpm:"drupal~6.13~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
