//                                               -*- C++ -*-
/**
 *  @file  InverseNormalFactory.hxx
 *  @brief Factory for InverseNormal distribution
 *
 *  Copyright 2005-2015 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author schueller
 *  @date   2011-04-11 12:32:27 +0200 (lun. 11 avril 2011)
 */
#ifndef OPENTURNS_INVERSENORMALFACTORY_HXX
#define OPENTURNS_INVERSENORMALFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"
#include "InverseNormal.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class InverseNormalFactory
 */
class OT_API InverseNormalFactory
  : public DistributionImplementationFactory
{
  CLASSNAME;
public:

  /** Default constructor */
  InverseNormalFactory();

  /** Virtual constructor */
  virtual InverseNormalFactory * clone() const;

  /* Here is the interface that all derived class must implement */
  using DistributionImplementationFactory::build;

  Implementation build(const NumericalSample & sample) const;
  Implementation build(const NumericalPointCollection & parameters) const;
  Implementation build() const;
  InverseNormal buildAsInverseNormal(const NumericalSample & sample) const;
  InverseNormal buildAsInverseNormal(const NumericalPointCollection & parameters) const;
  InverseNormal buildAsInverseNormal(const NumericalPointWithDescriptionCollection & parameters) const;
  InverseNormal buildAsInverseNormal() const;

}; /* class InverseNormalFactory */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_INVERSENORMALFACTORY_HXX */
