/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

import java.io.File;
import java.io.IOException;
import java.awt.BorderLayout;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

/**
 * @test
 * @bug 8021253
 * @author Alexander Scherbatiy
 * @summary JFileChooser does not react on pressing enter since java 7
 * @run main bug8021253
 */

public class bug8021253 {

    private static volatile boolean defaultKeyPressed;
    private static JFileChooser fileChooser;
    private static File file;

    public static void main(String[] args) throws Exception {

        Robot robot = new Robot();
        robot.setAutoDelay(50);

        SwingUtilities.invokeAndWait(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });

        robot.waitForIdle();

        SwingUtilities.invokeAndWait(new Runnable() {
            public void run() {
                fileChooser.setSelectedFile(file);
            }
        });

        robot.waitForIdle();

        robot.keyPress(KeyEvent.VK_ENTER);
        robot.keyRelease(KeyEvent.VK_ENTER);
        robot.waitForIdle();

        if (!defaultKeyPressed) {
            throw new RuntimeException("Default button is not pressed");
        }
    }

    private static void createAndShowGUI() {

        file = getTempFile();

        final JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(200, 300);

        fileChooser = new JFileChooser(file.getParentFile());
        fileChooser.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                defaultKeyPressed = true;
                frame.dispose();
            }
        });

        frame.getContentPane().add(BorderLayout.CENTER, fileChooser);
        frame.setSize(fileChooser.getPreferredSize());
        frame.setVisible(true);
    }

    private static File getTempFile() {
        try {
            File temp = File.createTempFile("test", ".txt");
            temp.deleteOnExit();
            return temp;
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}
