/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#ifndef CMPIOPENDRIM_REGISTEREDSSHPROFILE_H_
#define CMPIOPENDRIM_REGISTEREDSSHPROFILE_H_

#include "OpenDRIM_RegisteredSSHProfile.h"

CMPIObjectPath* SSH_OpenDRIM_RegisteredSSHProfile_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_RegisteredSSHProfile& instance);

CMPIInstance* SSH_OpenDRIM_RegisteredSSHProfile_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_RegisteredSSHProfile& instance);

void SSH_OpenDRIM_RegisteredSSHProfile_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_RegisteredSSHProfile& instance);

void SSH_OpenDRIM_RegisteredSSHProfile_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_RegisteredSSHProfile& instance);

void SSH_OpenDRIM_RegisteredSSHProfile_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_RegisteredSSHProfile_CloseConformantInstances_In& args);

void SSH_OpenDRIM_RegisteredSSHProfile_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_RegisteredSSHProfile_OpenConformantInstances_In& args);

void SSH_OpenDRIM_RegisteredSSHProfile_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_RegisteredSSHProfile_OpenConformantInstances_Out& args);

void SSH_OpenDRIM_RegisteredSSHProfile_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_RegisteredSSHProfile_PullConformantInstances_In& args);

void SSH_OpenDRIM_RegisteredSSHProfile_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_RegisteredSSHProfile_PullConformantInstances_Out& args);


#endif /*CMPIOPENDRIM_REGISTEREDSSHPROFILE_H_*/
