/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "OpenDRIM_OrderedMemberOfBIOSCollectionAccess.h"

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(BIOS_CIM_ManagedElement_load(broker, errorMessage));
	CF_assert(BIOS_CIM_Collection_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(BIOS_CIM_ManagedElement_unload(errorMessage));
	CF_assert(BIOS_CIM_Collection_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_isAssociated(const Instance& Member, const Instance& Collection, bool& isAssociated, string& errorMessage) {
	_E_;
	// Determine if the association can be established or not
	isAssociated=false;
	
	if(Member.getClassname().find("OpenDRIM")==0) isAssociated=true;
	_L_;
	return OK;
}

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_OrderedMemberOfBIOSCollection>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_enumerateMembers(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_enumerateMembers(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			Member_classnames[0], Collection_classnames[0],
			Member_role.c_str(), Collection_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_referenceMemberToCollection(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_OrderedMemberOfBIOSCollection& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath Member_objectpath;
	instance.getMember(Member_objectpath);
	Instance Member_instance;
	CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_getMember(broker, ctx, Member_objectpath, Member_instance, NULL, errorMessage));
	
	Objectpath Collection_objectpath;
	instance.getCollection(Collection_objectpath);
	Instance Collection_instance;
	CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_getCollection(broker, ctx, Collection_objectpath, Collection_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_isAssociated(Member_instance, Collection_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_populate(instance, errorMessage));
	_L_;
	return OK;
}

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OrderedMemberOfBIOSCollection& newInstance, const OpenDRIM_OrderedMemberOfBIOSCollection& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OrderedMemberOfBIOSCollection& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OrderedMemberOfBIOSCollection& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_associatorMemberToCollection(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Member_instance, const char** properties, vector<Instance>& Collection_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> Collection_instances;
	if (discriminant=="a")
		CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_enumerateCollections(broker, ctx, Collection_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_enumerateCollections(broker, ctx, Collection_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_enumerateCollections(broker, ctx, Collection_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<Collection_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_isAssociated(Member_instance, Collection_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			Collection_associatedInstances.push_back(Collection_instances[i]);
	}
	_L_;
	return OK;
}

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_associatorCollectionToMember(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Collection_instance, const char** properties, vector<Instance>& Member_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> Member_instances;
	if (discriminant=="a")
		CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_enumerateMembers(broker, ctx, Member_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_enumerateMembers(broker, ctx, Member_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_enumerateMembers(broker, ctx, Member_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<Member_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_isAssociated(Member_instances[i], Collection_instance, isAssociated, errorMessage));
		if (isAssociated)
			Member_associatedInstances.push_back(Member_instances[i]);
	}
	_L_;
	return OK;
}

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_referenceMemberToCollection(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Member_instance, const vector<Instance>& Collection_instances, vector<OpenDRIM_OrderedMemberOfBIOSCollection>& OpenDRIM_OrderedMemberOfBIOSCollection_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < Collection_instances.size(); i++) {
		OpenDRIM_OrderedMemberOfBIOSCollection instance;
		instance.setMember(((Instance) Member_instance).getObjectpath());
		instance.setCollection(((Instance) Collection_instances[i]).getObjectpath());
			
		if (discriminant == "r") {
			CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_populate(instance, errorMessage));
		}
		
		OpenDRIM_OrderedMemberOfBIOSCollection_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_referenceCollectionToMember(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Collection_instance, const vector<Instance>& Member_instances, vector<OpenDRIM_OrderedMemberOfBIOSCollection>& OpenDRIM_OrderedMemberOfBIOSCollection_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < Member_instances.size(); i++) {
		OpenDRIM_OrderedMemberOfBIOSCollection instance;
		instance.setMember(((Instance) Member_instances[i]).getObjectpath());
		instance.setCollection(((Instance) Collection_instance).getObjectpath());
			
		if (discriminant == "r") {
			CF_assert(BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_populate(instance, errorMessage));
		}
		
		OpenDRIM_OrderedMemberOfBIOSCollection_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_populate(OpenDRIM_OrderedMemberOfBIOSCollection& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

