function testhelper(ext, iface)
  if nargin < 2
    iface = [];
  endif
  fname = [ "debian/test." ext ];
  try
    if strcmp(ext, "xls") || strcmp(ext, "xlsx")
      xlsfinfo(fname, iface);
      d = xlsread(fname);
    else
      odsfinfo(fname, iface);
      d = odsread(fname);
    endif
    assert(size(d) == [ 1001, 2]);
    dispmsg(ext, iface, 1)
  catch
    disp(lasterror.message)
    dispmsg(ext, iface, 0)
  end_try_catch
endfunction

function dispmsg(ext, iface, success)
  if success
    r = "OK";
  else
    r = "FAIL";
  endif
  if isempty(iface)
    iface = "default interface";
  endif
  printf("\n***\n*** %-45s: %s\n***\n\n", sprintf("Read of %s file with %s", ext, iface), r);
endfunction
