// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Poly_Triangle_HeaderFile
#define _Poly_Triangle_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_OutOfRange;


//! Describes a component triangle of a triangulation <br>
//! (Poly_Triangulation object). <br>
//! A Triangle is defined by a triplet of nodes. Each node is an <br>
//! index in the table of nodes specific to an existing <br>
//! triangulation of a shape, and represents a point on the surface. <br>
class Poly_Triangle  {
public:

  DEFINE_STANDARD_ALLOC

  //! Constructs a triangle and sets all indices to zero. <br>
  Standard_EXPORT   Poly_Triangle();
  //! Constructs a triangle and sets its three indices <br>
//! to N1, N2 and N3 respectively, where these node values <br>
//!   are indices in the table of nodes specific to an existing <br>
//!   triangulation of a shape. <br>
  Standard_EXPORT   Poly_Triangle(const Standard_Integer N1,const Standard_Integer N2,const Standard_Integer N3);
  //! Sets the value of  the three nodes of this triangle to N1, N2 and N3   respectively. <br>
  Standard_EXPORT     void Set(const Standard_Integer N1,const Standard_Integer N2,const Standard_Integer N3) ;
  //! Sets the value of  the Indexth node of this triangle to Node. <br>
//! Raises OutOfRange if Index is not in 1,2,3 <br>
        void Set(const Standard_Integer Index,const Standard_Integer Node) ;
  //! Returns the node indices of this triangle in N1, N2 and N3. <br>
  Standard_EXPORT     void Get(Standard_Integer& N1,Standard_Integer& N2,Standard_Integer& N3) const;
  //! Get the node of given Index. <br>
//! Raises OutOfRange from Standard if Index is not in 1,2,3 <br>
        Standard_Integer Value(const Standard_Integer Index) const;
      Standard_Integer operator()(const Standard_Integer Index) const
{
  return Value(Index);
}
  //! Get the node of given Index. <br>
//! Raises OutOfRange if Index is not in 1,2,3 <br>
        Standard_Integer& ChangeValue(const Standard_Integer Index) ;
      Standard_Integer& operator()(const Standard_Integer Index) 
{
  return ChangeValue(Index);
}





protected:





private:



Standard_Integer myNodes[3];


};


#include <Poly_Triangle.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
