
/*
 * $Header: /cvsroot/mpdist/mpdist/mimep/ps/mimepps.c,v 1.1.1.1 2002/04/12 16:47:26 richbastard Exp $
 * 
 * Copyright (c) Mikael Cam. All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../../common/option.h"

#define MIMEMAXLINE    4096
#define MAXARRAY       1024
#define EOS            '\0'
#define MIMEPOUT       "MIMEPOUT"
#define MIMEPBOUND     "MIMEPBOUND"
#define MIMEPRULEH     "MIMEPRULEH"
#define DEFAULTB       "default"
#define NOB            "none"
#define TMPREFIX       "MIMEP"
#define TMPDIR         "/tmp"
#define PSVERSION1     "%!PS-Adobe-1.0\n"
#define PSVERSION2     "%!PS-Adobe-2.0\n"
#define PSVERSION2EPSF "%!PS-Adobe-2.0 EPSF-2.0\n"
#define PSEND1         "xt\n\nxs\n"
#define PSEND2         "end\nuserdict /end-hook known{end-hook}if\n%%EOF"
#define PAGEBEG        "%%Page:"
#define ENDDOC         "%%Trailer"
#define EPSSUFFIX      ".eps"
#define NOTHING        ""

#define True   1
#define False  0

static int _TRACE = 0;

static char *usage = "Usage: mimepps [input_file] (else stdin)\n";

static int 
cutps(char *filename)
{
    char *ERR[] = {
        "Erreur lors de l'ouverture du fichier source\n",
        "Impossible de lire la variable MIMEPOUT...\n",
        "Erreur lors de l'ouverture du fichier cible...\n",
        "Erreur lors de l'ouverture du fichier prologue temporaire...\n",
        "Version de fichier Postcript inconnue...\n",
        "Erreur lors de l'ouverture d'un fichier temporaire!\n"
    };

    FILE *fp, *prologfp, *mimepfp, *pagefp;
    char *prologfilename, *mimepout;
    int  PSVersion;
    static char pagefilename[MAXARRAY];
    char lignecour[MIMEMAXLINE], TheEnd, *boundary, *RULEH;

    if (!(mimepout = getenv(MIMEPOUT))) {
        FPRINTF(stderr, ERR[1]);
        return(1);
    }
    if (!(mimepfp = fopen(mimepout, "a"))) {
        FPRINTF(stderr, "%s", ERR[2]);
        return(1);
    }
    if (!strcmp(filename, "stdin")) {
        fp = stdin;
    } else if (!(fp = fopen(filename, "r"))) {
        FPRINTF(stderr, "%s", ERR[0]);
        return(1);
    }
    prologfilename = tempnam(TMPDIR, TMPREFIX);

    if (!(prologfp = fopen(prologfilename, "w"))) {
        FPRINTF(stderr, "%s", ERR[3]);
        return(1);
    }
    if (_TRACE) {
        FPRINTF(stderr, "Fichiers ouverts!\n");
    }

    if (!fgets(lignecour, MIMEMAXLINE, fp)) {
        lignecour[0] = EOS;
    }

    if (_TRACE) {
        FPRINTF(stderr, "PSVERSION: %s\n", lignecour);
    }

    if (!strcmp(lignecour, PSVERSION1)) {
        PSVersion = 1;
    } else if (!strcmp(lignecour, PSVERSION2)) {
        PSVersion = 2;
    } else if (!strcmp(lignecour, PSVERSION2EPSF)) {
        PSVersion = 3;
    } else {
        FPRINTF(stderr, ERR[4]);
        return(1);
    }
    FPRINTF(prologfp, "%s", lignecour);

    while (!feof(fp)) {
        if (!fgets(lignecour, MIMEMAXLINE, fp)) {
            lignecour[0] = EOS;
        }
        if (!strncmp(lignecour, PAGEBEG, strlen(PAGEBEG))) {
            break;
        }
        FPRINTF(prologfp, "%s", lignecour);
    }

    (void) fclose(prologfp);

    TheEnd = False;

    while (!TheEnd) {
        if (!(prologfp = fopen(prologfilename, "r"))) {
            FPRINTF(stderr, "%s", ERR[3]);
            return(1);
        }
        STRCPY(pagefilename, tempnam(TMPDIR, TMPREFIX));
        STRCAT(pagefilename, EPSSUFFIX);

        if (!(pagefp = fopen(pagefilename, "w"))) {
            FPRINTF(stderr, "%s", ERR[5]);
            return(1);
        }
        while (!feof(prologfp)) {
            if (!fgets(lignecour, MIMEMAXLINE, prologfp)) {
                lignecour[0] = EOS;
            }
            FPRINTF(pagefp, "%s", lignecour);
        }

        FCLOSE(prologfp);

        while ((!feof(fp)) && (!TheEnd)) {
            if (!fgets(lignecour, MIMEMAXLINE, fp)) {
                lignecour[0] = EOS;
            }
            if (!strncmp(lignecour, PAGEBEG, strlen(PAGEBEG))) {
                break;
            } else if (!strncmp(lignecour, ENDDOC, strlen(ENDDOC))) {
                TheEnd = True;
            }
            FPRINTF(pagefp, "%s", lignecour);
        }
        if (feof(fp)) {
            TheEnd = True;
        }
        FPRINTF(pagefp, "%s", (PSVersion == 1) ? PSEND1 
                                   : (PSVersion == 2) ? PSEND2 : NOTHING);
        FCLOSE(pagefp);
        FPRINTF(mimepfp, "\\centerline{\\includegraphics{%s}}\n", pagefilename);
    }
    FCLOSE(fp);

    if ((boundary = getenv(MIMEPBOUND))) {
        if (strcmp(boundary, NOB)) {
            if (!strcmp(boundary, DEFAULTB)) {
                if ((RULEH = getenv(MIMEPRULEH))) {
                    FPRINTF(mimepfp, 
                         "\\centerline{\\rule{\\textwidth}{%spt}}\n", RULEH);
                } else if ((fp = fopen(boundary, "r"))) {
                    FCLOSE(fp);
                    FPRINTF(mimepfp, "\\centerline{\\includegraphics{%s}}\n", 
                            boundary);
                }
            }
        }
    }
    FCLOSE(mimepfp);
    return(0);
}


int 
main(int argc, char *argv[])
{
    char fichier[50];

    switch (argc) {
        case 1:
            STRCPY(fichier, "stdin");
            break;
        case 2:
            STRCPY(fichier, argv[1]);
            break;
        default:
            FPRINTF(stderr, "%s", usage);
            exit(1);
    }

    return(cutps(fichier));
}
