/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQAreaSelection_H
#define MvQAreaSelection_H

#include <QBrush>
#include <QGraphicsItem>
#include <QPen>

#include "MvQPlotItem.h"

class MgQLayoutItem;

using namespace std;

class MvQAreaSelection : public MvQPlotItem
{
    Q_OBJECT

public:
    MvQAreaSelection(MgQPlotScene*, MvQPlotView*, QGraphicsItem* parent = 0);
    ~MvQAreaSelection();

    void paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*);
    QRectF boundingRect() const;

    void setArea(double, double, double, double);
    void clearArea();
    void selectAllArea();

    void setActivated(bool);

    void mousePressEventFromView(QMouseEvent*);
    void mouseMoveEventFromView(QMouseEvent*);
    void mouseReleaseEventFromView(QMouseEvent*);
    void reset();

signals:
    void areaIsDefined(double, double, double, double);
    void areaIsUndefined();

protected:
    enum CurrentAction
    {
        NoAction,
        DefineAction,
        ResizeAction,
        MoveAction
    };

    void updateHandles();
    QRectF updateControlRect(CurrentAction, QPointF&);
    void updateItemByControlRect(QRectF);
    QRectF controlRect();
    void getAreaGeoCorners(QPointF&, QPointF&);
    void checkHandleSize() const;

    QPen pen_;
    QBrush brush_;
    QRectF rect_;
    QPointF zoomRectOrigin_;
    QList<QPointF> scenePoint_;
    QList<QPointF> coordPoint_;
    CurrentAction currentAction_;
    MgQLayoutItem* zoomLayout_;
    QPointF dragPos_;

    bool showHandles_;
    QPen selectionPen_;
    mutable QList<QRectF> handle_;
    mutable float handleSize_;
    mutable float physicalHandleSize_;
    int resizeId_;
    int handleHover_;
};


#endif
