/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */
#ifndef MEDIASCANNER_METADATARESOLVER_H
#define MEDIASCANNER_METADATARESOLVER_H

// C++ Standard Library
#include <string>
#include <vector>
#include <functional>

// Media Scanner Library
#include "mediascanner/declarations.h"

namespace mediascanner {

class MetadataResolver {
    class Private;
    struct Request;

public:
    typedef std::function<void(const std::wstring &,
                                 const MediaInfo &)> StoreFunction;

    MetadataResolver();
    ~MetadataResolver();

    bool SetupSources(const std::vector<std::string> &sources);
    void WaitForFinished();

    void cancel();
    void push(const std::string &url, const MediaInfo &metadata,
              const StoreFunction &store_metadata);

    bool is_idle() const;

private:
    Private *const d;
};

} // namespace mediascanner

#endif // MEDIASCANNER_METADATARESOLVER_H
