--- status: Draft
--- author(s): M2Fest 2005 -- Irena 
--- notes: 

document { 
     Key => {permanents, (permanents,ZZ,Matrix)},
     Headline => "ideal generated by square permanents of a matrix",
     Usage => "permanents(n,M)",
     Inputs => {"n" => ZZ => "the size of the permanents",
	  "M" => Matrix
	  },
     Outputs => {Ideal=>{" generated by the permanents of the ",
          TT "n", " by ", TT "n", " subpermanents of ", TT "M"}
	  },
     "The permanent of a square matrix ", TT "N",
     " has the Laplace transform similar to the Laplace transform
     of the determinant of ", TT "N", ": but all signs are positive.
     Permanents are used in combinatorics and in probability.
     They are computationally difficult.",
     EXAMPLE {
	  "R = ZZ[a..f];",
      	  "M = genericMatrix(R,a,2,3)",
      	  "permanents(2,M)"
	  },
     Caveat => {""
	  },
     SeeAlso => {det, minors, "matrices"}
     }
