#include <stdio.h>
#include <stdlib.h>
#include <pcapnav.h>

int 
main(int argc, char** argv)
{
  int n;
  pcapnav_t *pn;
  pcapnav_cmp_t boundary;
  off_t offset;

  if (argc < 4)
    {
      printf("USAGE: %s <offset> {leq|geq|any} <filename>\n", argv[0]);
      exit(-1);
    }

  pcapnav_init();
  pcapnav_runtime_options.debug = 1;

  offset = atoi(argv[1]);

  if (! strcmp(argv[2], "leq"))
    boundary = PCAPNAV_CMP_LEQ;
  else if (! strcmp(argv[2], "geq"))
    boundary = PCAPNAV_CMP_GEQ;
  else
    boundary = PCAPNAV_CMP_ANY;

  if ((pn = pcapnav_open_offline(argv[3])) == NULL)
    {
      printf("Could not open source trace file %s\n", argv[3]);
      exit(-1);
    }

  pcapnav_goto_offset(pn, offset, boundary);

  printf("Result: %lu\n", (long unsigned) pcapnav_get_offset(pn));
  pcapnav_close(pn);

  return 0;
}
