/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.metadata.repository.test;

import org.jboss.metadata.plugins.repository.basic.BasicMetaDataRepository;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.test.metadata.repository.support.TestClass1;
import org.jboss.test.metadata.shared.support.TestAnnotation1;

/**
 * BasicMutableMetaDataRepositoryUnitTestCase.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 67291 $
 */
public class BasicMutableMetaDataRepositoryUnitTestCase extends MutableMetaDataRepositoryTest
{
   public BasicMutableMetaDataRepositoryUnitTestCase(String name)
   {
      super(name);
   }

   protected MutableMetaDataRepository setupEmpty()
   {
      return new BasicMetaDataRepository();
   }
   
   public void testAutoClassRetrieval() throws Exception
   {
      MutableMetaDataRepository repository = setupEmpty();
      ScopeKey key = new ScopeKey(new Scope(CommonLevels.CLASS, TestClass1.class));
      MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(key);
      assertNotNull(retrieval);
      MetaData metaData = new MetaDataRetrievalToMetaDataBridge(retrieval);
      assertNotNull(metaData.getAnnotation(TestAnnotation1.class));
   }
}
