package Dist::Zilla::Plugin::PodCoverageTests 6.024;
# ABSTRACT: a author test for Pod coverage

use Moose;
extends 'Dist::Zilla::Plugin::InlineFiles';
with 'Dist::Zilla::Role::PrereqSource';

# BEGIN BOILERPLATE
use v5.20.0;
use warnings;
use utf8;
no feature 'switch';
use experimental qw(postderef postderef_qq); # This experiment gets mainlined.
# END BOILERPLATE

use namespace::autoclean;

#pod =head1 SYNOPSIS
#pod
#pod     # Add this line to dist.ini
#pod     [PodCoverageTests]
#pod
#pod     # Run this in the command line to test for POD coverage:
#pod     $ dzil test --release
#pod
#pod =head1 DESCRIPTION
#pod
#pod This is an extension of L<Dist::Zilla::Plugin::InlineFiles>, providing the
#pod following files:
#pod
#pod   xt/author/pod-coverage.t - a standard Test::Pod::Coverage test
#pod
#pod This test uses L<Pod::Coverage::TrustPod> to check your Pod coverage.  This
#pod means that to indicate that some subs should be treated as covered, even if no
#pod documentation can be found, you can add:
#pod
#pod   =for Pod::Coverage sub_name other_sub this_one_too
#pod
#pod L<Test::Pod::Coverage> C<1.08> and L<Pod::Coverage::TrustPod> will be added as
#pod C<develop requires> dependencies.
#pod
#pod One can run the release tests by invoking C<dzil test --release>.
#pod
#pod =cut

# Register the author test prereq as a "develop requires"
# so it will be listed in "dzil listdeps --author"
sub register_prereqs {
  my ($self) = @_;

  $self->zilla->register_prereqs(
    {
      type  => 'requires',
      phase => 'develop',
    },
    'Test::Pod::Coverage'     => '1.08',
    'Pod::Coverage::TrustPod' => 0,
  );
}

__PACKAGE__->meta->make_immutable;
1;

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::PodCoverageTests - a author test for Pod coverage

=head1 VERSION

version 6.024

=head1 SYNOPSIS

    # Add this line to dist.ini
    [PodCoverageTests]

    # Run this in the command line to test for POD coverage:
    $ dzil test --release

=head1 DESCRIPTION

This is an extension of L<Dist::Zilla::Plugin::InlineFiles>, providing the
following files:

  xt/author/pod-coverage.t - a standard Test::Pod::Coverage test

This test uses L<Pod::Coverage::TrustPod> to check your Pod coverage.  This
means that to indicate that some subs should be treated as covered, even if no
documentation can be found, you can add:

  =for Pod::Coverage sub_name other_sub this_one_too

L<Test::Pod::Coverage> C<1.08> and L<Pod::Coverage::TrustPod> will be added as
C<develop requires> dependencies.

One can run the release tests by invoking C<dzil test --release>.

=head1 PERL VERSION

This module should work on any version of perl still receiving updates from
the Perl 5 Porters.  This means it should work on any version of perl released
in the last two to three years.  (That is, if the most recently released
version is v5.40, then this module should work on both v5.40 and v5.38.)

Although it may work on older versions of perl, no guarantee is made that the
minimum required version will not be increased.  The version may be increased
for any reason, and there is no promise that patches will be accepted to lower
the minimum required perl.

=head1 AUTHOR

Ricardo SIGNES 😏 <rjbs@semiotic.systems>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by Ricardo SIGNES.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
___[ xt/author/pod-coverage.t ]___
#!perl
# This file was automatically generated by Dist::Zilla::Plugin::PodCoverageTests.

use Test::Pod::Coverage 1.08;
use Pod::Coverage::TrustPod;

all_pod_coverage_ok({ coverage_class => 'Pod::Coverage::TrustPod' });
