local globbing = require "luacheck.globbing"

describe("globbing", function()
   describe("match", function()
      it("returns true on literal match", function()
         assert.is_true(globbing.match("foo/bar", "foo/bar"))
      end)

      it("returns true on literal match after normalization", function()
         assert.is_true(globbing.match("foo//bar/baz/..", "./foo/bar/"))
      end)

      it("returns false for on literal mismatch", function()
         assert.is_false(globbing.match("foo/bar", "foo/baz"))
      end)

      it("accepts subdirectory matches", function()
         assert.is_true(globbing.match("foo/bar", "foo/bar/baz"))
      end)

      it("understands wildcards", function()
         assert.is_true(globbing.match("*", "foo"))
         assert.is_true(globbing.match("foo/*r", "foo/bar"))
         assert.is_true(globbing.match("foo/*r", "foo/bar/baz"))
         assert.is_false(globbing.match("foo/*r", "foo/baz"))
      end)

      it("understands optional characters", function()
         assert.is_false(globbing.match("?", "foo"))
         assert.is_true(globbing.match("???", "foo"))
         assert.is_true(globbing.match("????", "foo"))
         assert.is_true(globbing.match("f?o/?a?", "foo/bar"))
         assert.is_false(globbing.match("f?o/?a?", "foo/abc"))
      end)

      it("understands ranges and classes", function()
         assert.is_true(globbing.match("[d-h]o[something]", "foo"))
         assert.is_false(globbing.match("[d-h]o[somewhere]", "bar"))
         assert.is_false(globbing.match("[.-h]o[i-z]", "bar"))
      end)

      it("accepts closing bracket as first class character", function()
         assert.is_true(globbing.match("[]]", "]"))
         assert.is_false(globbing.match("[]]", "["))
         assert.is_true(globbing.match("[]foo][]foo][]foo]", "foo"))
      end)

      it("accepts dash as first or last class character", function()
         assert.is_true(globbing.match("[-]", "-"))
         assert.is_false(globbing.match("[-]", "+"))
         assert.is_true(globbing.match("[---]", "-"))
      end)

      it("understands negation", function()
         assert.is_true(globbing.match("[!foo][!bar][!baz]", "boo"))
         assert.is_false(globbing.match("[!foo][!bar][!baz]", "far"))
         assert.is_false(globbing.match("[!a-z]", "g"))
      end)

      it("understands recursive globbing using **", function()
         assert.is_true(globbing.match("**/*.lua", "foo.lua"))
         assert.is_true(globbing.match("**/*.lua", "foo/bar.lua"))
         assert.is_false(globbing.match("foo/**/*.lua", "bar.lua"))
         assert.is_false(globbing.match("foo/**/*.lua", "foo.lua"))
         assert.is_true(globbing.match("foo/**/bar/*.lua", "foo/bar/baz.lua"))
         assert.is_true(globbing.match("foo/**/bar/*.lua", "foo/foo2/foo3/bar/baz.lua"))
         assert.is_false(globbing.match("foo/**/bar/*.lua", "foo/baz.lua"))
         assert.is_false(globbing.match("foo/**/bar/*.lua", "bar/baz.lua"))
      end)
   end)
end)
