/* Generated by GOB (v2.0.20)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 3 "loqui-sender-ipmsg.gob"

/*
 * libloqui -- Chat/IM client library for GLib <http://launchpad.net/loqui/>
 * Copyright (C) 2004 Yoichi Imai <sunnyone41@gmail.com>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the Gnome Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#line 29 "loqui-sender-ipmsg.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 20

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "loqui-sender-ipmsg.h"

#include "loqui-sender-ipmsg-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 32 "loqui-sender-ipmsg.gob"

#include <libloqui-intl.h>
#include "loqui-utils.h"

#include "loqui-socket-ipmsg.h"
#include "ipmsg_packet.h"
#include "loqui-account-ipmsg.h"
#include "ipmsg.h"

#include "loqui-message-text.h"
#include "loqui-core.h"
#include "loqui-static-core.h"


#line 65 "loqui-sender-ipmsg.c"

#line 47 "loqui-sender-ipmsg.gob"

/* account: Loqui:Account */
#define SELF_GET_ACCOUNT(sender) (LOQUI_SENDER(sender)->account)

#define SELF_GET_ACCOUNT_IPMSG(sender) (LOQUI_ACCOUNT_IPMSG(SELF_GET_ACCOUNT(self)))

#define MAX_RETRY_SENDMSG_COUNT 5
#define SENDMSG_RETRY_INTERVAL 1000 /* ms */

#line 77 "loqui-sender-ipmsg.c"
/* self casting macros */
#define SELF(x) LOQUI_SENDER_IPMSG(x)
#define SELF_CONST(x) LOQUI_SENDER_IPMSG_CONST(x)
#define IS_SELF(x) LOQUI_IS_SENDER_IPMSG(x)
#define TYPE_SELF LOQUI_TYPE_SENDER_IPMSG
#define SELF_CLASS(x) LOQUI_SENDER_IPMSG_CLASS(x)

#define SELF_GET_CLASS(x) LOQUI_SENDER_IPMSG_GET_CLASS(x)

/* self typedefs */
typedef LoquiSenderIPMsg Self;
typedef LoquiSenderIPMsgClass SelfClass;

/* here are local prototypes */
static void loqui_sender_ipmsg_init (LoquiSenderIPMsg * o) G_GNUC_UNUSED;
static void loqui_sender_ipmsg_class_init (LoquiSenderIPMsgClass * c) G_GNUC_UNUSED;
#line 64 "loqui-sender-ipmsg.gob"
static void ___1_loqui_sender_ipmsg_nick (LoquiSender * sender, const gchar * text) G_GNUC_UNUSED;
#line 96 "loqui-sender-ipmsg.c"
#line 71 "loqui-sender-ipmsg.gob"
static void ___2_loqui_sender_ipmsg_away (LoquiSender * sender, LoquiAwayType away_type, const gchar * away_message) G_GNUC_UNUSED;
#line 99 "loqui-sender-ipmsg.c"
#line 78 "loqui-sender-ipmsg.gob"
static void ___3_loqui_sender_ipmsg_say (LoquiSender * sender, LoquiChannel * channel, const gchar * text) G_GNUC_UNUSED;
#line 102 "loqui-sender-ipmsg.c"
#line 101 "loqui-sender-ipmsg.gob"
static void ___4_loqui_sender_ipmsg_start_private_talk (LoquiSender * sender, LoquiUser * user) G_GNUC_UNUSED;
#line 105 "loqui-sender-ipmsg.c"
#line 111 "loqui-sender-ipmsg.gob"
static void loqui_sender_ipmsg_send_packet_to_default (LoquiSenderIPMsg * self, IPMsgPacket * packet) G_GNUC_UNUSED;
#line 108 "loqui-sender-ipmsg.c"
#line 125 "loqui-sender-ipmsg.gob"
static void loqui_sender_ipmsg_send_packet (LoquiSenderIPMsg * self, IPMsgPacket * packet, const gchar * ip_addr, gint port) G_GNUC_UNUSED;
#line 111 "loqui-sender-ipmsg.c"
#line 140 "loqui-sender-ipmsg.gob"
static void loqui_sender_ipmsg_send_packet_with_inetaddr (LoquiSenderIPMsg * self, IPMsgPacket * packet, GInetSocketAddress * inetaddr) G_GNUC_UNUSED;
#line 114 "loqui-sender-ipmsg.c"
#line 163 "loqui-sender-ipmsg.gob"
static gint loqui_sender_ipmsg_helper_get_away_opt (LoquiUser * user) G_GNUC_UNUSED;
#line 117 "loqui-sender-ipmsg.c"
#line 172 "loqui-sender-ipmsg.gob"
static void loqui_sender_ipmsg_helper_send_br_command (LoquiSenderIPMsg * self, gint command_num) G_GNUC_UNUSED;
#line 120 "loqui-sender-ipmsg.c"
#line 190 "loqui-sender-ipmsg.gob"
static gboolean loqui_sender_ipmsg_sendmsg_timeout_cb (IPMsgPacket * packet) G_GNUC_UNUSED;
#line 123 "loqui-sender-ipmsg.c"

/* pointer to the class of our parent */
static LoquiSenderClass *parent_class = NULL;

/* Short form macros */
#define self_send_packet_to_default loqui_sender_ipmsg_send_packet_to_default
#define self_send_packet loqui_sender_ipmsg_send_packet
#define self_send_packet_with_inetaddr loqui_sender_ipmsg_send_packet_with_inetaddr
#define self_nooperation loqui_sender_ipmsg_nooperation
#define self_helper_get_away_opt loqui_sender_ipmsg_helper_get_away_opt
#define self_helper_send_br_command loqui_sender_ipmsg_helper_send_br_command
#define self_sendmsg_timeout_cb loqui_sender_ipmsg_sendmsg_timeout_cb
#define self_br_entry loqui_sender_ipmsg_br_entry
#define self_br_absence loqui_sender_ipmsg_br_absence
#define self_ansentry loqui_sender_ipmsg_ansentry
#define self_br_exit loqui_sender_ipmsg_br_exit
#define self_send_sendmsg loqui_sender_ipmsg_send_sendmsg
#define self_send_recvmsg loqui_sender_ipmsg_send_recvmsg
#define self_sendinfo loqui_sender_ipmsg_sendinfo
#define self_new loqui_sender_ipmsg_new
GType
loqui_sender_ipmsg_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LoquiSenderIPMsgClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) loqui_sender_ipmsg_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LoquiSenderIPMsg),
			0 /* n_preallocs */,
			(GInstanceInitFunc) loqui_sender_ipmsg_init,
			NULL
		};

		type = g_type_register_static (LOQUI_TYPE_SENDER, "LoquiSenderIPMsg", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LoquiSenderIPMsg *)g_object_new(loqui_sender_ipmsg_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LoquiSenderIPMsg * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LoquiSenderIPMsg *
GET_NEW_VARG (const char *first, ...)
{
	LoquiSenderIPMsg *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LoquiSenderIPMsg *)g_object_new_valist (loqui_sender_ipmsg_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::dispose"
	LoquiSenderIPMsg *self G_GNUC_UNUSED = LOQUI_SENDER_IPMSG (obj_self);
#define retring_sendmsg_list (self->retring_sendmsg_list)
#define VAR retring_sendmsg_list
	{
#line 59 "loqui-sender-ipmsg.gob"
	
		g_list_foreach(retring_sendmsg_list, (GFunc) g_object_unref, NULL);
		g_list_free(retring_sendmsg_list);
	}
#line 200 "loqui-sender-ipmsg.c"
	memset(&(retring_sendmsg_list), 0, sizeof(retring_sendmsg_list));
#undef VAR
#undef retring_sendmsg_list
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
}
#undef __GOB_FUNCTION__

static void 
loqui_sender_ipmsg_init (LoquiSenderIPMsg * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::init"
#line 47 "loqui-sender-ipmsg.gob"
	o->retring_sendmsg_list = NULL;
#line 215 "loqui-sender-ipmsg.c"
}
#undef __GOB_FUNCTION__
static void 
loqui_sender_ipmsg_class_init (LoquiSenderIPMsgClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	LoquiSenderClass *loqui_sender_class = (LoquiSenderClass *)c;

	parent_class = g_type_class_ref (LOQUI_TYPE_SENDER);

#line 64 "loqui-sender-ipmsg.gob"
	loqui_sender_class->nick = ___1_loqui_sender_ipmsg_nick;
#line 71 "loqui-sender-ipmsg.gob"
	loqui_sender_class->away = ___2_loqui_sender_ipmsg_away;
#line 78 "loqui-sender-ipmsg.gob"
	loqui_sender_class->say = ___3_loqui_sender_ipmsg_say;
#line 101 "loqui-sender-ipmsg.gob"
	loqui_sender_class->start_private_talk = ___4_loqui_sender_ipmsg_start_private_talk;
#line 235 "loqui-sender-ipmsg.c"
	g_object_class->dispose = ___dispose;
}
#undef __GOB_FUNCTION__



#line 64 "loqui-sender-ipmsg.gob"
static void 
___1_loqui_sender_ipmsg_nick (LoquiSender * sender G_GNUC_UNUSED, const gchar * text)
#line 245 "loqui-sender-ipmsg.c"
#define PARENT_HANDLER(___sender,___text) \
	{ if(LOQUI_SENDER_CLASS(parent_class)->nick) \
		(* LOQUI_SENDER_CLASS(parent_class)->nick)(___sender,___text); }
{
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::nick"
{
#line 65 "loqui-sender-ipmsg.gob"
	
		Self *self = SELF(sender);

		loqui_user_set_nick(loqui_account_get_user_self(SELF_GET_ACCOUNT(self)), text);
		self_br_absence(self);
	}}
#line 259 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 71 "loqui-sender-ipmsg.gob"
static void 
___2_loqui_sender_ipmsg_away (LoquiSender * sender G_GNUC_UNUSED, LoquiAwayType away_type, const gchar * away_message)
#line 266 "loqui-sender-ipmsg.c"
#define PARENT_HANDLER(___sender,___away_type,___away_message) \
	{ if(LOQUI_SENDER_CLASS(parent_class)->away) \
		(* LOQUI_SENDER_CLASS(parent_class)->away)(___sender,___away_type,___away_message); }
{
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::away"
{
#line 72 "loqui-sender-ipmsg.gob"
	
		Self *self = SELF(sender);

		loqui_user_set_away(loqui_account_get_user_self(SELF_GET_ACCOUNT(self)), away_type);
		self_br_absence(self);
	}}
#line 280 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 78 "loqui-sender-ipmsg.gob"
static void 
___3_loqui_sender_ipmsg_say (LoquiSender * sender G_GNUC_UNUSED, LoquiChannel * channel, const gchar * text)
#line 287 "loqui-sender-ipmsg.c"
#define PARENT_HANDLER(___sender,___channel,___text) \
	{ if(LOQUI_SENDER_CLASS(parent_class)->say) \
		(* LOQUI_SENDER_CLASS(parent_class)->say)(___sender,___channel,___text); }
{
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::say"
{
#line 79 "loqui-sender-ipmsg.gob"
	
		LoquiMember *member;
		LoquiUser *user_self;
		Self *self = SELF(sender);
		gint num, i;

		user_self = loqui_account_get_user_self(SELF_GET_ACCOUNT(self));
		num = loqui_channel_entry_get_member_number(LOQUI_CHANNEL_ENTRY(channel));
		for (i = 0; i < num; i++) {
			member = loqui_channel_entry_get_nth_member(LOQUI_CHANNEL_ENTRY(channel), i);
			if (num == 1 || member->user != user_self)
			self_send_sendmsg(self, member->user, text);
		}

		
		loqui_channel_append_remark(channel,
					    LOQUI_TEXT_TYPE_NORMAL,
					    TRUE, 
					    loqui_user_get_nick(user_self),
					    text);
	}}
#line 316 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 101 "loqui-sender-ipmsg.gob"
static void 
___4_loqui_sender_ipmsg_start_private_talk (LoquiSender * sender G_GNUC_UNUSED, LoquiUser * user)
#line 323 "loqui-sender-ipmsg.c"
#define PARENT_HANDLER(___sender,___user) \
	{ if(LOQUI_SENDER_CLASS(parent_class)->start_private_talk) \
		(* LOQUI_SENDER_CLASS(parent_class)->start_private_talk)(___sender,___user); }
{
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::start_private_talk"
{
#line 102 "loqui-sender-ipmsg.gob"
	
		gchar *identifier;

		identifier = loqui_user_get_identifier(user);
		loqui_account_open_private_talk(loqui_sender_get_account(sender), identifier, user);
		g_free(identifier);
	}}
#line 338 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 111 "loqui-sender-ipmsg.gob"
static void 
loqui_sender_ipmsg_send_packet_to_default (LoquiSenderIPMsg * self, IPMsgPacket * packet)
{
#line 346 "loqui-sender-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::send_packet_to_default"
#line 111 "loqui-sender-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 111 "loqui-sender-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SENDER_IPMSG (self));
#line 352 "loqui-sender-ipmsg.c"
{
#line 111 "loqui-sender-ipmsg.gob"
	
		LoquiAccount *account;
		LoquiSocketIPMsg *socket;

		account = SELF_GET_ACCOUNT(self);

		if (!loqui_account_get_is_connected(account)) {
			loqui_account_warning(account, _("The account is not connected."));
			return;
		}

		socket = loqui_account_ipmsg_get_socket(LOQUI_ACCOUNT_IPMSG(account));
		loqui_socket_ipmsg_send_packet_to_default(socket, packet);
	}}
#line 369 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__

#line 125 "loqui-sender-ipmsg.gob"
static void 
loqui_sender_ipmsg_send_packet (LoquiSenderIPMsg * self, IPMsgPacket * packet, const gchar * ip_addr, gint port)
{
#line 376 "loqui-sender-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::send_packet"
#line 125 "loqui-sender-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 125 "loqui-sender-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SENDER_IPMSG (self));
#line 382 "loqui-sender-ipmsg.c"
{
#line 125 "loqui-sender-ipmsg.gob"
	
		LoquiAccount *account;
		LoquiSocketIPMsg *socket;

		account = SELF_GET_ACCOUNT(self);

		if (!loqui_account_get_is_connected(account)) {
			loqui_account_warning(account, _("The account is not connected."));
			return;
		}
		
		socket = loqui_account_ipmsg_get_socket(LOQUI_ACCOUNT_IPMSG(account));
		loqui_socket_ipmsg_send_packet(socket, packet, ip_addr, port);
	}}
#line 399 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__

#line 140 "loqui-sender-ipmsg.gob"
static void 
loqui_sender_ipmsg_send_packet_with_inetaddr (LoquiSenderIPMsg * self, IPMsgPacket * packet, GInetSocketAddress * inetaddr)
{
#line 406 "loqui-sender-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::send_packet_with_inetaddr"
#line 140 "loqui-sender-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 140 "loqui-sender-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SENDER_IPMSG (self));
#line 412 "loqui-sender-ipmsg.c"
{
#line 140 "loqui-sender-ipmsg.gob"
	
		LoquiAccount *account;
		LoquiSocketIPMsg *socket;

		account = SELF_GET_ACCOUNT(self);

		if (!loqui_account_get_is_connected(account)) {
			loqui_account_warning(account, _("The account is not connected."));
			return;
		}
		
		socket = loqui_account_ipmsg_get_socket(LOQUI_ACCOUNT_IPMSG(account));
		loqui_socket_ipmsg_send_packet_with_inetaddr(socket, packet, inetaddr);
	}}
#line 429 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__

#line 155 "loqui-sender-ipmsg.gob"
void 
loqui_sender_ipmsg_nooperation (LoquiSenderIPMsg * self)
{
#line 436 "loqui-sender-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::nooperation"
#line 155 "loqui-sender-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 155 "loqui-sender-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SENDER_IPMSG (self));
#line 442 "loqui-sender-ipmsg.c"
{
#line 155 "loqui-sender-ipmsg.gob"
	
		IPMsgPacket *packet;

		packet = loqui_account_ipmsg_create_packet(SELF_GET_ACCOUNT_IPMSG(self), IPMSG_NOOPERATION, NULL);
		self_send_packet_to_default(self, packet);
		g_object_unref(packet);
	}}
#line 452 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__

#line 163 "loqui-sender-ipmsg.gob"
static gint 
loqui_sender_ipmsg_helper_get_away_opt (LoquiUser * user)
{
#line 459 "loqui-sender-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::helper_get_away_opt"
{
#line 163 "loqui-sender-ipmsg.gob"
	
		LoquiAwayType away_type = loqui_user_get_away(user);

		if (away_type == LOQUI_AWAY_TYPE_ONLINE)
			return 0;

		return IPMSG_ABSENCEOPT;
	}}
#line 471 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__

#line 172 "loqui-sender-ipmsg.gob"
static void 
loqui_sender_ipmsg_helper_send_br_command (LoquiSenderIPMsg * self, gint command_num)
{
#line 478 "loqui-sender-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::helper_send_br_command"
#line 172 "loqui-sender-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 172 "loqui-sender-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SENDER_IPMSG (self));
#line 484 "loqui-sender-ipmsg.c"
{
#line 172 "loqui-sender-ipmsg.gob"
	
		IPMsgPacket *packet;
		LoquiUser *user_self;
		const gchar *nick;

		loqui_sender_ipmsg_nooperation(self);
		
		user_self = loqui_account_get_user_self(SELF_GET_ACCOUNT(self));
		nick = loqui_user_get_nick(user_self);
		command_num |= self_helper_get_away_opt(user_self);

		packet = loqui_account_ipmsg_create_packet(SELF_GET_ACCOUNT_IPMSG(self),
							   command_num,
							   nick);
		self_send_packet_to_default(self, packet);
		g_object_unref(packet);
	}}
#line 504 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__

#line 190 "loqui-sender-ipmsg.gob"
static gboolean 
loqui_sender_ipmsg_sendmsg_timeout_cb (IPMsgPacket * packet)
{
#line 511 "loqui-sender-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::sendmsg_timeout_cb"
{
#line 190 "loqui-sender-ipmsg.gob"
	
		Self *self = g_object_get_data(G_OBJECT(packet), "sender-ipmsg");
		const gchar *ip_addr;
		gint port, retry_count;
		GList *cur;

		if ((cur = g_list_find(self->retring_sendmsg_list, packet)) != NULL) {
			ip_addr = g_object_get_data(G_OBJECT(packet), "dest-ip-addr");
			port = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(packet), "dest-port"));
			retry_count = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(packet), "retry-count"));

			if (retry_count >= MAX_RETRY_SENDMSG_COUNT) {
				self->retring_sendmsg_list = g_list_delete_link(self->retring_sendmsg_list, cur);
				g_object_unref(packet);
				return FALSE;
			}
			self_send_packet(self, packet, ip_addr, port);
			g_object_set_data(G_OBJECT(packet), "retry-count", GINT_TO_POINTER(retry_count + 1));

			return TRUE;
		}

		g_object_unref(packet);
		return FALSE;
	}}
#line 540 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__

#line 216 "loqui-sender-ipmsg.gob"
void 
loqui_sender_ipmsg_br_entry (LoquiSenderIPMsg * self)
{
#line 547 "loqui-sender-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::br_entry"
#line 216 "loqui-sender-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 216 "loqui-sender-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SENDER_IPMSG (self));
#line 553 "loqui-sender-ipmsg.c"
{
#line 216 "loqui-sender-ipmsg.gob"
	
		self_helper_send_br_command(self, IPMSG_BR_ENTRY);
	}}
#line 559 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__

#line 219 "loqui-sender-ipmsg.gob"
void 
loqui_sender_ipmsg_br_absence (LoquiSenderIPMsg * self)
{
#line 566 "loqui-sender-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::br_absence"
#line 219 "loqui-sender-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 219 "loqui-sender-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SENDER_IPMSG (self));
#line 572 "loqui-sender-ipmsg.c"
{
#line 219 "loqui-sender-ipmsg.gob"
	
		self_helper_send_br_command(self, IPMSG_BR_ABSENCE);
	}}
#line 578 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__

#line 222 "loqui-sender-ipmsg.gob"
void 
loqui_sender_ipmsg_ansentry (LoquiSenderIPMsg * self)
{
#line 585 "loqui-sender-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::ansentry"
#line 222 "loqui-sender-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 222 "loqui-sender-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SENDER_IPMSG (self));
#line 591 "loqui-sender-ipmsg.c"
{
#line 222 "loqui-sender-ipmsg.gob"
	
		self_helper_send_br_command(self, IPMSG_ANSENTRY);
	}}
#line 597 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__

#line 225 "loqui-sender-ipmsg.gob"
void 
loqui_sender_ipmsg_br_exit (LoquiSenderIPMsg * self)
{
#line 604 "loqui-sender-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::br_exit"
#line 225 "loqui-sender-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 225 "loqui-sender-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SENDER_IPMSG (self));
#line 610 "loqui-sender-ipmsg.c"
{
#line 225 "loqui-sender-ipmsg.gob"
	
		self_helper_send_br_command(self, IPMSG_BR_EXIT);
	}}
#line 616 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__

#line 229 "loqui-sender-ipmsg.gob"
void 
loqui_sender_ipmsg_send_sendmsg (LoquiSenderIPMsg * self, LoquiUser * user, const gchar * text)
{
#line 623 "loqui-sender-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::send_sendmsg"
#line 229 "loqui-sender-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 229 "loqui-sender-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SENDER_IPMSG (self));
#line 629 "loqui-sender-ipmsg.c"
{
#line 229 "loqui-sender-ipmsg.gob"
	
		IPMsgPacket *packet;
		const gchar *ip_addr;
		gint port;

		packet = loqui_account_ipmsg_create_packet(SELF_GET_ACCOUNT_IPMSG(self),
							   IPMSG_SENDMSG | IPMSG_SENDCHECKOPT,
							   text);
		
		self->retring_sendmsg_list = g_list_prepend(self->retring_sendmsg_list, packet);

		ip_addr = loqui_user_ipmsg_get_ip_addr(LOQUI_USER_IPMSG(user));
		port = loqui_user_ipmsg_get_port(LOQUI_USER_IPMSG(user));

		self_send_packet(self, packet, ip_addr, port);

		g_object_set_data(G_OBJECT(packet), "sender-ipmsg", self);
		g_object_set_data_full(G_OBJECT(packet), "dest-ip-addr", g_strdup(ip_addr), (GDestroyNotify) g_free);
		g_object_set_data(G_OBJECT(packet), "dest-port", GINT_TO_POINTER(port));
		g_object_set_data(G_OBJECT(packet), "retry-count", GINT_TO_POINTER(1));

		g_timeout_add(SENDMSG_RETRY_INTERVAL, (GSourceFunc) self_sendmsg_timeout_cb, packet);
	}}
#line 655 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__

#line 253 "loqui-sender-ipmsg.gob"
void 
loqui_sender_ipmsg_send_recvmsg (LoquiSenderIPMsg * self, gint orig_packet_num, GInetSocketAddress * dest_inetaddr)
{
#line 662 "loqui-sender-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::send_recvmsg"
#line 253 "loqui-sender-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 253 "loqui-sender-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SENDER_IPMSG (self));
#line 668 "loqui-sender-ipmsg.c"
{
#line 253 "loqui-sender-ipmsg.gob"
	
		IPMsgPacket *packet;
		gchar *tmp;
		
		tmp = g_strdup_printf("%d", orig_packet_num);
		packet = loqui_account_ipmsg_create_packet(SELF_GET_ACCOUNT_IPMSG(self),
							   IPMSG_RECVMSG,
							   tmp);
		g_free(tmp);
		
		self_send_packet_with_inetaddr(self, packet, dest_inetaddr);
		g_object_unref(packet);
	}}
#line 684 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__

#line 267 "loqui-sender-ipmsg.gob"
void 
loqui_sender_ipmsg_sendinfo (LoquiSenderIPMsg * self, GInetSocketAddress * dest_inetaddr)
{
#line 691 "loqui-sender-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::sendinfo"
#line 267 "loqui-sender-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 267 "loqui-sender-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_SENDER_IPMSG (self));
#line 697 "loqui-sender-ipmsg.c"
{
#line 268 "loqui-sender-ipmsg.gob"
	
		IPMsgPacket *packet;
		gchar *version;

		version = loqui_core_get_version_info(loqui_get_core());
		packet = loqui_account_ipmsg_create_packet(SELF_GET_ACCOUNT_IPMSG(self),
							   IPMSG_SENDINFO,
							   version);
		g_free(version);

		self_send_packet_with_inetaddr(self, packet, dest_inetaddr);
		g_object_unref(packet);
	}}
#line 713 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__

#line 282 "loqui-sender-ipmsg.gob"
LoquiSenderIPMsg * 
loqui_sender_ipmsg_new (LoquiAccount * account)
{
#line 720 "loqui-sender-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Sender:IPMsg::new"
{
#line 283 "loqui-sender-ipmsg.gob"
	
		Self *self;

		self = GET_NEW;
		LOQUI_SENDER(self)->account = account;
		
		return self;
	}}
#line 732 "loqui-sender-ipmsg.c"
#undef __GOB_FUNCTION__
