/* $Id: we_misc.c 1143 2011-02-13 16:13:58Z ekalin $ */

/*
 * Copyright (C) 2004-2011 Eduardo M Kalinowski <eduardo@kalinowski.com.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <kcconfig.h>
#endif

#include <string.h>
#include <libintl.h>
#include <gtk/gtk.h>
#include <gmodule.h>

#include "simocombobox.h"

#include "kildclient.h"
#include "perlscript.h"


/***********************
 * Function prototypes *
 ***********************/


GObject *
get_we_misc_tab(GtkBuilder *ui_builder)
{
  GObject *panel;

  panel = gtk_builder_get_object(ui_builder, "we_panel_misc");

  return panel;
}


void
fill_we_misc_tab(World *world, GtkBuilder *ui_builder)
{
  GtkToggleButton *chkScrollOutput;
  GtkSpinButton   *txtBufferLines;
  GtkToggleButton *radNameDisplayWorld;
  GtkToggleButton *radNameDisplayWorldChar;
  GtkToggleButton *radNameDisplayCharWorld;
  GtkToggleButton *radNameDisplayCustom;
  GtkEntry        *txtNameDisplayCustom;

  if (!world) {
    return;
  }

  /* Get widgets */
  chkScrollOutput
    = GTK_TOGGLE_BUTTON(gtk_builder_get_object(ui_builder, "chkScrollOutput"));
  txtBufferLines
    = GTK_SPIN_BUTTON(gtk_builder_get_object(ui_builder, "txtBufferLines"));
  radNameDisplayWorld
    = GTK_TOGGLE_BUTTON(gtk_builder_get_object(ui_builder, "radNameDisplayWorld"));
  radNameDisplayWorldChar
    = GTK_TOGGLE_BUTTON(gtk_builder_get_object(ui_builder, "radNameDisplayWorldChar"));
  radNameDisplayCharWorld
    = GTK_TOGGLE_BUTTON(gtk_builder_get_object(ui_builder, "radNameDisplayCharWorld"));
  radNameDisplayCustom
    = GTK_TOGGLE_BUTTON(gtk_builder_get_object(ui_builder, "radNameDisplayCustom"));
  txtNameDisplayCustom
    = GTK_ENTRY(gtk_builder_get_object(ui_builder, "txtNameDisplayCustom"));

  gtk_toggle_button_set_active(chkScrollOutput, world->scrollOutput);
  gtk_spin_button_set_value(txtBufferLines, world->buffer_lines);

  switch (world->name_display_style) {
  case NAME_DISPLAY_WORLD:
    gtk_toggle_button_set_active(radNameDisplayWorld, TRUE);
    break;

  case NAME_DISPLAY_WORLD_CHAR:
    gtk_toggle_button_set_active(radNameDisplayWorldChar, TRUE);
    break;

  case NAME_DISPLAY_CHAR_WORLD:
    gtk_toggle_button_set_active(radNameDisplayCharWorld, TRUE);
    break;

  case NAME_DISPLAY_CUSTOM:
    gtk_toggle_button_set_active(radNameDisplayCustom, TRUE);
    break;
  }
  gtk_entry_set_text(txtNameDisplayCustom, world->name_display_pattern);
}



void
update_we_misc_parameters(World *world, GtkBuilder *ui_builder)
{
  GtkToggleButton *chkScrollOutput;
  GtkSpinButton   *txtBufferLines;
  GtkToggleButton *radNameDisplayWorld;
  GtkToggleButton *radNameDisplayWorldChar;
  GtkToggleButton *radNameDisplayCharWorld;
  GtkToggleButton *radNameDisplayCustom;
  GtkEntry        *txtNameDisplayCustom;

  const gchar *newval;


  /* Get widgets */
  chkScrollOutput
    = GTK_TOGGLE_BUTTON(gtk_builder_get_object(ui_builder, "chkScrollOutput"));
  txtBufferLines
    = GTK_SPIN_BUTTON(gtk_builder_get_object(ui_builder, "txtBufferLines"));
  radNameDisplayWorld
    = GTK_TOGGLE_BUTTON(gtk_builder_get_object(ui_builder, "radNameDisplayWorld"));
  radNameDisplayWorldChar
    = GTK_TOGGLE_BUTTON(gtk_builder_get_object(ui_builder, "radNameDisplayWorldChar"));
  radNameDisplayCharWorld
    = GTK_TOGGLE_BUTTON(gtk_builder_get_object(ui_builder, "radNameDisplayCharWorld"));
  radNameDisplayCustom
    = GTK_TOGGLE_BUTTON(gtk_builder_get_object(ui_builder, "radNameDisplayCustom"));
  txtNameDisplayCustom
    = GTK_ENTRY(gtk_builder_get_object(ui_builder, "txtNameDisplayCustom"));

  world->scrollOutput = gtk_toggle_button_get_active(chkScrollOutput);

  world->buffer_lines = gtk_spin_button_get_value_as_int(txtBufferLines);

  if (gtk_toggle_button_get_active(radNameDisplayWorld)) {
    world->name_display_style = NAME_DISPLAY_WORLD;
  } else if (gtk_toggle_button_get_active(radNameDisplayWorldChar)) {
    world->name_display_style = NAME_DISPLAY_WORLD_CHAR;
  } else if (gtk_toggle_button_get_active(radNameDisplayCharWorld)) {
    world->name_display_style = NAME_DISPLAY_CHAR_WORLD;
  } else if (gtk_toggle_button_get_active(radNameDisplayCustom)) {
    world->name_display_style = NAME_DISPLAY_CUSTOM;
  }

  newval = gtk_entry_get_text(txtNameDisplayCustom);
  if (!world->name_display_pattern
      || strcmp(world->name_display_pattern, newval) != 0) {
    g_free(world->name_display_pattern);
    world->name_display_pattern = g_strdup(newval);
  }
}
