#ifndef _GCRYPT_GLUE
#define _GCRYPT_GLUE

#include "KayaAPI.h"
#include <gcrypt.h>
#include <gc/gc_cpp.h>

struct GcryptData : public gc {
    gcry_cipher_handle* handle;
    int algo;
};

struct GcryptHash : public gc {
    gcry_md_handle* handle;
    int algo;
    int size;
};

extern "C" {
    int cipheralgo(KayaValue c);
    int ciphermode(KayaValue c);
    int hashalgo(KayaValue c);

    int cipherKeySize(int c);
    int cipherBlockLength(int c);

    void* cipherOpen(KayaValue algo, KayaValue mode, int flags);
    void cipherClose(void* ptr);

    void do_setkey(void* ptr, KayaArray key);
    void do_setivec(void* ptr, KayaArray vec);

    void* do_encrypt(void* h, void* data, int size, KayaValue outsize);
    void* do_decrypt(void* h, void* data, int size, KayaValue outsize);

    void* hashOpen(KayaValue algo, int flags);
    void hashClose(void* ptr);
    void hashReset(void* ptr);
    void hashWrite(void* ptr, void* data, int size);
    void hashFinal(void* ptr);
    void* hashGet(void* ptr, KayaValue size);

    KayaArray appKey();
    KayaArray appIVec();
}

#endif
