/*
 * Copyright 2004-2005 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sf.jml.message.invitation;

import net.sf.jml.MsnContact;
import net.sf.jml.protocol.MsnSession;

/**
 * The accept message that jml not supported.
 * 
 * @author Roger Chen
 */
final class MsnUnknownAcceptMessage extends MsnAcceptMessage {

    public MsnUnknownAcceptMessage(MsnInviteMessage invite) {
        super(invite);
    }

    @Override
	protected void messageReceived(MsnSession session, MsnContact contact) {
        super.messageReceived(session, contact);

        MsnCancelMessage message = new MsnCancelMessage(getInviteMessage());
        message.setCancelCode(MsnCancelMessage.REJECT);
        session.getSwitchboard().sendMessage(message);
    }
}