      SUBROUTINE TSRFAC	(nplot, IERROR)
C
C LATEST REVISION	 MARCH 1984
C
C PURPOSE		 TO PROVIDE A SIMPLE DEMONSTRATION OF
C			 SRFACE	AND TO TEST SRFACE ON A	SINGLE
C			 PROBLEM
C
C USAGE			 CALL TSRFAC (IERROR)
C
C ARGUMENTS
c +noao: additional input parameter
c			 nplot
c		 	   = 1, EZSRF is demonstrated
c			   = 2, SRFACE is demonstrated
c
C
C ON OUTPUT		 IERROR
C			   AN INTEGER VARIABLE
C			   = 0,	IF THE TEST IS SUCCESSFUL,
C			   = 1,	OTHERWISE
C
C I/O			 IF THE	TEST IS	SUCCESSFUL, THE	MESSAGE
C
C			   SRFACE TEST SUCCESSFUL  . . .  SEE PLOT TO
C			   VERIFY PERFORMANCE
C
C			 IS PRINTED ON UNIT 6.
C
C			 IN ADDITION, TWO FRAMES CONTAINING THE
C			 SURFACE PLOT ARE PRODUCED ON THE MACHINE
C			 GRAPHICS DEVICE.  IN ORDER TO DETERMINE
C			 IF THE	TEST WAS SUCCESSFUL, IT	IS
C			 NECESSARY TO EXAMINE THESE PLOTS.
C
C PRECISION		 SINGLE
C
C REQUIRED LIBRARY	 SRFACE
C FILES
C
C LANGUAGE		 FORTRAN
C
C HISTORY		 FIRST WRITTEN IN APRIL	1979, CONVERTED	TO
C			 FORTRAN 77 AND	GKS IN MARCH 1984.
C
C ALGORITHM		 THE FUNCTION
C
C			   Z(X,Y) = .25*(X + Y + 1./((X-.1)**2+Y**2+.09)
C					  - 1./((X+.1)**2+Y**2+.09))
C
C			 IS EVALUATED FOR
C			   X = -1. TO 1. IN INCREMENTS OF .1 AND
C			   Y = -1.2 TO 1.2 IN INCREMENTS OF .1.
C			 TSRFAC	CALLS SUBROUTINES EZSRFC AND SRFACE
C			 ONCE.	EACH CALL PRODUCES A SURFACE PLOT
C			 OF THE	ARRAY Z.
C
C PORTABILITY		 ANSI FORTRAN 77
C
C XX CONTAINS THE X-DIRECTION COORDINATE VALUES	FOR Z(X,Y),  YY	CONTAINS
C THE Y-DIRECTION COORDINATE VALUES FOR	Z(X,Y),	 Z CONTAINS THE	FUNCTION
C VALUES,  S CONTAINS VALUES FOR THE LINE OF SIGHT FOR ENTRY SRFACE,
C WORK IS A WORK ARRAY,	 ANGH CONTAINS THE ANGLE IN DEGREES IN THE X-Y
C PLANE	TO THE LINE OF SIGHT,  ANGV CONTAINS THE ANGLE IN DEGREES FROM
C THE X-Y PLANE	TO THE LINE OF SIGHT.
C
      REAL	      XX(21)	 ,YY(25)     ,Z(21,25)	 ,S(6)	     ,
     1		      WORK(1096)
C
      DATA  S(1), S(2),	S(3), S(4), S(5), S(6)/
     1	    -8.0, -6.0,	 3.0,  0.0,  0.0,  0.0/
C
      DATA  ANGH/45./, ANGV/15./
C
C SPECIFY COORDINATES FOR PLOT TITLES.	ON AN ABSTRACT GRID WHERE
C THE COORDINATES RANGE	FROM 0.	TO 1., THE VALUES CX AND CY
C DEFINE THE CENTER OF THE TITLE STRING.
C
      DATA CX/.405/, CY/.97/
C
C INITIALIZE ERROR PARAMETER
C
      IERROR = 0
C
C FILL XX AND YY COORDINATE ARRAYS AND Z FUNCTION VALUE	ARRAY
C
      DO  20 I=1,21
	 X = .1*FLOAT(I-11)
	 XX(I) = X
	 DO  10	J=1,25
	    Y =	.1*FLOAT(J-13)
	    YY(J) = Y
	    Z(I,J) = (X+Y+1./((X-.1)**2+Y**2+.09)-
     1					    1./((X+.1)**2+Y**2+.09))*.25
   10	 CONTINUE
   20 CONTINUE
C
C SELECT NORMALIZATION TRANSFORMATION 0
C
      CALL GSELNT(0)
C
C EZSRFC DEMO
C
C LABEL	THE PLOT FOR ENTRY EZSRFC
C
C SET TEXT ALIGNMENT TO	CENTER THE STRING AT THE STRING	CENTER
C AND IN THE VERTICAL CENTER
C
      CALL GSTXAL(2,3)
C
C SET CHARACTER	HEIGHT
C
      CALL GSCHH(.016)
C
C PLOT CHARACTERS
C
      if (nplot .eq. 1) then
      CALL GTX(CX,CY,'DEMONSTRATION PLOT FOR EZSRFC ENTRY OF SRFACE')
      CALL EZSRFC (Z,21,25,ANGH,ANGV,WORK)
      endif
C
C
C SRFACE DEMO
C
C LABEL	THE PLOT FOR ENTRY SRFACE
C
C SET TEXT ALIGNMENT TO	CENTER THE STRING AT THE STRING	CENTER
C AND IN THE VERTICAL CENTER
C
      CALL GSTXAL(2,3)
C
C SET CHARACTER	HEIGHT
C
      CALL GSCHH(.016)
C
C PLOT CHARACTERS
C
      if (nplot .eq. 2) then
      CALL GTX(CX,CY,'DEMONSTRATION PLOT FOR SRFACE ENTRY OF SRFACE')
      CALL SRFACE (XX,YY,Z,WORK,21,21,25,S,0.)
      endif
C
c     WRITE (6,1001)
C
      RETURN
C
C1001 FORMAT ('	    SRFACE TEST	SUCCESSFUL',24X,
C    1	      'SEE PLOT	TO VERIFY PERFORMANCE')
C
      END
